/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.scope;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;

/**
 * ^T̃CX^X{@link ThreadLocal}ɂĊǗXR[vAme[V̎łB
 * CX^X{@link Key<T>}<code>key</code>{@link HashMap}֕ێ܂B
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class ThreadLocalScopeImpl implements Scope {
	private static final Log log = LogFactory.getLog(ThreadLocalScopeImpl.class);
	private static final ThreadLocal<Map<Key,Object>> threadLocals = new ThreadLocal<Map<Key,Object>>(){
		protected Map<Key,Object> initialValue() {
			return new HashMap<Key, Object>();
		};
	};

	public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
		return new Provider<T>() {

			@SuppressWarnings("unchecked")
			public T get() {
				Map<Key,Object> map = threadLocals.get();
				if (!map.containsKey(key)){
					map.put(key, creator.get());
					if (log.isDebugEnabled()){
						log.debug("[" +Thread.currentThread().getName() + "] registed key[" + key + "] to thread-local");
					}
				}else{
					if (log.isDebugEnabled()){
						log.debug("[" + Thread.currentThread().getName() + "] get registed key[" + key + "] from thread-local");
					}
				}
				return (T)map.get(key);
			}

			public String toString() {
				return creator.toString();
			}
		};
	}

	public String toString() {
		return "Scopes.THREAD_LOCAL";
	}
}

