package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Cities implements Serializable {
	@Id
	@Column(name="CITY_ID")
	private int cityId;

	private String language;

	private String airport;

	private String country;

	@Column(name="CITY_NAME")
	private String cityName;

	@ManyToOne
	@JoinColumn(name="COUNTRY_ISO_CODE")
	private Countries countryIsoCode;

	private static final long serialVersionUID = 1L;

	public Cities() {
		super();
	}

	public int getCityId() {
		return this.cityId;
	}

	public void setCityId(int cityId) {
		this.cityId = cityId;
	}

	public String getLanguage() {
		return this.language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public String getAirport() {
		return this.airport;
	}

	public void setAirport(String airport) {
		this.airport = airport;
	}

	public String getCountry() {
		return this.country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getCityName() {
		return this.cityName;
	}

	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	public Countries getCountryIsoCode() {
		return this.countryIsoCode;
	}

	public void setCountryIsoCode(Countries countryIsoCode) {
		this.countryIsoCode = countryIsoCode;
	}

}
