package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.sql.Time;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

@Entity
public class Flights implements Serializable {
	@EmbeddedId
	private Flights.PK pk;

	private String meal;

	private String aircraft;

	@Column(name="FLYING_TIME")
	private double flyingTime;

	@Column(name="DEPART_TIME")
	private Time departTime;

	@Column(name="ARRIVE_TIME")
	private Time arriveTime;

	private int miles;

	@Column(name="DEST_AIRPORT")
	private String destAirport;

	@Column(name="ORIG_AIRPORT")
	private String origAirport;

	@OneToMany(mappedBy="flights")
	private Set<Flightavailability> flightavailabilityCollection;

	private static final long serialVersionUID = 1L;

	public Flights() {
		super();
	}

	public Flights.PK getPk() {
		return this.pk;
	}

	public void setPk(Flights.PK pk) {
		this.pk = pk;
	}

	public String getMeal() {
		return this.meal;
	}

	public void setMeal(String meal) {
		this.meal = meal;
	}

	public String getAircraft() {
		return this.aircraft;
	}

	public void setAircraft(String aircraft) {
		this.aircraft = aircraft;
	}

	public double getFlyingTime() {
		return this.flyingTime;
	}

	public void setFlyingTime(double flyingTime) {
		this.flyingTime = flyingTime;
	}

	public Time getDepartTime() {
		return this.departTime;
	}

	public void setDepartTime(Time departTime) {
		this.departTime = departTime;
	}

	public Time getArriveTime() {
		return this.arriveTime;
	}

	public void setArriveTime(Time arriveTime) {
		this.arriveTime = arriveTime;
	}

	public int getMiles() {
		return this.miles;
	}

	public void setMiles(int miles) {
		this.miles = miles;
	}

	public String getDestAirport() {
		return this.destAirport;
	}

	public void setDestAirport(String destAirport) {
		this.destAirport = destAirport;
	}

	public String getOrigAirport() {
		return this.origAirport;
	}

	public void setOrigAirport(String origAirport) {
		this.origAirport = origAirport;
	}

	public Set<Flightavailability> getFlightavailabilityCollection() {
		return this.flightavailabilityCollection;
	}

	public void setFlightavailabilityCollection(Set<Flightavailability> flightavailabilityCollection) {
		this.flightavailabilityCollection = flightavailabilityCollection;
	}


	@Embeddable
	public static class PK implements Serializable {
		@Column(name="FLIGHT_ID")
		private String flightId;
		@Column(name="SEGMENT_NUMBER")
		private int segmentNumber;
		private static final long serialVersionUID = 1L;

		public PK() {
			super();
		}

		public String getFlightId() {
			return this.flightId;
		}

		public void setFlightId(String flightId) {
			this.flightId = flightId;
		}

		public int getSegmentNumber() {
			return this.segmentNumber;
		}

		public void setSegmentNumber(int segmentNumber) {
			this.segmentNumber = segmentNumber;
		}

		@Override
		public boolean equals(Object o) {
			if (o == this) {
				return true;
			}
			if ( ! (o instanceof PK)) {
				return false;
			}
			PK other = (PK) o;
			return this.flightId.equals(other.flightId)
				&& (this.segmentNumber == other.segmentNumber);
		}

		@Override
		public int hashCode() {
			return this.flightId.hashCode()
				^ this.segmentNumber;
		}

	}

}
