package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.sql.Time;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="FLIGHTS_HISTORY")
public class FlightsHistory implements Serializable {
	@Column(name="ORIG_AIRPORT")
	private String origAirport;

	@Column(name="DEST_AIRPORT")
	private String destAirport;

	private String meal;

	@Column(name="FLYING_TIME")
	private double flyingTime;

	private int miles;

	@Column(name="SEGMENT_NUMBER")
	private int segmentNumber;

	private String aircraft;

	@Column(name="DEPART_TIME")
	private Time departTime;

	private String status;

	@Id
	@Column(name="FLIGHT_ID")
	private String flightId;

	@Column(name="ARRIVE_TIME")
	private Time arriveTime;

	private static final long serialVersionUID = 1L;

	public FlightsHistory() {
		super();
	}

	public String getOrigAirport() {
		return this.origAirport;
	}

	public void setOrigAirport(String origAirport) {
		this.origAirport = origAirport;
	}

	public String getDestAirport() {
		return this.destAirport;
	}

	public void setDestAirport(String destAirport) {
		this.destAirport = destAirport;
	}

	public String getMeal() {
		return this.meal;
	}

	public void setMeal(String meal) {
		this.meal = meal;
	}

	public double getFlyingTime() {
		return this.flyingTime;
	}

	public void setFlyingTime(double flyingTime) {
		this.flyingTime = flyingTime;
	}

	public int getMiles() {
		return this.miles;
	}

	public void setMiles(int miles) {
		this.miles = miles;
	}

	public int getSegmentNumber() {
		return this.segmentNumber;
	}

	public void setSegmentNumber(int segmentNumber) {
		this.segmentNumber = segmentNumber;
	}

	public String getAircraft() {
		return this.aircraft;
	}

	public void setAircraft(String aircraft) {
		this.aircraft = aircraft;
	}

	public Time getDepartTime() {
		return this.departTime;
	}

	public void setDepartTime(Time departTime) {
		this.departTime = departTime;
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getFlightId() {
		return this.flightId;
	}

	public void setFlightId(String flightId) {
		this.flightId = flightId;
	}

	public Time getArriveTime() {
		return this.arriveTime;
	}

	public void setArriveTime(Time arriveTime) {
		this.arriveTime = arriveTime;
	}

}
