package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
public class Invoice implements Serializable {
	@Id
	private BigDecimal id;

	private BigDecimal total;

	@ManyToOne
	@JoinColumn(name="CUSTOMERID")
	private Customer customerid;

	@OneToMany(mappedBy="invoiceid")
	private Set<Item> itemCollection;

	private static final long serialVersionUID = 1L;

	public Invoice() {
		super();
	}

	public BigDecimal getId() {
		return this.id;
	}

	public void setId(BigDecimal id) {
		this.id = id;
	}

	public BigDecimal getTotal() {
		return this.total;
	}

	public void setTotal(BigDecimal total) {
		this.total = total;
	}

	public Customer getCustomerid() {
		return this.customerid;
	}

	public void setCustomerid(Customer customerid) {
		this.customerid = customerid;
	}

	public Set<Item> getItemCollection() {
		return this.itemCollection;
	}

	public void setItemCollection(Set<Item> itemCollection) {
		this.itemCollection = itemCollection;
	}

}
