package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Item implements Serializable {
	@EmbeddedId
	private Item.PK pk;

	private BigDecimal quantity;

	private BigDecimal cost;

	private BigDecimal productid;

	@ManyToOne
	@JoinColumn(name="INVOICEID")
	private Invoice invoiceid;

	private static final long serialVersionUID = 1L;

	public Item() {
		super();
	}

	public Item.PK getPk() {
		return this.pk;
	}

	public void setPk(Item.PK pk) {
		this.pk = pk;
	}

	public BigDecimal getQuantity() {
		return this.quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public BigDecimal getCost() {
		return this.cost;
	}

	public void setCost(BigDecimal cost) {
		this.cost = cost;
	}

	public BigDecimal getProductid() {
		return this.productid;
	}

	public void setProductid(BigDecimal productid) {
		this.productid = productid;
	}

	public Invoice getInvoiceid() {
		return this.invoiceid;
	}

	public void setInvoiceid(Invoice invoiceid) {
		this.invoiceid = invoiceid;
	}


	@Embeddable
	public static class PK implements Serializable {
		private BigDecimal invoiceid2;
		private BigDecimal item;
		private static final long serialVersionUID = 1L;

		public PK() {
			super();
		}

		public BigDecimal getInvoiceid2() {
			return this.invoiceid2;
		}

		public void setInvoiceid2(BigDecimal invoiceid2) {
			this.invoiceid2 = invoiceid2;
		}

		public BigDecimal getItem() {
			return this.item;
		}

		public void setItem(BigDecimal item) {
			this.item = item;
		}

		@Override
		public boolean equals(Object o) {
			if (o == this) {
				return true;
			}
			if ( ! (o instanceof PK)) {
				return false;
			}
			PK other = (PK) o;
			return this.invoiceid2.equals(other.invoiceid2)
				&& this.item.equals(other.item);
		}

		@Override
		public int hashCode() {
			return this.invoiceid2.hashCode()
				^ this.item.hashCode();
		}

	}

}
