/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa.utils;

import java.awt.BufferCapabilities.FlipContents;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Time;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PersistenceContext;

import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.jpa.EntityManagerFactoryHolder;
import org.zuena.guiceex.jpa.utils.SQLUtils;
import org.zuena.guiceex.transaction.annotation.Transactional;

import static org.zuena.guiceex.jpa.utils.SQLUtils.*;

import junit.framework.TestCase;

/**
 * @author matsu@zuena.org.
 */
public class TestSQLUtils extends TestCase {

	public static class Test{
		public interface Proc{
			void doProc(EntityManager em);
		}
		@PersistenceContext(unitName="derby")
		EntityManager em;
		
		
		@Transactional
		void medthod(Proc proc){
			proc.doProc(em);
		}
	}
	public static class Result implements Serializable{
		private String aircraft;
		private Time departTime;
		private Time arriveTime;
		private double flyingTime;
		
		public String getAircraft() {
			return aircraft;
		}
		public void setAircraft(String aircraft) {
			this.aircraft = aircraft;
		}
		public Time getArriveTime() {
			return arriveTime;
		}
		public void setArriveTime(Time arriveTime) {
			this.arriveTime = arriveTime;
		}
		public Time getDepartTime() {
			return departTime;
		}
		public void setDepartTime(Time departTime) {
			this.departTime = departTime;
		}
		public double getFlyingTime() {
			return flyingTime;
		}
		public void setFlyingTime(double flyingTime) {
			this.flyingTime = flyingTime;
		}
	
		public String toString(){
			return "aircraft=[" + aircraft + "]\n"
			+ "departTime=[" + departTime + "]\n"
			+ "arriveTime=[" + arriveTime + "]\n"
			+ "flyingTime=[" + flyingTime + "]\n";
		}
	}
	
	
	public void testSimpleSelect(){

		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/persistence.xml");
		EntityManager em = EntityManagerFactoryHolder.getEntityManagerFactory("derby", null).createEntityManager();
		
		Test t = InjectorFactory.getInjector().getInstance(Test.class);

//				List<Result> l = select(
//									result(Result.class,"f")
//									.result(Result.class,"a")
//								)
//								.from(
//									table(Flights.class,"f")
//									.table(Flightavailability.class,"a")
//								)
//								.where(
//									and(
//										and("f.flightId","a.flight_id")
//										,and("f.segmentNumber","a.segment_number")
//									)
//								)
//								.getResultList(em);
//				for (Result result : l) {
//					System.out.println(result);
//				}
	}

}
