/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

var Config		= h5glib.Config;
var Debug		= h5glib.Debug;
var ListElement	= h5glib.ListElement;
var Task		= h5glib.Task;
var Scene		= h5glib.Scene;

var SCENE_NAME		= "menu";
var STAGE_SCENE_NAME= h5glib.STAGE_SCENE_NAME;

/**
 * MenuTask
 */
var MenuTask = function( scene )
{
	this.command	= scene.input;
};
MenuTask.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;

		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var canvas		= scene.canvas;
		var context		= scene.context;

		context.save();

		context.fillStyle = "lightgray";
		context.fillRect( 0, 0, canvas.width, canvas.height );

		context.font		= "24px 'ＭＳ Ｐゴシック'";
		context.fillStyle	= "white";
		context.fillText( "Menu", 100, 100 );

		context.restore();
	};
})( MenuTask.prototype );

/**
 * Command
 */
var Command = function()
{
	this.escape	= 0;
};

(function( pt )
{
	/**
	 * 
	 */
	pt.clear = function()
	{
		this.escape	= 0;
	};
})( Command.prototype );

/**
 * InputCommand
 */
var InputCommand = function() {};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 27:	this.escape	= value; break;	// ESC
			}
		}
	};
})( InputCommand.prototype );

/**
 * MenuScene
 */
var MenuScene = function( app )
{
	this.app		= app;
	this.name		= SCENE_NAME;

	this.input		= new InputCommand();

	this.menu		= new MenuTask( this );
	this.menu.link( this.head );	// after dummy task.
};
MenuScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.show = function()
	{
		this.input.clear();

		this.holdCanvas();
		this.drawTasks();
	};
	/**
	 * 
	 */
	pt.update = function()
	{
		this.ticks++;

		// change scene
		if ( this.input.escape )
		{
			this.app.sceneManager.push( STAGE_SCENE_NAME );
			this.app.sceneManager.current.show();
			return;
		}

		// update & draw
		if ( this.updateTasks() )
		{
			this.drawTasks();
		}
	};
})( MenuScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.MenuScene			= MenuScene;
window.h5glib.MENU_SCENE_NAME	= SCENE_NAME;


// Anonymous function end
//
})( window );
