/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

window.h5glib.loadDataCB(
{
	type : "stage",
	map :
	[
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,2,0,2,2,2,2,2,2,2,2,0,2,2,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
	],

	actors :
	[
		{
			type : 0,
			x : 4.5, y : 15.5, z : 1, dir : Math.PI / 2
		},
		{
			type : 0,
			x : 7.5, y : 12.5, z : 1, dir : Math.PI * 3 / 2,
			event : { text : "トンスル飲むか？" }
		},
		{
			type : 0,
			x : 2.5, y : 12.5, z : 1, dir : Math.PI,
			event : { text : "アイム ザパニーズ" }
		},
		{
			type : 1,
			x : 4.5, y : 12.5, z : 1, dir : Math.PI * 3 / 2,
			event : { text : "魚を船に乗せると船酔いする。" }
		}
	],

	resource :
	{
		actorNames		:
		[
			"スケルトン",
			"馬"
		],
		wallImage		: new Image(),
		skyImage		: new Image(),
		floorImage		: new Image(),
		actorImages		: [],
		monsterImages	: [],
		gunImage		: new Image(),
		fireImage		: new Image(),
		shootSound		: new Audio(),
		noticeSound		: new Audio(),
		battleSound		: new Audio(),

		load : function()
		{
			this.wallImage.src		= "stage0/wall.png";
			this.skyImage.src		= "stage0/sky.jpg";
			this.floorImage.src		= "stage0/floor.png";

			for ( var i = 0; i < 2; i++ )
			{
				this.actorImages[i]			= new Image();
				this.actorImages[i].src		= "stage0/actor_t" + i + ".png";

				this.monsterImages[i]		= new Image();
				this.monsterImages[i].src	= "stage0/monster_t" + i + ".png";
			}

			this.gunImage.src		= "stage0/gun.png";
			this.fireImage.src		= "stage0/fire.png";

			this.shootSound.src		= "stage0/shoot.ogg";
			this.noticeSound.src	= "stage0/notice.ogg";
			this.battleSound.src	= "stage0/battle.ogg";
		}
	}
});
