/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

// reference
var Config			= window.h5glib.Config;
var Debug			= window.h5glib.Debug;
var Command			= window.h5glib.Command;
var Task			= window.h5glib.Task;
var SoundTask		= window.h5glib.SoundTask;
var ReadyTask		= window.h5glib.ReadyTask;
var ImageAnimator	= window.h5glib.ImageAnimator;
var Message			= window.h5glib.Message;
var MessageHandler	= window.h5glib.MessageHandler;
var MessageManager	= window.h5glib.MessageManager;
var SceneStatus		= window.h5glib.SceneStatus;
var Scene			= window.h5glib.Scene;

/**
 * Res
 */
var Res =
{
	String :
	{
		HTML_USAGE	: "<p>" +
					  "" +
					  "</p>",
		ID_START	: "start",
		ID_STOP		: "stop"
	},
	Color :
	{
		BACKGROUND		: "rgb(0, 0, 0)"
	},
	Font :
	{
		LARGE		: "bold 18px 'ＭＳ Ｐゴシック'",
		SMALL		: "bold 14px 'ＭＳ Ｐゴシック'"
	}
};

/**
 * StageTask
 */
var StageTask = function( scene )
{
	this.command	= scene.command;	// input
};
StageTask.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;
		var resource	= scene.data.resource;

		context.save();

		var image = resource.image.bg.data;
		context.drawImage(
			image,
			0,						// sx
			0,						// sy
			image.width,			// sw
			image.height,			// sh
			0,						// dx
			0,						// dy
			image.width,			// dw
			image.height			// dh
		);

		context.restore();
	};
})( StageTask.prototype );

/**
 * ActorTask
 */
var ActorTask = function( scene )
{
	this.command		= scene.command;
	this.animator		= null;
	this.trans			= null;
	this.rotDeg			= 0;

	this.running		= false;
};
ActorTask.prototype = new Task();

(function( pt )
{
	/**
	 * 
	 */
	pt.init = function( scene )
	{
	};
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;

		// start
		if ( scene.command.tbl.start )
		{
			this.running	= true;
			scene.command.tbl.start	= 0;
		}
		// stop
		if ( scene.command.tbl.stop )
		{
			this.running	= false;
			scene.command.tbl.stop	= 0;
		}

		if ( this.running )
		{
			this.rotDeg += 20;
			upd = true;
		}

		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;
		var resource	= scene.data.resource;
		if ( this.trans == null )
		{
			this.trans		= { x : ( canvas.width / 2 ), y : ( canvas.height / 2 ) };
		}

		context.save();

		var image;
		image = resource.image.fan_b.data;
		context.drawImage(
			image,
			0,						// sx
			0,						// sy
			image.width,			// sw
			image.height,			// sh
			0,						// dx
			0,						// dy
			image.width,			// dw
			image.height			// dh
		);

		image = resource.image.fan_p.data;
		context.translate( canvas.width / 2, canvas.width / 2 );
		context.rotate( this.rotDeg * Math.PI / 180 );

		context.drawImage(
			image,
			0,						// sx
			0,						// sy
			image.width,			// sw
			image.height,			// sh
			image.width / 2 * -1,	// dx
			image.height / 2 * -1,	// dy
			image.width,			// dw
			image.height			// dh
		);

		context.restore();
	};
})( ActorTask.prototype );

/**
 * DebugTask
 */
var DebugTask = function( scene )
{
	this.command	= scene.command;	// input
	this.info		= null;
	this.lag		= 0;
};
DebugTask.prototype = new Task();

(function( pt )
{
	pt.LAG_VAL	= 10;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		// lag
		if ( this.lag )
		{
			this.lag--;
		}
		else
		{
			if ( this.command.tbl.debug )
			{
				this.info	= "scene.actorTask.status=" + scene.actorTask.status;
				this.lag	= this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		// output debug info
		if ( this.info )
		{
			Debug.print( this.info );
			this.info = null;
		}
	};
})( DebugTask.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.tbl.start	= 0;
	this.tbl.stop	= 0;

	this.tbl.escape	= 0;
	this.tbl.debug	= 0;
};
InputCommand.prototype = new Command();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function() {};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 27: this.tbl.escape= value; break;	// ESC
				case 81: this.tbl.debug	= value; break;	// Q
			}
		}
	};
})( InputCommand.prototype );

/**
 * VfanScene
 */
var VfanScene = function( app, name )
{
	this.app			= app;
	this.name			= name;
	this.data			= null;
	this.command		= new InputCommand();

	// create task
	this.stageTask		= new StageTask( this );
	this.actorTask		= new ActorTask( this );
	this.soundTask		= new SoundTask( this );
	this.debugTask		= new DebugTask( this );
	// create list
	this.stageTask.append( this.actorTask );
	this.stageTask.append( this.soundTask );
	this.stageTask.append( this.debugTask );
	// head of task list
	this.child			= this.stageTask;
	this.setStatus( SceneStatus.READY );

	// message handler
	//this.msgManager		= new MessageManager();
};
VfanScene.prototype = new Scene();

(function( pt )
{
	/**
	 * 
	 */
	pt.init = function()
	{
		// window.onload のタイミング
		var self	= this;
		var button;

		// play
		button	= this.app.getDomElement( Res.String.ID_START );
		this.app.addSysEventHandler( button, "click", function()
		{
			try
			{
				var sound		= self.soundTask;
				var resource	= self.data.resource;
				var command		= self.command;

				var start		= self.app.getDomElement( Res.String.ID_START );
				var stop		= self.app.getDomElement( Res.String.ID_STOP );

				// play
				sound.prepareLoop( resource.sound.ah.data )
				// set ability
				start.disabled	= true;
				stop.disabled	= false;
				// set command
				command.tbl.start	= 1;
			}
			catch ( e )
			{
				self.app.kill();
				Debug.alertError( e );
			}
		});

		// pause
		button	= this.app.getDomElement( Res.String.ID_STOP );
		this.app.addSysEventHandler( button, "click", function()
		{
			try
			{
				var sound		= self.soundTask;
				var resource	= self.data.resource;
				var command		= self.command;

				var start		= self.app.getDomElement( Res.String.ID_START );
				var stop		= self.app.getDomElement( Res.String.ID_STOP );

				// pause
				sound.cancel( resource.sound.ah.data )
				// set ability
				start.disabled	= false;
				stop.disabled	= true;
				// set command
				command.tbl.stop	= 1;
			}
			catch ( e )
			{
				self.app.kill();
				Debug.alertError( e );
			}
		});
		button.disabled = true;
	};
	/**
	 * 
	 */
	pt.show = function()
	{
		//this.setUsage( Res.String.HTML_USAGE );

		this.command.clear();
		this.holdContext();
		this.draw( this );
	};
	/**
	 * 
	 */
	pt.setData = function( data )
	{
		this.data		= data;
		// init actor
		this.actorTask.init( this );
	};
	/**
	 * 
	 */
	pt.getData = function()
	{
		return this.data;
	};
	/**
	 * 
	 */
	pt.loadData = function( data )
	{
		try
		{
			// load resource
			this.app.loadResource( this.name, data.resource );
			// set data
			this.setData( data );
			// set status
			var self = this;
			window.setTimeout( function() { self.setStatus( SceneStatus.RUNNING ); self.show(); }, Config.loadInterval );
		}
		catch ( e )
		{
			this.app.kill();
			Debug.alertError( e );
		}
	};
})( VfanScene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.VfanScene	= VfanScene;

// Anonymous function end
//
})( window );
