package org.ydtmt.jsonitro;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class JSON {

    public Object eval(String jsonStr) throws JSONitroException {
        return this.eval(jsonStr, null);
    }

    public Object eval(String jsonStr, JSONitroHierarchySet hierarchy) throws JSONitroException {

        Object currentObj = null;
        StringBuffer sb = new StringBuffer();
        String targetElem = "";
        boolean isBuffering = false;
        boolean isNextEscape = false;
        boolean isUnknownTarget = true;
        boolean willValuesCome = false;

        HierarchyLevel currentLevel = HierarchyLevel.LEVEL_0;
        ArrayList<Object> objArry = new ArrayList<Object>();

        // 階層の処理状況を格納するMAP（処理の高速度からEnumMapを使用した）
        Map<HierarchyLevel, String> hierarchyMap = Collections.synchronizedMap(
                new EnumMap<HierarchyLevel, String>(HierarchyLevel.class));

        if (hierarchy == null) {
            hierarchy = new JSONitroHierarchySet();
        }

        // トップレベル
        if (!hierarchy.isHierarchyExist(HierarchyLevel.LEVEL_0)) {
            try {
                targetElem = "parent";
                hierarchy.addHierarchy(HierarchyLevel.LEVEL_0,
                        getParentClass(jsonStr, hierarchy), targetElem);
            } catch (IllegalArgumentException e) {
                throw new JSONitroException(JSONitroException.JSONDATA_ERROR);
            }
        } else {
            targetElem = hierarchy.getParentElementName();
        }
        int count = jsonStr.length();
        for (int i = 0; i < count; i++) {
            char tmpChar = jsonStr.charAt(i);
            if (isNextEscape) {
                if (isBuffering) {
                    sb.append('\\');
                    sb.append(tmpChar);
                }
                isNextEscape = false;
                continue;
            }
            switch (tmpChar) {
            case ':':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                willValuesCome = true;
                break;
            case ',':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                if (!isBuffering && willValuesCome) {
                    addToParent(currentObj, new String(sb).trim(), targetElem);
                    isUnknownTarget = true;
                    targetElem = "";
                    sb = new StringBuffer();
                }
                willValuesCome = false;
                break;
            case '\\':
                if (isBuffering) {
                    sb.append(tmpChar);
                }
                isNextEscape = true;
                break;
            case '\"':
                if (isBuffering) {
                    if (isUnknownTarget) {
                        targetElem = sb.toString();
                        isUnknownTarget = false;
                    } else {
                        addToParent(currentObj, new String(sb), targetElem);
                        targetElem = "";
                        isUnknownTarget = true;
                        willValuesCome = false;
                    }
                } else {
                    willValuesCome = false;
                }
                sb = new StringBuffer();
                isBuffering = (!isBuffering);

                break;
            case '[':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                willValuesCome = false;
                try {
                    if (hierarchy.getJSONitroHierarchy(currentLevel, targetElem) == null) {
                        hierarchy.addHierarchy(currentLevel, ArrayList.class, targetElem);
                    }
                    currentObj = hierarchy.getJSONitroHierarchy(
                            currentLevel, targetElem).getElementClass().newInstance();
                } catch (InstantiationException e) {
                } catch (IllegalAccessException e) {
                }
                objArry.add(currentObj);
                hierarchyMap.put(currentLevel, targetElem);
                currentLevel = HierarchyLevel.getNext(currentLevel);
                isUnknownTarget = true;
                targetElem = "";
                break;
            case '{':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                if ("".equals(targetElem)) {
                    targetElem = hierarchyMap.get(HierarchyLevel.getPrevious(currentLevel));
                }
                try {
                    if (hierarchy.getJSONitroHierarchy(currentLevel, targetElem) == null) {
                        hierarchy.addHierarchy(currentLevel, HashMap.class, targetElem);
                    }
                    currentObj = hierarchy.getJSONitroHierarchy(
                            currentLevel, targetElem).getElementClass().newInstance();
                } catch (InstantiationException e) {
                } catch (IllegalAccessException e) {
                }
                hierarchyMap.put(currentLevel, targetElem);
                objArry.add(currentObj);
                currentLevel = HierarchyLevel.getNext(currentLevel);
                isUnknownTarget = true;
                targetElem = "";
                break;
            case '}':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                if (objArry.size() == 1) {
                    return currentObj;
                }
                currentObj = addToParent(objArry.get(objArry.size()-2),
                        currentObj, hierarchyMap.get(HierarchyLevel.getPrevious(currentLevel)));
                objArry.remove(objArry.size()-1);
                currentLevel = HierarchyLevel.getPrevious(currentLevel);
                break;
            case ']':
                if (isBuffering) {
                    sb.append(tmpChar);
                    break;
                }
                if (objArry.size() == 1) {
                    return currentObj;
                }
                currentObj = addToParent(objArry.get(objArry.size()-2),
                        currentObj, hierarchyMap.get(HierarchyLevel.getPrevious(currentLevel)));
                objArry.remove(objArry.size()-1);
                currentLevel = HierarchyLevel.getPrevious(currentLevel);
                break;
            default:
                if (isBuffering || willValuesCome) {
                    sb.append(tmpChar);
                }
                break;
            }
        }

        return currentObj;
    }

    /**
     * 親クラスにオブジェクトを設定する
     * @param dest
     * @param src
     * @param elem
     * @return
     * @throws JSONitroException
     */
    @SuppressWarnings("unchecked")
    private Object addToParent(Object dest, Object src, String elem) throws JSONitroException {
        if (dest instanceof ArrayList) {
            ((ArrayList<Object>) dest).add(src);
        } else if (dest instanceof HashMap) {
            ((HashMap<String, Object>) dest).put(elem, src);
        } else {
            try {
                setObject(dest, src, elem);
            } catch (Exception e) {
                throw new JSONitroException(e);
            }
        }
        return dest;
    }

    /**
     * 親クラスにオブジェクトを設定する（Setter呼び出し）
     * @param dest
     * @param src
     * @param elem
     * @throws SecurityException
     * @throws NoSuchMethodException
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     * @throws NoSuchFieldException
     */
    private void setObject(Object dest, Object src, String elem)
    throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        StringBuffer methodName = new StringBuffer("set");
        methodName.append(getInitialCharUpperCase(elem));
        Class<?> elemType = dest.getClass().getDeclaredField(elem).getType();
        Method method = dest.getClass().getDeclaredMethod(methodName.toString(), elemType);
        method.invoke(dest, getValueEveryType(src, elemType));
    }

    /**
     * 文字列の頭文字のみ大文字にする
     * @param target
     * @return 頭文字を大文字にした文字列
     */
    private String getInitialCharUpperCase(String target) {
        char[] tgtCharArray = target.toCharArray();
        tgtCharArray[0] = Character.toUpperCase(tgtCharArray[0]);
        return new String(tgtCharArray);
    }

    private Object getValueEveryType(Object target, Class<?> parseType) {
        // 基本型はObject継承クラスを返却する
        if (parseType.equals(int.class)) {
            return Integer.parseInt(target.toString());
        } else if (parseType.equals(boolean.class)) {
            return new Boolean(target.toString()).booleanValue();
        } else if (parseType.equals(long.class)) {
            return new Long(target.toString()).longValue();
        } else if (parseType.equals(short.class)) {
            return new Short(target.toString()).shortValue();
        } else if (parseType.equals(double.class)) {
            return new Double(target.toString()).doubleValue();
        } else if (parseType.equals(float.class)) {
            return new Float(target.toString()).floatValue();
        }
        return target;
    }

    /**
     * 第一要素のクラスを判定する。
     * @param jsonStr
     * @param hierarchy
     * @return
     * @throws IllegalArgumentException
     */
    private Class<?> getParentClass(String jsonStr, JSONitroHierarchySet hierarchy)
        throws IllegalArgumentException {
        int count = jsonStr.length();
        for (int i = 0; i < count; i++) {
            char tmp = jsonStr.charAt(i);
            if (tmp == '{') {
                return HashMap.class;
            } else if (tmp == '[') {
                return ArrayList.class;
            }
        }
        throw new IllegalArgumentException();
    }
}
