//  pcm_sink_test.cpp: test case for pcm_sink

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <hamigaki/audio/pcm_device.hpp>
#include <hamigaki/audio/sine_wave.hpp>
#include <hamigaki/audio/stereo.hpp>
#include <boost/iostreams/copy.hpp>
#include <boost/iostreams/restrict.hpp>
#include <boost/test/unit_test.hpp>
#include "detail/utility.hpp"

namespace audio = hamigaki::audio;
namespace io = boost::iostreams;
namespace ut = boost::unit_test;

using namespace hamigaki::audio::test;

void pcm_sink_test_aux(const audio::pcm_format& fmt, double freq)
{
    std::ostringstream os;
    os
        << "rate=" << fmt.rate
        << ", bits=" << fmt.bits
        << ", channels=" << fmt.channels;
    BOOST_CHECKPOINT(os.str());

    io::copy(
        io::restrict(
            audio::stereo(
                audio::sine_wave_source(fmt.rate, fmt.bits, freq),
                fmt.channels
            ), 0, fmt.block_size()*calc_samples_per_note(fmt.rate,100)
        ),
        audio::pcm_sink(fmt, fmt.optimal_buffer_size())
    );
}

void pcm_sink_test()
{
    const unsigned rates[] = { 11025, 22050, 44100 };
    const unsigned bits[] = { 8, 16 };

    unsigned short note = 60;
    for (std::size_t i = 0; i < sizeof(rates)/sizeof(rates[0]); ++i)
    {
        for (std::size_t j = 0; j < sizeof(bits)/sizeof(bits[0]); ++j)
        {
            for (unsigned channels = 1; channels <= 2; ++channels)
            {
                audio::pcm_format fmt;
                fmt.rate = rates[i];
                fmt.bits = bits[j];
                fmt.channels = channels;
                pcm_sink_test_aux(fmt, calc_frequency(note));
            }
            note = next_note(note);
        }
    }
}

ut::test_suite* init_unit_test_suite(int, char* [])
{
    ut::test_suite* test = BOOST_TEST_SUITE("pcm_sink test");
    test->add(BOOST_TEST_CASE(&pcm_sink_test));
    return test;
}
