//  background_copy_example.cpp: an example for background_copy

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <hamigaki/iostreams/device/zero.hpp>
#include <hamigaki/iostreams/copy_manager.hpp>
#include <hamigaki/thread/utc_time.hpp>
#include <boost/iostreams/device/file.hpp>
#include <boost/iostreams/copy.hpp>
#include <boost/iostreams/positioning.hpp>
#include <boost/iostreams/restrict.hpp>
#include <boost/progress.hpp>
#include <exception>
#include <iostream>

namespace io = boost::iostreams;

int main()
{
    try
    {
        const unsigned long test_size = 32ul * 1024ul * 1024ul;
        hamigaki::iostreams::copy_manager bg_copy;
        bg_copy.copy(
            io::restrict(hamigaki::iostreams::zero_source(), 0, test_size),
            io::file_sink("zero.dat", BOOST_IOS::binary));

        boost::progress_display progress(test_size);
        hamigaki::thread::utc_time t;
        while (!bg_copy.done())
        {
            progress += static_cast<unsigned long>(
                io::position_to_offset(bg_copy.tell()) - progress.count());

            t += hamigaki::thread::milliseconds(100);
            boost::thread::sleep(t);
        }
        progress += static_cast<unsigned long>(
            progress.expected_count() - progress.count());

        return 0;
    }
    catch (const std::exception& e)
    {
        std::cerr << "Error: " << e.what() << std::endl;
    }
    return 1;
}
