//  copy_manager_test.cpp: test case for copy_manager

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <hamigaki/iostreams/device/zero.hpp>
#include <hamigaki/iostreams/copy_manager.hpp>
#include <hamigaki/thread/utc_time.hpp>
#include <boost/iostreams/device/null.hpp>
#include <boost/iostreams/restrict.hpp>
#include <boost/test/unit_test.hpp>

namespace io_ex = hamigaki::iostreams;
namespace io = boost::iostreams;
namespace ut = boost::unit_test;

void copy_manager_test()
{
    const unsigned long test_size = 32ul * 1024ul * 1024ul;

    io_ex::copy_manager manager;
    {
        manager.copy(
            io::restrict(io_ex::zero_source(), 0, test_size),
            io::null_sink());

        hamigaki::thread::utc_time t;
        while (!manager.done())
        {
            t += hamigaki::thread::milliseconds(100);
            boost::thread::sleep(t);
        }
    }
    {
        manager.copy(
            io::restrict(io_ex::zero_source(), 0, test_size),
            io::null_sink());

        manager.stop();
        manager.resume();

        hamigaki::thread::utc_time t;
        while (!manager.done())
        {
            t += hamigaki::thread::milliseconds(100);
            boost::thread::sleep(t);
        }
    }
    {
        manager.copy(
            io::restrict(io_ex::zero_source(), 0, test_size),
            io::null_sink());

        manager.copy(
            io::restrict(io_ex::zero_source(), 0, test_size),
            io::null_sink());

        hamigaki::thread::utc_time t;
        while (!manager.done())
        {
            t += hamigaki::thread::milliseconds(100);
            boost::thread::sleep(t);
        }
    }
}

ut::test_suite* init_unit_test_suite(int, char* [])
{
    ut::test_suite* test = BOOST_TEST_SUITE("copy_manager test");
    test->add(BOOST_TEST_CASE(&copy_manager_test));
    return test;
}
