/* OtBbN֌W */

#include "bootpack.h"

void init_palette(void)
{
	static unsigned char table_rgb[18 * 3] = {
		0x00, 0x00, 0x00,	/*  0: */
		0xff, 0x00, 0x00,	/*  1:邢 */
		0x00, 0xff, 0x00,	/*  2:邢 */
		0xff, 0xff, 0x00,	/*  3:邢F */
		0x00, 0x00, 0xff,	/*  4:邢 */
		0xff, 0x00, 0xff,	/*  5:邢 */
		0x00, 0xff, 0xff,	/*  6:邢F */
		0xff, 0xff, 0xff,	/*  7: */
		0xc6, 0xc6, 0xc6,	/*  8:邢DF */
		0x84, 0x00, 0x00,	/*  9:Â */
		0x00, 0x84, 0x00,	/* 10:Â */
		0x84, 0x84, 0x00,	/* 11:ÂF */
		0x00, 0x00, 0x84,	/* 12:Â */
		0x84, 0x00, 0x84,	/* 13:Â */
		0x00, 0x84, 0x84,	/* 14:ÂF */
		0x84, 0x84, 0x84,	/* 15:ÂDF */
		/* OSAkkie Only */
		0x3a, 0x6e, 0xa5,	/* 16:WinXPȔwiF */
		0x00, 0x80, 0xff	/* 17:^Cgo[ */
	};
	set_palette(0, 17, table_rgb);
	return;

	/* static char ߂́Af[^ɂgȂDBߑ */
}

void set_palette(int start, int end, unsigned char *rgb)
{
	int i, eflags;
	eflags = io_load_eflags();	/* 荞݋tO̒lL^ */
	io_cli(); 					/* tO0ɂĊ荞݋֎~ɂ */
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);	/* 荞݋tOɖ߂ */
	return;
}

void boxfill8(unsigned char *vram, int xsize, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
			vram[y * xsize + x] = c;
	}
	return;
}

void picdata8(unsigned char *vram, int xsize, unsigned char *c, int sx, int sy, int trans, int px, int py)
{
	int x, y;

	for (y = py; y < (py+sy); y++) {
		for (x = px; x < (px+sx); x++) {
			if (0 <= trans && c[0] != trans)	// 0ȏ͓
				vram[y * xsize + x] = c[0];
			c++;
		}
	}
	return;
}

void init_screen8(char *vram, int x, int y)
{
	static unsigned char naomi3_2[26 * 28] = {
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x00,0x00,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x00,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x00,
		0x00,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x00,
		0x00,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x00,
		0x0e,0x00,0x0e,0x0e,0x00,0x03,0x03,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x03,0x00,0x03,0x03,0x03,0x03,0x00,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x00,
		0x0e,0x00,0x0e,0x00,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x00,0x0e,0x00,0x0e,
		0x0e,0x00,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x00,0x0e,
		0x0e,0x0e,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x01,0x01,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x01,0x00,0x00,0x01,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x01,0x00,0x07,0x07,0x00,0x01,0x00,0x03,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x00,0x01,0x00,0x07,0x07,0x00,0x01,0x00,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x00,0x01,0x00,0x00,0x01,0x00,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x00,0x00,0x01,0x01,0x00,0x00,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x03,0x03,0x03,0x03,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x00,0x0e,0x0e,0x00,0x00,0x00,0x00,0x0e,0x0e,0x00,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
		0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x00,0x0e,0x0e,0x0e,0x0e,0x0e
	};

	boxfill8(vram, x, 16, 0, 0, x - 1, y - 1);	// fXNgbvwi
	picdata8(vram, x, naomi3_2, 28, 26, COL8_008484, x - 30, y - 30);
	return;
}

void putfont8(char *vram, int xsize, int x, int y, char c, char *font)
{
	int i;
	char *p, d /* data */;
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
	}
	return;
}

void putfonts8_asc(char *vram, int xsize, int x, int y, char c, unsigned char *s)
{
	extern char hankaku[4096];
	for (; *s != 0x00; s++) {
		putfont8(vram, xsize, x, y, c, hankaku + *s * 16);
		x += 8;
	}
	return;
}

void init_mouse_cursor8(char *mouse, char bc)
/* }EXJ[\i16x16j */
{
	static char cursor[16][16] = {
		"*O.....O*O*O*O..",
		"O*O....O*****O..",
		".O*O..O*OOOOO*O.",
		"..O*OO*O**O**O*O",
		"...O***O*OO*OO*O",
		"....OO***O*OOO*O",
		"......O*O***O*O.",
		"......OO*O*O*O..",
		".....O*O*OOO*O*O",
		"....O*O**OOO**O*",
		".....O*O*OOO*O*O",
		"......O**OOO**O.",
		".....O*********O",
		".....O*O*O*O*O*O",
		"......O*O*O*O*O.",
		".......O*****O.."
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 16; x++) {
			if (cursor[y][x] == '*') {
				mouse[y * 16 + x] = COL8_000000;
			}
			if (cursor[y][x] == 'O') {
				mouse[y * 16 + x] = COL8_FFFFFF;
			}
			if (cursor[y][x] == '.') {
				mouse[y * 16 + x] = bc;
			}
		}
	}
	return;
}

void putblock8_8(char *vram, int vxsize, int pxsize,
	int pysize, int px0, int py0, char *buf, int bxsize)
{
	int x, y;
	for (y = 0; y < pysize; y++) {
		for (x = 0; x < pxsize; x++) {
			vram[(py0 + y) * vxsize + (px0 + x)] = buf[y * bxsize + x];
		}
	}
	return;
}
