/* t@C֌W */

#include "bootpack.h"
#include <stdio.h>
#include <string.h>

#define SYNC_INTVL 6

struct DBGWIN dbg;
struct FIFO32 io_fifo;
extern char t[];
extern struct TASK *fdc;
extern struct CONSOLE *tcons;
extern unsigned short table_8_565[256];

void file_time(struct FILEINFO *finfo);
void file_compfat(int *fat, unsigned char *img, int clustno);
void file_savesec(int location, int target);
void inout_control(void);
void dbg_init(struct SHEET *sht);
void dbg_putchar(int chr, int fc);
void dbg_newline(struct DBGWIN *dbg);

void file_readfat(int *fat, unsigned char *img)
/* fBXNC[WFAT̈kƂ */
{
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		fat[i + 0] = (img[j + 0]      | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
	return;
}

void file_loadfile(int clustno, int size, char *buf, int *fat, char *img)
{
	int i;
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[clustno * 512 + i];
			}
			break;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[clustno * 512 + i];
		}
		size -= 512;
		buf += 512;
		clustno = fat[clustno];
	}
	return;
}

struct FILEINFO *file_search(char *name, struct FILEINFO *finfo, int max)
{
	int i, j;
	char s[12];
	for (j = 0; j < 11; j++) {
		s[j] = ' ';
	}
	j = 0;
	for (i = 0; j < 11 && name[i] != 0; i++) {
		if (name[i] == '.') {
			j = 8;
		} else {
			s[j] = name[i];
			if ('a' <= s[j] && s[j] <= 'z') {
				/* ͑啶ɒ */
				s[j] -= 0x20;
			} 
			j++;
		}
	}
	for (i = 0; i < max; ) {
		if (finfo[i].name[0] == 0x00) {
			break;
		}
		if ((finfo[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (finfo[i].name[j] != s[j]) {
					goto next;
				}
			}
			return finfo + i; /* t@C */
		}
next:
		i++;
	}
	return 0; /* Ȃ */
}

char *file_loadfile2(int clustno, int *psize, int *fat)
{
	int size = *psize, size2;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char *buf, *buf2;
	buf = (char *) memman_alloc_4k(memman, size);
	file_loadfile(clustno, size, buf, fat, (char *) (ADR_DISKIMG + 0x003e00));
	if (size >= 17) {
		size2 = tek_getsize(buf);
		if (size2 > 0) {	/* tekkĂ */
			buf2 = (char *) memman_alloc_4k(memman, size2);
			tek_decomp(buf, buf2, size2);
			memman_free_4k(memman, (int) buf, size);
			buf = buf2;
			*psize = size2;
		}
	}
	return buf;
}

int file_searchfat(int *fat)
/* FAT󂫗̈ */
{
	int i;
	for (i = 0; i < 2880; i++) {
		if (fat[i] == 0x0000) {
			io_cli();
			if (fat[i] == 0x0000) {
				fat[i] = 0x1000;
				io_sti();
				return i;
			}
			io_sti();
		}
	}
	return 0x0fff;
}

int file_savefile(struct FILEHANDLE *fh, int size, int *fat, char *img)
{
	int nextno, clustno = fh->clustno, wsize = 0;
	char *buf = fh->buf;

	if (clustno >= 0x0ff8 || size == 0) {
		return 0;
	} else if (clustno != 0) {
		if (fat[clustno] == 0x0000 || fat[clustno] >= 0x0ff8) {
			fat[clustno] = 0x0fff;
			nextno = file_searchfat(fat);
			fat[clustno] = nextno;
			file_compfat(fat, img, clustno);
			file_savesec(clustno, 2);
		} else {
			nextno = fat[clustno];
		}
	} else {
		nextno = fh->finfo->clustno;
	}

	for (; nextno != 0x0fff;) {
		clustno = nextno;
		if (size <= 512) {
			memcpy(img + clustno * 512, buf, size);
			file_savesec(clustno, 3);
			wsize += size;
			if (fat[clustno] == 0x0000) {
				fat[clustno] = 0x0fff;
				file_compfat(fat, img, clustno);
				file_savesec(clustno, 2);
			}
			break;
		}
		memcpy(img + clustno * 512, buf, 512);
		file_savesec(clustno, 3);
		size  -= 512;
		buf   += 512;
		wsize += 512;
		if (fat[clustno] == 0x0000 || fat[clustno] >= 0x0ff8) {
			fat[clustno] = 0x0fff;
			nextno = file_searchfat(fat);
			fat[clustno] = nextno;
			file_compfat(fat, img, clustno);
			file_savesec(clustno, 2);
		} else {
			nextno = fat[clustno];
		}
	}
	fh->clustno = clustno;
	file_time(fh->finfo);
	fh->finfo->size += (wsize - (fh->finfo->size % 512));
	file_savesec((int) ((char *) fh->finfo), 1);

	return wsize;
}

int file_skipfile(struct FILEHANDLE *fh, int size, int *fat, char *img, int mode)
{
	int nextno = fh->finfo->clustno;
	int clustno = 0, ssize = 0, rsize;

	if ((mode & 0x000f) == 0) {
		fh->finfo->size = 0;
		file_savesec((int) ((char *) fh->finfo), 1);
		return 0;
	}

	for (; ssize < size - 512;) {
		clustno = nextno;
		nextno  = fat[clustno];
		if (nextno >= 0x0ff8) {
			break;
		}
		ssize += 512;
	}
	rsize = size - ssize;
	if (rsize < 512) {
		memcpy(fh->buf, img + nextno * 512, rsize);
	} else if (rsize > 512) {
		rsize = 512;
		fh->finfo->size = ssize + rsize;
		file_savesec((int) ((char *) fh->finfo), 1);
	}
	fh->pos     = ssize + rsize;
	fh->bpos    = rsize % 512;
	fh->clustno = clustno;

	return fh->pos;
}

struct FILEINFO *file_insert(char *name, struct FILEINFO *finfo, int max, int *fat)
{
	int i, j = 0, clustno;
	char s[13];

	for (i = 0; i < 12; i++) {
		if (i != 8) {
			s[i] = 0x20;
		}
	}
	for (i = 0; j < 12 && name[i] != 0; i++) {
		if (name[i] == '.') {
			j = 9;
		} else {
			s[j] = name[i];
			if ('a' <= s[j] && s[j] <= 'z') {
				s[j] -= 0x20;
			} 
			j++;
		}
	}

	for (i = 0; i < max; i++) {
		if (finfo[i].name[0] == 0x00 || finfo[i].name[0] == 0xe5) {
			clustno = file_searchfat(fat);
			if (clustno == 0x0fff) {
				break;
			}
			if (fat[clustno] == 0x0000) {
				fat[clustno] = 0x0fff;
			}
			strcpy(finfo[i].name, s);
			strcpy(finfo[i].ext, s + 9);
			finfo[i].type    = 0x20;
			finfo[i].clustno = clustno;
			finfo[i].size    = 0;
			file_time(&finfo[i]);
			file_savesec((int) ((char *) &finfo[i]), 1);
			return  finfo + i;
		}
	}

	return 0;
}

void file_time(struct FILEINFO *finfo)
{
	int i;
	char t16[7];
	unsigned short t10[7];

	memcpy(t16, t, 7);
	for (i = 0; i < 7; i++) {
		t10[i] = (t16[i] >> 4) * 10 + (t16[i] & 0x0f);
	}
	finfo->time = (t10[2] << 11)
				+ (t10[1] << 5)
				+ (unsigned short) (t10[0] / 2);
	finfo->date = ((t10[6] * 100 + t10[5] - 1980) << 9)
				+ (t10[4] << 5)
				+ t10[3];

	return;
}

void file_compfat(int *fat, unsigned char *img, int clustno)
{
	int clustlow, clustupp;
	unsigned char comp[3], *dimg = img - 0x3e00;

	clustlow = ((int) (clustno / 2)) * 2;
	clustupp = clustlow + 1;

	comp[0] = (unsigned char) (fat[clustlow] & 0x0ff);
	comp[1] = (unsigned char) ((fat[clustupp] & 0x00f) << 4 | (fat[clustlow] & 0xf00) >> 8);
	comp[2] = (unsigned char) ((fat[clustupp] & 0xff0) >> 4);

	memcpy(dimg + 0x0200 + clustlow / 2 * 3, comp, 3);
	memcpy(dimg + 0x1400 + clustlow / 2 * 3, comp, 3);

	return;
}

void file_savesec(int location, int target)
{
	int i, clustlow, secno;
	int offset[2] = {0x0200, 0x1400};

	if (target == 1) {
		/* [g̈ */
		fifo32_put_io(&io_fifo, (int) (location - ADR_DISKIMG) / 512);
	} else if (target == 2) {
		/* FAT̈ */
		clustlow = ((int) (location / 2)) * 2;
		for (i = 0; i < 2; i++) {
			secno = (offset[i] + clustlow / 2 * 3) / 512;
			fifo32_put_io(&io_fifo, secno);
			if (((offset[i] + clustlow / 2 * 3) % 512) >= 510) {
				fifo32_put_io(&io_fifo, secno + 1);
			}
		}
	} else {
		/* f[^̈ */
		fifo32_put_io(&io_fifo, 0x3e00 / 512 + location);
	}

	return;
}

void inout_task(struct SHEET *sht_back)
{
	int i, svol, scnt = 0;
	struct TASK *task = task_now();
	struct TIMER *inout_timer = timer_alloc();
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	int *fifo_buf = (int *) memman_alloc_4k(memman, 4096 * 4);
	fifo32_init(&io_fifo, 4096, fifo_buf, 0);
	timer_init(inout_timer, &task->fifo, 1);
	timer_settime(inout_timer, 1000);
	svol = io_fifo.size * 80 / 100;
	dbg_init(sht_back);

	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i == 1) {
				if (scnt >= SYNC_INTVL - 1 || fifo32_status(&io_fifo) >= svol) {
					inout_control();
					scnt = 0;
				} else {
					scnt++;
				}
				timer_settime(inout_timer, 1000);
			} else if (i == 254) {
				/* Ƃ肠Ȃ */
			} else if (i == 255) {
				/* Ƃ肠Ȃ */
			}
		}
	}
}

void inout_control(void)
{
	int sector, *sec_tbl;
	int i, j, k, sflg, fcnt = 0, total = 0;
	struct TASK *task = task_now();
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

	fcnt = fifo32_status(&io_fifo);
	if (fcnt != 0) {
		sec_tbl = (int *) memman_alloc_4k(memman, fcnt * 4);
		for (i = 0; i < fcnt; i++) {
			io_cli();
			sector = fifo32_get(&io_fifo);
			io_sti();
			sflg = 0;
			for (j = 0; j < total; j++) {
				if (sector == sec_tbl[j]) {
					sflg = 1;
					break;
				} else if (sector < sec_tbl[j]) {
					for (k = total; k > j; k--) {
						sec_tbl[k] = sec_tbl[k - 1];
					}
					break;
				}
			}
			if (sflg == 0) {
				sec_tbl[j] = sector;
				total++;
			}
		}
		char msg[30];
		for (i = 0; i < total; i++) {
			sprintf(msg, "%04d ", sec_tbl[i]);
			dbg_putstr0(msg, COL8_FFFFFF);
			io_cli();
			fifo32_put(&fdc->fifo, 2          );
			fifo32_put(&fdc->fifo, sec_tbl[i] );
			fifo32_put(&fdc->fifo, 1          );
			fifo32_put(&fdc->fifo, &task->fifo);
			io_sti();
		}
		memman_free(memman, (int) sec_tbl, fcnt * 4);
		dbg_putstr0("\n", COL8_FFFFFF);
	}

	return;
}

void dbg_init(struct SHEET *sht)
{
	dbg.sht = sht;
	dbg.bc  = 16 + 1 + 3 * 6 + 4 * 36;
	dbg.x0  = 12;
	dbg.y0  = 200;
	dbg.cx  = 0;
	dbg.cy  = 0;
	dbg.wd  = 400;
	dbg.ht  = 240;
	make_textbox8(dbg.sht, dbg.x0, dbg.y0, dbg.wd, dbg.ht, dbg.bc);
	putfouts8_asc_sht(dbg.sht, dbg.x0, dbg.y0, COL8_FFFFFF, dbg.bc, "Debug Window", 12);
	sheet_refresh(dbg.sht, dbg.x0 - 3, dbg.y0 - 3, dbg.x0 + dbg.wd + 3, dbg.y0 + dbg.ht + 3);
	return;
}

void dbg_putchar(int chr, int fc)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (dbg.sht != 0) {
				putfouts8_asc_sht(dbg.sht, dbg.x0 + dbg.cx, dbg.y0 + dbg.cy, fc, dbg.bc, " ", 1);
			}
			dbg.cx += 8;
			if (dbg.cx == dbg.wd) {
				dbg_newline(&dbg);
			}
			if ((dbg.cx & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a) {	/* s */
		dbg_newline(&dbg);
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (dbg.sht != 0) {
			putfouts8_asc_sht(dbg.sht, dbg.x0 + dbg.cx, dbg.y0 + dbg.cy, fc, dbg.bc, s, 1);
		}
		dbg.cx += 8;
		if (dbg.cx == dbg.wd) {
			dbg_newline(&dbg);
		}
	}
	return;
}

void dbg_newline(struct DBGWIN *dbg)
{
	int x, y;
	struct SHEET *sht = dbg->sht;
	if (dbg->cy < dbg->ht - 16) {
		dbg->cy += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sht != 0) {
			for (y = dbg->y0; y < dbg->y0 + dbg->ht - 16; y++) {
				for (x = dbg->x0; x < dbg->x0 + dbg->wd; x++) {
					sht->buf[x + y * sht->bxsize] = sht->buf[x + (y + 16) * sht->bxsize];
				}
			}
			for (y = dbg->y0 + dbg->ht - 16; y < dbg->y0 + dbg->ht; y++) {
				for (x = dbg->x0; x < dbg->x0 + dbg->wd; x++) {
					sht->buf[x + y * sht->bxsize] = table_8_565[dbg->bc];
				}
			}
			sheet_refresh(sht, dbg->x0, dbg->y0, dbg->x0 + dbg->wd, dbg->y0 + dbg->ht);
		}
	}
	dbg->cx = 0;
	return;
}

void dbg_putstr0(char *s, int c)
{
	for (; *s != 0; s++) {
		dbg_putchar(*s, c);
	}
	return;
}

void dbg_putstr1(char *s, int l, int c)
{
	int i;
	for (i = 0; i < l; i++) {
		dbg_putchar(s[i], c);
	}
	return;
}
