//============================================================================
//
//  wframe.c
//
//
//============================================================================

#include <math.h>
#include "apilib.h"

struct PLANE {
	int x, y;
};


//============================================================================
//  `A萔AO[oϐ 
//============================================================================

void DrawFrame(int win, struct PLANE p_Vertex[]);

float	g_Vertex[] = {	  0.0f , 68.0f ,  0.0f ,	// 0
						-14.0f ,  0.0f ,  0.0f ,	// 1
						 -6.0f ,  0.0f , -8.0f ,	// 2
						  6.0f ,  0.0f , -8.0f ,	// 3
						 14.0f ,  0.0f ,  0.0f ,	// 4
						  6.0f ,  0.0f ,  8.0f ,	// 5
						 -6.0f ,  0.0f ,  8.0f ,	// 6
						 -7.0f ,-34.0f ,  0.0f ,	// 7
						 -3.0f ,-34.0f , -4.0f ,	// 8
						  3.0f ,-34.0f , -4.0f ,	// 9
						  7.0f ,-34.0f ,  0.0f ,	//10
						  3.0f ,-34.0f ,  4.0f ,	//11
						 -3.0f ,-34.0f ,  4.0f ,	//12
						-24.0f ,-44.0f ,-18.0f ,	//13
						 -6.0f ,-34.0f , -1.0f ,	//14
						 24.0f ,-44.0f ,-18.0f ,	//15
						  6.0f ,-34.0f , -1.0f ,	//16
						-18.0f , -6.0f , 12.0f ,	//17
						-18.0f ,-24.0f , 12.0f ,	//18
						 18.0f , -6.0f , 12.0f ,	//19
						 18.0f ,-24.0f , 12.0f ,	//20
						-50.0f ,-25.0f , 20.0f ,	//21
						-50.0f ,-34.0f , 20.0f ,	//22
						 50.0f ,-25.0f , 20.0f ,	//23
						 50.0f ,-34.0f , 20.0f ,	//24
						 -5.0f ,-31.0f ,  0.0f ,	//25
						 -2.0f ,-31.0f , -3.0f ,	//26
						  2.0f ,-31.0f , -3.0f ,	//27
						  5.0f ,-31.0f ,  0.0f ,	//28
						  2.0f ,-31.0f ,  3.0f ,	//29
						 -2.0f ,-31.0f ,  3.0f ,	//30
						 -7.0f , 34.0f ,  0.0f ,	//31
						  7.0f , 34.0f ,  0.0f ,	//32
						-24.0f ,  0.0f ,  0.5f ,	//33
						-24.0f , -6.0f ,  0.5f ,	//34
						-10.5f ,-12.0f ,  1.0f ,	//35
						 24.0f ,  0.0f ,  0.5f ,	//36
						 24.0f , -6.0f ,  0.5f ,	//37
						 10.5f ,-12.0f ,  1.0f ,	//38
						 -8.5f , -9.6f ,  0.0f ,	//39
						-18.0f , -9.6f , 11.0f ,	//40
						 -8.5f ,-16.8f ,  0.0f ,	//41
						-18.0f ,-16.8f , 11.0f ,	//42
						-50.0f ,-26.8f , 19.5f ,	//43
						-50.0f ,-30.4f , 19.5f ,	//44
						  8.5f , -9.6f ,  0.0f ,	//45
						 18.0f , -9.6f , 11.0f ,	//46
						  8.5f ,-16.8f ,  0.0f ,	//47
						 18.0f ,-16.8f , 11.0f ,	//48
						 50.0f ,-26.8f , 19.5f ,	//49
						 50.0f ,-30.4f , 19.5f ,	//50
						-13.5f , -2.4f ,  0.0f ,	//51
						-12.5f , -7.2f ,  0.0f ,	//52
						-24.0f , -1.2f ,  0.0f ,	//53
						-24.0f , -3.6f ,  0.0f ,	//54
						 13.5f , -2.4f ,  0.0f ,	//55
						 12.5f , -7.2f ,  0.0f ,	//56
						 24.0f , -1.2f ,  0.0f ,	//57
						 24.0f , -3.6f ,  0.0f ,	//58
						 -6.0f ,-11.0f , -4.7f ,	//59
						 -6.0f ,-23.0f , -2.3f ,	//60
						  6.0f ,-11.0f , -4.7f ,	//61
						  6.0f ,-23.0f , -2.3f ,	//62
						-13.0f ,  0.0f ,  1.0f ,	//63
						 13.0f ,  0.0f ,  1.0f };	//64
short	g_Vindex[] = {	 2, 1, 0,					// 0
						 3, 2, 0,					// 1
						 4, 3, 0,					// 2
						 5, 4, 0,					// 3
						 6, 5, 0,					// 4
						 1, 6, 0,					// 5
						 2, 8, 7, 1,				// 6
						 3, 9, 8, 2,				// 7
						 4,10, 9, 3,				// 8
						 5,11,10, 4,				// 9
						 6,12,11, 5,				//10
						 1, 7,12, 6,				//11
						25,26,27,28,29,30,			//12
						25, 7, 8,26,				//13
						26, 8, 9,27,				//14
						27, 9,10,28,				//15
						28,10,11,29,				//16
						29,11,12,30,				//17
						30,12, 7,25,				//18
						 2,14,13,					//19
						16, 3,15,					//20
						17,18, 7,31,				//21
						20,19,32,10,				//22
						22,18,17,21,				//23
						20,24,23,19,				//24
						34,35, 1,33,				//25
						38,37,36, 4,				//26
						39,40,31,					//27
						39,41,42,40,				//28
						41, 7,42,					//29
						40,17,31,					//30
						42, 7,18,					//31
						17,40,43,21,				//32
						40,42,44,43,				//33
						42,18,22,44,				//34
						21,43,44,22,				//35
						46,45,32,					//36
						46,48,47,45,				//37
						48,10,47,					//38
						19,46,32,					//39
						20,10,48,					//40
						19,23,49,46,				//41
						46,49,50,48,				//42
						48,50,24,20,				//43
						23,24,50,49,				//44
						63,51,53,33,				//45
						51,52,54,53,				//46
						52,35,34,54,				//47
						33,53,54,34,				//48
						64,36,57,55,				//49
						55,57,58,56,				//50
						56,58,37,38,				//51
						36,37,58,57,				//52
						59, 2,13,					//53
						60,59,13,					//54
						14,60,13,					//55
						 3,61,15,					//56
						61,62,15,					//57
						62,16,15 };					//58
short	g_Polnum[] = {	3,3,3,3,3,3,4,4,4,4,4,4,6,4,4,4,4,4,4,
						3,3,4,4,4,4,4,4,3,4,3,3,3,4,4,4,4,
						3,4,3,3,3,4,4,4,4,4,4,4,4,
						4,4,4,4,3,3,3,3,3,3 };
short	g_Polcol[] = {	7,7,7,7,7,7,7,7,7,7,7,7,15,15,15,15,15,15,15,
						15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
						15,15,15,15,15,15,15,15,15,15,15,15,15,
						15,15,15,15,15,15,15,15,15,15 };


//============================================================================
//
//  HariMain()
//
//
//============================================================================

void HariMain(void)
{
	int		win, i;
	int		x0, y0, z0;
	short	*buf;
	double	rad1, rad2, x, y, z;
	struct	PLANE p_Vertex[65];

	api_initmalloc();
	buf = (short *) api_malloc(280 * 240 * 2);
	win = api_openwin(buf, 280, 240, -1, "wframe");
	api_autorefresh(win, 0);
	api_boxfilwin(win, 5, 25, 273, 233, 0);

	for (i = 0; i < 14; i++ ) {
		api_linewin(win, 9 + i * 20, 29, 9 + i * 20, 229, 10);
	}
	for (i = 0; i < 11; i++ ) {
		api_linewin(win, 9, 29 + i * 20, 269, 29 + i * 20, 10);
	}

	for (i = 0; i < 65; i++) {
		x0 = g_Vertex[i * 3 + 0];
		y0 = g_Vertex[i * 3 + 1];
		z0 = g_Vertex[i * 3 + 2];
		x  = x0;
		y  = y0;
		z  = z0;
		p_Vertex[i].x = 200 + (int) ((-400 * x) / (-400 - z));
		p_Vertex[i].y = 110 - (int) ((-400 * y) / (-400 - z));
	}
	DrawFrame(win, p_Vertex);
	rad1 = 3.14159 * 90 / 180;
	for (i = 0; i < 65; i++) {
		x0 = g_Vertex[i * 3 + 0];
		y0 = g_Vertex[i * 3 + 1];
		z0 = g_Vertex[i * 3 + 2];
		x  = x0;
		y  = cos(rad1) * y0 - sin(rad1) * z0;
		z  = sin(rad1) * y0 + cos(rad1) * z0;
		p_Vertex[i].x = 200 + (int) ((-400 * x) / (-400 - z));
		p_Vertex[i].y = 190 - (int) ((-400 * y) / (-400 - z));
	}
	DrawFrame(win, p_Vertex);
	rad1 = 3.14159 * 90 / 180;
	for (i = 0; i < 65; i++) {
		x0 = g_Vertex[i * 3 + 0];
		y0 = g_Vertex[i * 3 + 1];
		z0 = g_Vertex[i * 3 + 2];
		x  = cos(rad1) * x0 - sin(rad1) * y0;
		y  = cos(rad1) * sin(rad1) * x0 + cos(rad1) * cos(rad1) * y0 - sin(rad1) * z0;
		z  = sin(rad1) * sin(rad1) * x0 + sin(rad1) * cos(rad1) * y0 + cos(rad1) * z0;
		p_Vertex[i].x =  90 + (int) ((-400 * x) / (-400 - z));
		p_Vertex[i].y = 190 - (int) ((-400 * y) / (-400 - z));
	}
	DrawFrame(win, p_Vertex);
	rad1 = 3.14159 * 45 / 180;
	rad2 = 3.14159 * 15 / 180;
	for (i = 0; i < 65; i++) {
		x0 = g_Vertex[i * 3 + 0];
		y0 = g_Vertex[i * 3 + 1];
		z0 = g_Vertex[i * 3 + 2];
		x  = cos(rad1) * x0 - sin(rad1) * cos(rad2) * y0 + sin(rad1) * sin(rad2) * z0;
		y  = sin(rad1) * x0 + cos(rad1) * cos(rad2) * y0 - cos(rad1) * sin(rad2) * z0;
		z  = sin(rad2) * y0 + cos(rad1) * z0;
		p_Vertex[i].x =  80 + (int) ((-400 * x) / (-400 - z));
		p_Vertex[i].y = 100 - (int) ((-400 * y) / (-400 - z));
	}
	DrawFrame(win, p_Vertex);
	api_refreshwin(win, 0, 0, 280, 240);

	for (;;) {
		if (api_getkey(1) == 0x0a) { break; }
	}

	api_free(buf, 240 * 240 * 2);
	api_closewin(win);
	api_end();
}


//============================================================================
//
//  DrawFrame()
//
//
//============================================================================

void DrawFrame(int win, struct PLANE p_Vertex[])
{
	int	i, j, u, v, w;

	w = 0;
	for (i = 0; i < 59; i++) {
		for (j = 0; j < g_Polnum[i]; j++) {
			u = w + j;
			v = w + ((j + 1) % g_Polnum[i]);
			api_linewin(win, p_Vertex[g_Vindex[u]].x, p_Vertex[g_Vindex[u]].y,
				p_Vertex[g_Vindex[v]].x, p_Vertex[g_Vindex[v]].y, g_Polcol[i]);
		}
		w += g_Polnum[i];
	}

	return;
}
