/* OS̋N */

#include "bootpack.h"
#include <stdio.h>

void snow_on(struct sheet *snow);
void snow_off(struct sheet *snow);

struct fifo fifo;	/* VXep */
struct mdec mdec;	/* }EX */
struct memory *mem;	/* Ǘp */
unsigned int memtotal;	/* vTCY */
int *fat;		/* FATe[u */
unsigned char *nihongo;	/* {tHg */
struct task *task_sys, *task_clock, *task_fdc, *task_io;	/* ^XNꗗ */
struct sheet *sht_back;

void HariMain(void)
{
	struct bootinfo *binfo = (struct bootinfo *) BOOTINFO_ADDR;
	struct fifo kfifo;
	int fbuf[64], fkbuf[16];
	struct sheet *sht_tbar, *sht_mouse;
	unsigned char *buf_back, *buf_tbar, *buf_mouse;
	struct file *file;
	static char ktable[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char ktable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	int kshf = 0, kleds = (binfo->leds >> 4) & 7, kcmd_wait = -1;
	struct sheet *sht = 0, *sht2, *snow = 0;
	int sn = 0, j, mmx = -1, mmx2 = 0, mmy = -1, x, y;
	int nmx = -1, nmy = 0, nwx = 0x7fffffff, nwy = 0;
	int i;
	char s[30];

	/* n[hEFȀ */
	gdtidt_init();
	pic_init();
	pit_init();
	sti();

	/* ̏ */
	mem = (struct memory *) MEMORY_ADDR;
	memtotal = memory_test(0x00400000, 0xbfffffff);
	memory_init(mem);
	memory_free(mem, 0x00001000, 0x00009e000);
	memory_free(mem, 0x00400000, memtotal - 0x00400000);

	/* ^C}FIFȌ */
	timers_init();
	fifo_init(&fifo, 0, fbuf, 64);
	fifo_init(&kfifo, 0, fkbuf, 16);

	/* ^XN̏ */
	task_sys = task_init();
	fifo.task = task_sys;

	/* FDC */
	fdc_tinit();

	/* I/O */
	io_tinit();

	/* 荞݋ */
	outb(PIC0_IMR, 0xb8);	/* 10111000 PITPIC1ƃL[{[hFDC */
	outb(PIC1_IMR, 0xef);	/* 11101111 }EX */

	/* ʂ̏ */
	palette_init();
	sheets_init(binfo->vram, binfo->scrnx, binfo->scrny);

	/* fXNgbv */
	sht_back = sheet_alloc();
	buf_back = (unsigned char *) memory_alloc(mem, binfo->scrnx * binfo->scrny);
	sheet_set(sht_back, buf_back, binfo->scrnx, binfo->scrny, -1);
	graphic_box(sht_back, COLOR_008484, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);	/* wi */

	/* }EXJ[\ */
	sht_mouse = sheet_alloc();
	buf_mouse = (unsigned char *)memory_alloc(mem, 10 * 16);
	sheet_set(sht_mouse, buf_mouse, 10, 16, 99);
	mdec.mx = (binfo->scrnx - 10) / 2;	/* ʒi^XNo[jɂ */
	mdec.my = (binfo->scrny - 44) / 2;
	mcursor_init(buf_mouse, 99);

	/* ʂ̕\ */
	sheet_slide(sht_back, 0, 0);
	sheet_slide(sht_mouse, mdec.mx, mdec.my);
	sheet_updown(sht_back, 0);
	sheet_updown(sht_mouse, 1);

	/* FATe[ȕ */
	fat = (int *) memory_alloc(mem, 11520);
	i = fat_read(fat, (unsigned char *) FAT_ADDR);
	if(i != 0) {
		graphic_box(sht_back, COLOR_000000, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);
		for(;;) {
			hlt();
		}
	}

	/* ǎK */
	screen_init(sht_back);
	sheet_refresh(sht_back, 0, 0, binfo->scrnx, binfo->scrny);

	/* {tHg̓ǂݍ */
	file = file_search("nihongo.fnt");
	nihongo = 0;
	if(file != 0) {
		i = file->size;
		nihongo = file_read(file->cno, &i);
	}
	if(nihongo == 0) {	/* tHgȂߓhԂ */
		nihongo = (unsigned char *) memory_alloc(mem, 16 * 256 + 32 * 94 * 47);
		for(i = 0;i < 16 * 256 + 32 * 94 * 47;i++) {
			nihongo[i] = 0xff;
		}
	}

	/* ^XNo[ */
	sht_tbar = sheet_alloc();
	buf_tbar = (unsigned char *)memory_alloc(mem, binfo->scrnx * 28);
	sheet_set(sht_tbar, buf_tbar, binfo->scrnx, 28, -1);
	tbar_init(sht_tbar);

	/* ʂ̕\ */
	sheet_slide(sht_tbar, 0, binfo->scrny - 28);
	sheet_updown(sht_tbar, 1);

	/* v */
	clock_tinit(sht_tbar);

	/* ʂ̕\ */
	sheet_slide(snow, 28, 28);
	sheet_updown(sht_back, 0);
	sheet_updown(sht_tbar, 1);
	sheet_updown(sht_mouse, 2);

	/* L[{[hƃ}EX̗L */
	keyboard_init();
	mouse_enable(&mdec);
	fifo_put(&kfifo, KEYCMD_LED);
	fifo_put(&kfifo, kleds);

	for(;;) {
		if(fifo_stat(&kfifo) > 0 && kcmd_wait < 0) {
			/* KCɃf[^𑗂 */
			kcmd_wait = fifo_get(&kfifo);
			kc_rwait();
			outb(PORT_KEYDATA, kcmd_wait);
		}
		cli();
		if(fifo_stat(&fifo) == 0) {
			/* `A̓EBhE̐؂ւς܂ */
			if(nmx >= 0) {
				sti();
				sheet_slide(sht_mouse, nmx, nmy);
				nmx = -1;
			} else if(nwx != 0x7fffffff) {
				sti();
				sheet_slide(sht, nwx, nwy);
				nwx = 0x7fffffff;
			} else if((snow->flag == SHEET_NONE || sn) && snow) {	/* ̓EBhEĂ */
				if(shts->top == 1) {	/* wiƃ}EXJ[\̂ */
					snow = 0;
				} else {
					if(sn != 0) {
						snow_off(snow);
					}
					snow = shts->s[shts->top - 2];
					snow_on(snow);
					sn = 0;
				}
			} else {
				task_sleep(task_sys);
				sti();
			}
		} else {
			i = fifo_get(&fifo);
			sti();
			if(i == 1) {	/* ̓EBhE؂ւv */
				sn = 1;
			} else if(256 <= i && i <= 511) {	/* L[{[hf[^ */
				if(i < 256+0x80) {	/* L[R[h𕶎R[hɕϊ */
					if(kshf != 0)  {
						s[0] = ktable1[i - 256];
					} else {
						s[0] = ktable[i - 256];
					}
				} else {
					s[0] = 0;
				}
				if('A' <= s[0] && s[0] <= 'Z') {	/* At@xbg */
					if(((kleds & 4) == 0 && kshf == 0) || ((kleds & 4) && kshf != 0)) {	/* ֕ϊ */
						s[0] += 0x20;
					}
				}
				if(snow != 0 && s[0] != 0) {	/* obNXy[XAEnterAʏ핶 */
					fifo_put(&snow->task->fifo, s[0] + 256);
				}
				if(i == 256 + 0x2a) {	/* VtgON */
					kshf |= 1;
				} else if(i == 256 + 0x36) {	/* EVtgON */
					kshf |= 2;
				} else if(i == 256 + 0x3a) {	/* CapsLock */
					kleds ^= 4;
					fifo_put(&kfifo, KEYCMD_LED);
					fifo_put(&kfifo, kleds);
				} else if(i == 256 + 0x3b) {	/* F1L[ */
					/* VKR\[̓EBhEɂ */
					if(snow != 0) {
						snow_off(snow);
					}
					if(snow->x != 0) {
						i = snow->x + 28;
						j = snow->y + 28;
						if(i > shts->xsize - 28) {
							i = shts->xsize - 28;
						}
						if(j > shts->ysize - 28) {
							j = shts->ysize - 28;
						}
					} else {
						i = 28;
						j = 28;
					}
					snow = cons_open();
					sheet_slide(snow, i, j);
					sheet_updown(snow, shts->top - 1);
					snow_on(snow);
				} else if(i == 256 + 0x3c) {	/* F2L[ */
					/* pESp[h̐؂ւ */
					snow->task->lmode ^= 1;
				} else if(i == 256 + 0x3e && snow->task->tss.ss0 != 0) {	/* F4L[ */
					cons_fonts(snow->task->cons, "\ñvO͋I܂B");
					cli();
					snow->task->tss.eax = (int) &(snow->task->tss.esp0);
					snow->task->tss.eip = (int) app_end;
					sti();
					task_run(snow->task, -1, 0);
				} else if(i == 256 + 0x45) {	/* NUMLock */
					kleds ^= 2;
					fifo_put(&kfifo, KEYCMD_LED);
					fifo_put(&kfifo, kleds);
				} else if(i == 256 + 0x46) {	/* ScrollLock */
					kleds ^= 1;
					fifo_put(&kfifo, KEYCMD_LED);
					fifo_put(&kfifo, kleds);
				} else if(i == 256 + 0xaa) {	/* VtgOFF */
					kshf &= ~1;
				} else if(i == 256 + 0xb6) {	/* EVtgOFF */
					kshf &= ~2;
				} else if(i == 256 + 0xfa) {	/* KCf[^󂯎 */
					kcmd_wait = -1;
				} else if(i == 256 + 0xfe) {	/* KCf[^󂯎Ȃ */
					kc_rwait();
					outb(PORT_KEYDATA, kcmd_wait);
				}
			} else if(512 <= i && i <= 767) {	/* }EXf[^ */
				if(mouse_decode(&mdec, i - 512) != 0) {
					/* }EXJ[\̈ړ */
					mdec.mx += mdec.x;
					mdec.my += mdec.y;
					if(mdec.mx < 0) {
						mdec.mx = 0;
					}
					if(mdec.my < 0) {
						mdec.my = 0;
					}
					if(mdec.mx > binfo->scrnx-1) {
						mdec.mx = binfo->scrnx-1;
					}
					if(mdec.my > binfo->scrny-1) {
						mdec.my = binfo->scrny-1;
					}
					if(mmx >= 0) {
						if(mdec.my > binfo->scrny - 28) {
							mdec.my = binfo->scrny - 28;
						}
					}
					sheet_slide(sht_mouse, mdec.mx, mdec.my);
					if((mdec.btn & 0x01) != 0) {
						/* {^Ă */
						if(mmx < 0) {
							/* ʏ탂[hiEBhEォTĎOɎĂj */
							for(j = shts->top - 2; j > 0; j--) {
								sht = shts->s[j];
								x = mdec.mx - sht->x;
								y = mdec.my - sht->y;
								if(0 <= x && x < sht->sx && 0 <= y && y < sht->sy)
									if(sht->buf[y * sht->sx + x] != sht->cinv) {
										sheet_updown(sht, shts->top - 2);
										if(sht != snow) {
											/* IEBhẼEBhEɂ */
											snow_off(snow);
											snow = sht;
											snow_on(snow);
										}
										if(3 <= x && x < sht->sx && 3 <= y && y < 21) {
											/* EBhEړ[h */
											mmx = mdec.mx;
											mmy = mdec.my;
											mmx2 = sht->x;
											nwy = sht->y;
										}
										if(sht->sx - 21 <= x && x < sht->sx - 5 && 5 <= y && y < 19) {
											/* u~v{^NbN */
											if((sht->flag & SHEET_FROMAPP) != 0 && (snow->task->tss.ss0) != 0) {
												/* Avp̃EBhEȂI */
												cli();
												snow->task->tss.eax = (int) &(snow->task->tss.esp0);
												snow->task->tss.eip = (int) app_end;
												sti();
												task_run(snow->task, -1, 0);
											} else {
												/* R\[ */
												cli();
												fifo_put(&snow->task->fifo, 4);
												sheet_updown(snow, -1);
												snow_off(snow);
												snow = shts->s[shts->top - 2];
												snow_on(snow);
												sti();
											}
										}
										break;
									}
							}
						} else {
							/* EChEړ[hiړʂvZēj */
							x = mdec.mx - mmx;
							y = mdec.my - mmy;
							nwx = (mmx2 + x + 2) & ~3;
							nwy = nwy + y;
							if(nwy > binfo->scrny - 28) {
								nwy = binfo->scrny - 28;
								mdec.my = binfo->scrny - 28;
							}
							mmy = mdec.my;
						}
					} else {
						/* {^ĂȂ */
						mmx = -1;	/* ʏ탂[h */
						if(nwx != 0x7fffffff) {
							sheet_slide(sht, nwx, nwy);
							nwx = 0x7fffffff;
						}
					}
				}
			} else if(768 <= i && i <= 1023) {	/* R\[I */
				cons_close(shts->sheet + (i - 768));
			} else if(1024 <= i && i <= 1279) {	/* R\[ */
				sht2 = shts->sheet+(i - 1024);
				memory_free(mem, (int) sht2->buf, (CONSOLE_X * 8 + 16) * (CONSOLE_Y * 16 + 36));
				sheet_free(sht2);
			}
		}
	}
}

void snow_on(struct sheet *snow)
{
	graphic_wctitle(snow, 1);
	if((snow->flag & SHEET_CONSOLE) != 0) {	/* R\[J[\ON */
		fifo_put(&snow->task->fifo, 2);
	}
	return;
}

void snow_off(struct sheet *snow)
{
	graphic_wctitle(snow, 0);
	if((snow->flag & SHEET_CONSOLE) != 0) {	/* R\[J[\OFF */
		fifo_put(&snow->task->fifo, 3);
	}
	return;
}

