/* ͂ڂOS̃wb_t@C */

/* bootpack.c */
/* N̏(asmhead.nasQƁj */
struct bootinfo {
	char cyls;
	char leds;
	char vmode;
	char reserve;
	short scrnx;
	short scrny;
	char *vram;
};
#define BOOTINFO_ADDR	0x00000ff0	/* bootinfõAhX */
extern struct fifo fifo;
extern struct mdec mdec;
extern struct memory *mem;
extern unsigned int memtotal;
extern int *fat;
extern unsigned char *nihongo;
extern struct task *task_sys, *task_clock, *task_fdc, *task_io;
extern struct sheet *sht_back;

/* naskfunc.nas */
void hlt(void);
void cli(void);
void sti(void);
void stihlt(void);
void outb(int port, int data);
void outw(int port, int data);
void outd(int port, int data);
int inb(int port);
int inw(int port);
int ind(int port);
int leflags(void);
void seflags(int eflags);
int lcr0(void);
void scr0(int cr0);
void lgdtr(int limit, int addr);
void lidtr(int limit, int addr);
void ltr(int tr);
void farjmp(int eip, int cs);
void farcall(int eip, int cs);
void app_start(int eip, int cs, int ds, int esp, int *esp0);
void except_asm_fpu(void);
void except_asm_stack(void);
void except_asm_general(void);
void timer_aihandle(void);
void keyboard_aihandle(void);
void fdc_aihandle(void);
void except_asm_dfint(void);
void mouse_aihandle(void);
void api_asm(void);
void app_end(void);
unsigned int memory_testsub(unsigned int start, unsigned int end);
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);

/* gdtidt.c */
/* GDT̏ */
struct segdesc {
	short limit_low, base_low;	/* ~bgƃx[X̉16bit */
	char base_mid;			/* x[X̉3byte */
	char access;			/* ANZX̉1byte */
	char limit_high;		/* ~bg̏4bitƃANZX̏4bit */
	char base_high;			/* x[X̏1byte */
};
/* IDT̏ */
struct gatedesc {
	short offset_low;		/* ItZbg̉16bit */
	short selector;			/* ZOgԍ */
	char dw_count;			/* f[^[hJEg */
	char access;			/* ANZX */
	short offset_high;		/* ItZbg̏16bit */
};
/* GDTIDT̃AhX */
#define IDT_ADDR	0x0026f800	/* IDT̃AhX */
#define IDT_LIMIT	0x000007ff	/* IDT̃~bg */
#define GDT_ADDR	0x00270000	/* GDT̃AhX */
#define GDT_LIMIT	0x0000ffff	/* GDT̃~bg */
#define GDT1_ADDR	0x00000000	/* GDT1̃AhX */
#define GDT1_LIMIT	0xffffffff	/* GDT1̃~bg */
#define BOOTPACK_ADDR	0x00280000	/* bootpack.hrb̃AhX */
#define BOOTPACK_LIMIT	0x0007ffff	/* bootpack.hrb̃~bg */
/* ZOg̑ */
#define AR_APP		0x0060		/* AvP[Vgpۂɑ */
#define AR_LDT		0x0082		/* LDT */
#define AR_TSS		0x0089		/* TSS */
#define AR_DATA_RW	0x4092		/* ǂݏ\f[^ */
#define AR_CODE_ER	0x409a		/* ǂݎs\R[h */
/* IDT̑ */
#define AR_INTGATE	0x008e		/* INTnh */
void gdtidt_init(void);
void seg_set(struct segdesc *sd, unsigned int base, unsigned int limit, int ar);
void gate_set(struct gatedesc *gd, int offset, int selector, int ar);

/* int.c */
/* PIC I/O|[gAhX */
#define PIC0_ICW1	0x0020	/* f[^ */
#define PIC0_OCW2	0x0020
#define PIC0_IMR	0x0021	/* 荞ݖډBWX^ */
#define PIC0_ICW2	0x0021
#define PIC0_ICW3	0x0021
#define PIC0_ICW4	0x0021
#define PIC1_ICW1	0x00a0
#define PIC1_OCW2	0x00a0
#define PIC1_IMR	0x00a1
#define PIC1_ICW2	0x00a1
#define PIC1_ICW3	0x00a1
#define PIC1_ICW4	0x00a1
void pic_init(void);

/* fifo.c */
/* FIFO\ */
struct fifo {
	struct task *task;	/* ^XN */
	int *buf;		/* FIFOobt@ */
	int size, free;		/* TCYƋ󂫃TCY */
	int flag;		/* tO */
	int nextr, nextw;	/* ǂݏʁX̎ւ̃|C^ */
};
/* tO */
#define FIFO_NONE	0x00	/*  */
#define FIFO_OVERRUN	0x01	/* obt@I[o[ */
void fifo_init(struct fifo *fifo, struct task *task, int *buf, int size);
int fifo_put(struct fifo *fifo, int data);
int fifo_get(struct fifo *fifo);
int fifo_stat(struct fifo *fifo);

/* task.c */
struct fifo;
#define TASK_MAX	1000	/* ^XN */
#define TASK_LEVEL	100	/* xƂ̃^XN */
#define TASK_LEVELS	10	/* x */
#define TASK_GDT	3	/* GDT̍ŏԍ */
struct tss {	/* tss */
	int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int ldtr, iomap;
};
struct task {	/* ^XN */
	struct tss tss;
	int fpu[108/4];		/* FPU */
	struct segdesc ldt[2];	/* LDT */
	int flag;
	int sel;		/* csԍ */
	int lv, pri;		/* Dx */
	struct fifo fifo;	/* FIFO */
	struct console *cons;	/* sR\[ */
	int ds, stack;		/* DSƃX^bNAhX */
	struct fhandle *fh;	/* t@Cnh */
	char *line;		/* R}hC */
	unsigned char lbyte;	/* \p */
	char lmode;		/* ̓[h */
};
struct tlevel {	/* x */
	int running;			/* 삵Ă^XN */
	int now;			/* 쒆̃^XNԍ */
	struct task *t[TASK_LEVEL];	/* xs̃Xg */
};
	
struct tasks {	/* Ǘ */
	int now;			/* 쒆̃x */
	char clv;			/* xύXtO */
	struct task *tfpu;		/* FPUgp̃^XN */
	struct tlevel level[TASK_MAX];	/* s̃xXg */
	struct task task[TASK_MAX];	/* ^XNXg */
};
/* tO */
#define TASK_NONE	0	/* gp */
#define TASK_ALLOC	1	/* gp */
#define TASK_SLEEP	1	/* X[v */
#define TASK_RUNNING	2	/* s */
#define TASK_MEMMAN	4	/* ǗgĂ邩 */
extern struct tasks *tasks;
struct task *task_init(void);
struct task *task_alloc(void);
void task_run(struct task *task, int level, int pri);
void task_sleep(struct task *task);
void task_switch(void);
void task_switchsub(void);
struct task *task_now(void);
void task_add(struct task *task);
void task_remove(struct task *task);
void task_idle(void);

/* except.c */
int *except_fpu(int *esp);
int *except_stack(int *esp);
int *except_general(int *esp);
void except_dfint(int *esp);

/* keyboard.c */
#define PORT_KEYDATA	0x0060	/* L[R[h̃|[g */
#define PORT_KEYSTAT	0x0064	/* KC̃Xe[^X̃|[g */
#define PORT_KEYCMD	0x0064	/* KCւ̃R}hM̃|[g */
#define KEYSTAT_NOREADY	0x02	/* KC֑Mł邩iPORT_KEYSTAT2bit */
#define KEYCMD_MWRITE	0x60	/* KC̏݃R}h */
#define KEYCMD_STMOUSE	0xd4	/* }EXւ̑MR}h */
#define KEYCMD_LED	0xed	/* LED */
#define KC_MODE		0x47	/* KC̓샂[hi}EXj */
void keyboard_init(void);
void keyboard_ihandle(int *esp);
void kc_rwait(void);

/* mouse.c */
struct mdec {	/* }EX̉ */
	unsigned char buf[3];	/* f[^ */
	char phase;		/*  */
	int x, y;		/* c̈ړ */
	int mx, my;		/* c̈ʒu */
	int btn;		/* {^ */
	int stat;		/*  */
};
#define MOUSE_RELEASED	1	/* {^𗣂ꂽ */
#define MOUSE_PRESSED	2	/* {^ꂽ */
#define MOUSE_MOVED	3	/* ꂽ */
#define MOUSE_DRAGGED	4	/* hbOꂽ */

#define MOUCMD_ENABLE	0xf4	/* }EX̗LR}h */
void mouse_ihandle(int *esp);
void mouse_enable(struct mdec *mdec);
int mouse_decode(struct mdec *mdec, unsigned char data);

/* memory.c */
#define MEMORY_FREE 4096			/* freě 32KB */
struct memory_free {	/* 󂫏 */
	unsigned int addr, size;	/* AhXƃTCY */
};
struct memory {	/* Ǘ */
	int frees;				/* 󂫏̌ */
	int maxfrees;				/* frees̍ől */
	int lostsize;				/* JɎsTCY */
	int losts;				/* JɎs */
	struct memory_free free[MEMORY_FREE];	/* 󂫏񃊃Xg */
};
#define MEMORY_ADDR		0x003c0000	/* ǗAhX */
#define EFLAGS_AC_BIT		0x00040000	/* eflagsAC-bit */
#define CR0_CACHE_DISABLE	0x60000000	/* cr0̃LbV֎~bit */
void memory_init(struct memory *mem);
unsigned int memory_test(unsigned int start, unsigned int end);
unsigned int memory_fsize(struct memory *mem);
unsigned int memory_alloc(struct memory *mem, unsigned int size);
int memory_free(struct memory *mem, unsigned int addr, unsigned int size);
unsigned int memory_allocsub(struct memory *mem, unsigned int size);
int memory_freesub(struct memory *mem, unsigned int addr, unsigned int size);

/* timer.c */
#define TIMER_MAX	500	/* Ǘ^C}̍v */
struct timer {	/* ^C} */
	struct timer *next;	/* ̃^CAEg̃^C} */
	struct timers *timers;	/* Ǘp̃AhX */
	unsigned int flag;	/* ^C}̃tO */
	struct fifo *fifo;	/* ʒm悤FIFO */
	unsigned int tout;	/* ^CAEg܂ł̃JEg */
	int data;		/* ^CAEĝƂf[^ */
};
struct timers {	/* ^C}Ǘ */
	unsigned int count;		/* Ŝ̃JEg */
	unsigned int next;		/* ̃^C} */
	struct timer *t;		/* 擪̃^CAEg */
	struct timer timer[TIMER_MAX];	/* ^C}Xg */
};
#define PIT_CTRL	0x0043		/* PITRg[|[g */
#define PIT_CNT0	0x0040		/* PITf[^|[g */
#define PIT_CLOCK	1193180000	/* mhzPʂPITNbN */

#define TIMER_NONE	0	/* gp̏ */
#define TIMER_ALLOC	1	/* mۂ */
#define TIMER_USING	2	/* 쒆̏ */
#define TIMER_ACANCEL	4	/* LZ */
void pit_init(void);
void timers_init(void);
void timer_ihandle(int *esp);
struct timer *timer_alloc(void);
void timer_init(struct timer *timer, struct fifo *fifo, int data);
void timer_set(struct timer *timer, unsigned int tout);
void timer_free(struct timer *timer);
void timer_cancel_auto(struct fifo *fifo);
int timer_cancel(struct timer *timer);

/* beep.c */
#define PORT_COUNT2	0x0042	/* JE^2|[g */
#define PORT_CTRL	0x0043	/* Rg[[h|[g */
#define PORT_SSTAT	0x0061	/* VXeXe[^X|[g */
#define PORT_SDATA	0x0061	/* VXef[^|[g */

void beep(int mhz);

/* io.c */
#define IO_READ		1	/* [hFǂݍ */
#define IO_WRITE	2	/* [hF */
#define IO_EXIT	3	/* [hF */

extern int *iomem;
extern int *iorreq, *iowreq;
extern int iobuf[32];
extern struct task *task_req;	

void io_task(void);
void io_tinit(void);
void io_runreq(char mode, int cyl, int head, int *req, int *mem);
int io_runreqsub(char mode, char cyl, char head, char sect, char sects);
void io_req(char mode, int s);
int io_stat(char mode, int s);

/* fdc.c */
struct fdc {
	char mode;		/* [h */
	char cyl, head, sect;	/* Ԓn */
	char sects;		/*  */
	char st0;		/* UgXe[^X */
};

#define PORT_DMAC0_CBAR		0x0004	/* DMAC0̃x[XAhX */
#define PORT_DMAC0_CBCR		0x0005	/* DMAC0̏JEg */
#define PORT_DMAC0_SMR		0x000a	/* DMAC0̃}XN */
#define PORT_DMAC0_MODE		0x000b	/* DMAC0̏ */
#define PORT_DMAP_ADDRUP	0x0081	/* DMAC̏ʃx[XAhX */
#define PORT_DMAC1_CBAR		0x00c0	/* DMAC1̃x[XAhX */
#define PORT_DMAC1_MODE		0x00d6	/* DMAC1̏ */
#define PORT_FDC_MOTOR		0x03f2	/* [^̏ */
#define PORT_FDC_STAT		0x03f4	/* FDCԃWX^ */
#define PORT_FDC_DATA		0x03f5	/* FDC̃f[^ */

extern struct fdc fdc;
extern int fdcbuf[32];

void fdc_task(void);
void fdc_tinit(void);
void fdc_ihandle(int *esp);
void fdc_init(void);
void fdc_setdma(void);
void fdc_sethead(void);
void fdc_setcmd(void);
void fdc_getint(void);
void fdc_getrstat(void);
char fdc_getrstatsub(void);
void fdc_sendcmd(int data);
void fdc_initwait(int wait);
void fdc_req(char mode, char cyl, char head, char sect, char send);
int fdc_reqstat(void);

/* file.c */
struct file {	/* t@CGg */
	unsigned char name[8], ext[3];	/* OƊgq */
	unsigned char type;		/* t@C */
	char reserve[10];		/* \ */
	unsigned short time, date;	/* Ɠt */
	unsigned short cno;		/* f[^̃ZN^ԍ */
	unsigned int size;		/* f[^TCY */
};
struct fhandle {	/* t@Cnh */
	int flag;	/* tO */
	struct file *f;	/* t@CGg */
	int pos;	/* t@C̈ʒu */
	int size;	/* t@CTCY */
	char *buf;	/* t@Cobt@ */
	int cno;	/* obt@̎wZN^ԍ */
	int bsize;	/* obt@TCY */
	int bpos;	/* obt@̈ʒu */
};
#define FHANDLE_NONE	0x00	/* ύXKȂ */
#define FHANDLE_CH	0x01	/* ύXK */

#define DISKIMG_ADDR	0x00100000	/* fBXNobt@ */
#define FAT_ADDR	0x00100200	/* FAT */
#define FILE_ENTRY_ADDR	0x00102600	/* t@CGgAhX */
#define FILE_DATA_ADDR	0x00103e00	/* t@Cf[^AhX */

#define FILE_DEFAULT	0x20	/* ʂ̃t@C */
int fat_read(int *fat, unsigned char *img);
int fat_write(unsigned char *img, int *fat);
int fat_get(int *fat);
struct file *file_search(unsigned char *name);
struct file *file_create(unsigned char *name);
int file_delete(struct file *file);
int file_rdwri(int ms, int sects);
char *file_read(int cno, int *size);
int file_write(struct fhandle *fh, int *fat, int size);
int file_readsub(char *buf, int cno, int size);
void file_setbuf(struct fhandle *fh, int *fat, int sect);
void file_settime(struct file *file);

/* sheet.c */
#define SHEET_MAX	256	/* V[g̖ */
struct sheet {
	struct sheets *shts;	/* Ǘp̃AhX */
	unsigned char *buf;	/* obt@̃AhX */
	int flag;		/* V[g̃tO */
	int height;		/* V[g̍ */
	char cinv;		/* V[g̓F */
	int x, y;		/* V[g̉cʒu */
	int sx, sy;		/* V[g̉cTCY */
	struct task *task;	/* ^XN */
};
struct sheets {	/* V[g̊Ǘ */
	unsigned char *vram;		/* VRAMAhX */
	unsigned char *map;		/* ʃC[W̃AhX */
	int xsize, ysize;		/* ʂ̉cTCY */
	int top;			/* Ŝ̃V[g̍ */
	struct sheet *s[SHEET_MAX];	/* ̃V[gXg */
	struct sheet sheet[SHEET_MAX];	/* V[gXg */
};
/* tO */
#define SHEET_NONE	0	/* gp */
#define SHEET_USE	1	/* gp */
#define SHEET_FROMAPP	2	/* Av */
#define SHEET_CONSOLE	4	/* R\[p */
extern struct sheets *shts;
void sheets_init(unsigned char *vram, int xsize, int ysize);
struct sheet *sheet_alloc(void);
void sheet_set(struct sheet *sht, unsigned char *buf, int xsize, int ysize, int cinv);
void sheet_updown(struct sheet *sht, int height);
void sheet_refresh(struct sheet *sht, int x0, int y0, int x1, int y1);
void sheet_refreshsub(struct sheets *shts, int x0, int y0, int x1, int y1, int h0, int h1);
void sheet_slide(struct sheet *sht, int x0, int y0);
void sheet_free(struct sheet *sht);
void sheet_refreshmap(struct sheets *shts, int x0, int y0, int x1, int y1, int h0);

/* graphic.c */
/* Fԍipalette_initQƁj */
#define COLOR_000000	0
#define COLOR_FF0000	1
#define COLOR_00FF00	2
#define COLOR_FFFF00	3
#define COLOR_0000FF	4
#define COLOR_FF00FF	5
#define COLOR_00FFFF	6
#define COLOR_FFFFFF	7
#define COLOR_C6C6C6	8
#define COLOR_840000	9
#define COLOR_008400	10
#define COLOR_848400	11
#define COLOR_000084	12
#define COLOR_840084	13
#define COLOR_008484	14
#define COLOR_848484	15
void palette_init(void);
void palette_set(unsigned char *rgb, int start, int end);
void screen_init(struct sheet *sht);
void tbar_init(struct sheet *sht);
void mcursor_init(unsigned char *mouse, char bc);
unsigned char rgb2pal(int r, int g, int b, int x, int y);
void graphic_box(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1);
void graphic_block(unsigned char *buf, int vxsize, int pxsize, int pysize, int px, int py, unsigned char *fbuf, int bxsize);
void graphic_font(unsigned char *buf, int xsize, unsigned char c, int x, int y, unsigned char *font);
void graphic_fonts(struct sheet *sht, int b, int c, int x, int y, unsigned char *s);
void graphic_nfonts(struct sheet *sht, int b, int c, int x, int y, unsigned char *s, int l);
void graphic_fontssub(unsigned char *buf, int xsize, unsigned char c, int x, int y, unsigned char *s);

/* window.c */
void graphic_window(struct sheet *sht, int xsize, int ysize, char *title, char m);
void graphic_wtitle(struct sheet *sht, int xsize, char *title, char m);
void graphic_wctitle(struct sheet *sht, char m);
void graphic_tbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy);

/* clock.c */
struct clock {	/* ₷邽߂̂ */
	int sec, min, hour;
	int day, month, year;
};
#define PORT_RTC_SREG	0x0070	/* RTCWX^w */
#define PORT_RTC_DATA	0x0071	/* RTCf[^ */
extern struct clock clock;
void clock_task(struct sheet *sht);
 void clock_tinit(struct sheet *sht_tbar);
void clock_get(struct clock *clck);
int cmos_read(unsigned char addr);
void rtc_read(struct clock *clock);

/* console.c */
struct console {	/* R\[ŗLf[^ */
	struct sheet *sht;	/* V[g */
	struct timer *cur;	/* J[\^C} */
	int cx, cy;		/* cJ[\̈ʒu */
	int cc;			/* J[\[h */
};
/* R\[̃f[^ */
#define APP_DS_ADDR	0x0fe8	/* AvP[VCSAhX */
#define CONSOLE_ADDR	0x0fec	/* APIɎgR\[AhX */
#define CONSOLE_X	30	/* ̕ */
#define CONSOLE_Y	10	/* c̕ */
/* AvP[Ṽf[^ */
#define HRB_SEG_SIZE	0x0000	/* ZOgTCY */
#define HRB_ESP_INIT	0x000c	/* ESP̏l */
#define HRB_DATA_SIZE	0x0010	/* f[^TCY */
#define HRB_DATA_ADDR	0x0014	/* f[^̃AhX */
#define HRB_MALLOC	0x0020	/* mallocAhX */
void cons_task(void);
struct sheet *cons_open(void);
void cons_close(struct sheet *sht);
struct task *cons_topen(struct sheet *sht);
void cons_tclose(struct task *task);
void cons_fonts(struct console *cons, char *s);
void cons_font(struct console *cons, char c, char m);
void cons_nline(struct console *cons);
void cons_cmd_run(struct console *cons, char *line);
void cons_cmd_mem(struct console *cons);
void cons_cmd_cls(struct console *cons);
void cons_cmd_dir(struct console *cons);
void cons_cmd_delete(struct console *cons, char *line);
int cons_runapp(struct console *cons, char *line);

/* api.c */
struct mouse {	/* }EX*/
	int x, y;
	int btn;
	int stat;
};

struct pict {	/* 摜 */
	int sx, sy;
	int mode;
};

/* int modeŎg萔 */
#define PICT_BMP	1	/* .bmp`ł */
#define PICT_JPEG	2	/* .jpg`ł */

int *api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_putc(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_puts(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_nputs(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_getd(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_getmouse(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_getcmd(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_malloc(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_mfree(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_talloc(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_tfree(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_tinit(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_tset(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fopen(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fclose(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fsize(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fseek(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fread(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fwrite(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_fdelete(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_beep(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_getclock(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wopen(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wclose(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wpoint(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wline(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wbox(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wputs(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wnputs(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wrefresh(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_getpinfo(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_wpict(struct task *task, int *reg, int ds, int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);

/* tek.c */
int tek_getsize(unsigned char *p);
int tek_decomp(unsigned char *p, char *q, int size);

/* bmp.nasm */
struct dll_strpicenv {	/* 64KB */
	int work[64 * 1024 / 4];
};
struct rgb {	/* FPʂł̃f[^ */
	unsigned char b, g, r, t;
};

int info_BMP(struct dll_strpicenv *env, int *info, int size, char *fp);
int decode0_BMP(struct dll_strpicenv *env, int size, char *fp, int b_type, char *buf, int skip);

/* jpeg.c */
int info_JPEG(struct dll_strpicenv *env, int *info, int size, char *fp);
int decode0_JPEG(struct dll_strpicenv *env, int size, char *fp, int b_type, char *buf, int skip);
