/* GDTEIDT */

#include "bootpack.h"

void gdtidt_init(void)
{
	struct segdesc *gdt = (struct segdesc *)GDT_ADDR;
	struct gatedesc *idt = (struct gatedesc *)IDT_ADDR;
	int i;

	/* GDT̏ */
	for(i = 0;i <= GDT_LIMIT/8;i++)
		seg_set(gdt+i, 0, 0, 0);
	lgdtr(GDT_LIMIT, GDT_ADDR);

	/* GDT̐ݒ */
	seg_set(gdt+1, GDT1_ADDR, GDT1_LIMIT, AR_DATA_RW);		/* S */
	seg_set(gdt+2, BOOTPACK_ADDR, BOOTPACK_LIMIT, AR_CODE_ER);	/* bootpack.hrb */

	/* IDT̏ */
	for(i = 0;i <= IDT_LIMIT/8;i++)
		gate_set(idt+i, 0, 0, 0);
	lidtr(IDT_LIMIT, IDT_ADDR);

	/* IDT̐ݒ */
	gate_set(idt+0x07, (int)except_asm_fpu, 2*8, AR_INTGATE);	/* FPUO */
	gate_set(idt+0x0c, (int)except_asm_stack, 2*8, AR_INTGATE);	/* X^bNO */
	gate_set(idt+0x0d, (int)except_asm_general, 2*8, AR_INTGATE);	/* ʕیO */
	gate_set(idt+0x20, (int)timer_aihandle, 2*8, AR_INTGATE);	/* ^C} */
	gate_set(idt+0x21, (int)keyboard_aihandle, 2*8, AR_INTGATE);	/* L[{[h */
	gate_set(idt+0x26, (int)fdc_aihandle, 2*8, AR_INTGATE);		/* FDC */
	gate_set(idt+0x27, (int)except_asm_dfint, 2*8, AR_INTGATE);	/* sS荞 */
	gate_set(idt+0x2c, (int)mouse_aihandle, 2*8, AR_INTGATE);	/* }EX */
	gate_set(idt+0x30, (int)api_asm, 2*8, AR_INTGATE+AR_APP);	/* API */

	return;
}

void seg_set(struct segdesc *sd, unsigned int base, unsigned int limit, int ar)
{

	if(limit > 0xfffff) {
		ar |= 0x8000;	/* G-bit on */
		limit /= 0x1000;/* 4KBPʂɂ */
	}
	sd->limit_low = limit&0xffff;
	sd->base_low = base&0xffff;
	sd->base_mid = (base>>16)&0xff;
	sd->access = ar&0xff;
	sd->limit_high = ((limit>>16)&0x0f)|((ar>>8)&0xf0);
	sd->base_high = (base>>24)&0xff;

	return;
}

void gate_set(struct gatedesc *gd, int offset, int selector, int ar)
{
	gd->offset_low = offset&0xffff;
	gd->selector = selector;
	gd->dw_count = (ar>>8)&0xff;
	gd->access = ar&0xff;
	gd->offset_high = (offset>>16)&0xffff;

	return;
}
