/* I/O^XN֌W */

#include "bootpack.h"

int *iomem;		/* LbV */
int *iorreq, *iowreq;	/* NGXg */
int iobuf[32];		/* FIFÕobt@ */
struct task *task_req;	/* NGXg̃^XN */

/* I/O^XŃAefoCXhCoŒۉ^XNłB
 * I/O^XNɗvɂ́Aio_reqgAĂ炢ʂ
 * ɂ́Aio_statgAȂ0AُȂ1ԂB
 */
void io_task(void)
{
	int i, j;

	for(;;) {
		cli();
		if(fifo_stat(&task_io->fifo) == 0) {
			task_sleep(task_io);
			sti();
		} else {
			i = fifo_get(&task_io->fifo);
			sti();

			if(i == 1) {	/* I/OJn */
				for(j = 0; j < 160; j++) {
					if(iorreq[j] != 0) {
						io_runreq(IO_READ, j / 2, j % 2, &iorreq[j], &iomem[j]);
					}
					if(iowreq[j] != 0) {
						io_runreq(IO_WRITE, j / 2, j % 2, &iowreq[j], &iomem[j]);
					}
				}
				task_run(task_req, -1, 0);	/* NGXg̃^XNsƁA
								 * io_statŃX[vĂ̂
								 * ĊJ邱ƂɂȂB */
			}
		}
	}
}

void io_tinit(void)
{
	struct bootinfo *binfo = (struct bootinfo *) BOOTINFO_ADDR;
	int i;

	task_io = task_alloc();
	task_io->stack = memory_alloc(mem, 65536);
	task_io->tss.eip = (int) &io_task;
	task_io->tss.esp = task_io->stack + 65536;
	task_io->tss.es = 1 * 8;
	task_io->tss.cs = 2 * 8;
	task_io->tss.ss = 1 * 8;
	task_io->tss.ds = 1 * 8;
	task_io->tss.fs = 1 * 8;
	task_io->tss.gs = 1 * 8;

	iomem = (int *) memory_alloc(mem, 640);
	iorreq = (int *) memory_alloc(mem, 640);
	iowreq = (int *) memory_alloc(mem, 640);
	fifo_init(&task_io->fifo, task_io, iobuf, 32);
	for(i = 0; i < (binfo->cyls - 1) * 2; i++) {
		iomem[i] = 0x3ffff;
		iorreq[i] = 0;
		iowreq[i] = 0;
	}
	for(; i < 160; i++) {
		iomem[i] = 0;
		iorreq[i] = 0;
		iowreq[i] = 0;
	}

	task_run(task_io, 2, 2);
	return;
}

void io_runreq(char mode, int cyl, int head, int *req, int *mem)
{
	int *req, i, j;

	if(mode == IO_READ) {
		req = &iorreq[cyl * 2 + head];
	} else if(mode == IO_WRITE) {
		req = &iowreq[cyl * 2 + head];
	}

	i = 1;
	for(;;) {
		if((*req & (1 << i)) != 0) {
			j = io_runreqsub(mode, cyl, head, i, 1);
			if(j == 0) {
				iomem[cyl * 2 + head] |= 1 << i;
			} else {
				iomem[cyl * 2 + head] &= ~(1 << i);
			}
			*req &= ~(1 << i);
		}
		i++;
		if(i > 18) {
			return;
		}
	}/*

	int sst, se, i;

	se = 1;
	for(; se <= 18;) {
		sst = se;
		for(; se <= 18; se++) {
			if((*req & (1 << se)) == 0) {
				break;
			}
		}
		if(se - sst != 0) {
			i = io_runreqsub(mode, (char) cyl, (char) head, (char) sst, (char) (se - sst));
			if(i == 0) {
				for(i = sst; i < se; i++) {
					*mem |= 1 << i;
					*req &= ~(1 << i);
				}
			} else {
				for(i = sst; i < se; i++) {
					*mem &= ~(1 << i);
					*req &= ~(1 << i);
				}
			}
		} else {
			se++;
		}
	}
	return;*/
}

int io_runreqsub(char mode, char cyl, char head, char sect, char sects)
{
	int i;

	fdc_req(mode, cyl, head, sect, sects);
	i = fdc_reqstat();
	return i;
}

void io_req(char mode, int s)
{
	int rno;
	char sect;

	rno = s / 18;
	sect = (char) (s % 18 + 1);

	if(mode == IO_READ) {
		if((iomem[rno] & (1 << sect)) == 0) {
			iorreq[rno] |= 1 << sect;
		}
	} else if(mode == IO_WRITE) {
		iowreq[rno] |= 1 << sect;
		iomem[rno] &= ~(1 << sect);

	}
	return;
}

int io_stat(char mode, int s)
{
	struct task *task = task_now();
	int *req, rno;
	char sect;

	rno = s / 18;
	sect = (char) (s % 36 % 18 + 1);
	if(mode == IO_READ) {
		req = &iorreq[rno];
	} else if(mode == IO_WRITE) {
		req = &iowreq[rno];
	}

	for(;;) {
		if((iomem[rno] & (1 << sect)) != 0) {
			if((*req & (1 << sect)) == 0) {
				return 0;
			} else {
				return 1;
			}
		} else {
			task_req = task;
			fifo_put(&task_io->fifo, 1);
			task_sleep(task_req);
		}
	}
}
