/* ֌W */

#include "bootpack.h"

void memory_init(struct memory *mem)
{
	int i;

	mem->frees = 0;
	mem->maxfrees = 0;
	mem->lostsize = 0;
	mem->losts = 0;
	for(i = 0; i < MEMORY_FREE; i++) {
		mem->free[i].addr = 0;
		mem->free[i].size = 0;
	}
	return;
}

unsigned int memory_test(unsigned int start, unsigned int end)
{
	char flg486 = 0;
	unsigned int eflg, cr0, i;

	/* CPŨLbV@\~ */
	eflg = leflags();
	eflg = EFLAGS_AC_BIT;	/* AC-bit on */
	seflags(eflg);
	eflg = leflags();
	if((eflg & EFLAGS_AC_BIT) != 0) {	/* LbVɑΉĂȂoffɖ߂ */
		flg486 = 1;
	}
	eflg &= ~ EFLAGS_AC_BIT;	/* AC-bit off */
	seflags(eflg);

	if(flg486 != 0) {
		cr0 = lcr0();
		cr0 |= CR0_CACHE_DISABLE;	/* LbV֎~ */
		scr0(cr0);
	}
	i = memory_testsub(start, end);
	if(flg486 != 0) {
		cr0 = lcr0();
		cr0 &= ~ CR0_CACHE_DISABLE;	/* LbV */
		scr0(cr0);
	}
	return i;
}

unsigned int memory_fsize(struct memory *mem)
{
	unsigned int i, t = 0;

	for(i = 0; i < mem->frees; i++) {
		t += mem->free[i].size;
	}
	return t;
}

unsigned int memory_alloc(struct memory *mem, unsigned int size)
{
	unsigned int i, a;

	for(i = 0; i < mem->frees; i++) {
		if(mem->free[i].size >= size) {
			a = mem->free[i].addr;
			mem->free[i].addr += size;
			mem->free[i].size -= size;
			if(mem->free[i].size == 0) {
				mem->frees--;
				for(; i < mem->frees; i++) {
					mem->free[i] = mem->free[i + 1];
				}
			}
			return a;
		}
	}
	return 0;
}

int memory_free(struct memory *mem, unsigned int addr, unsigned int size)
{
	int i, j;

	/* addrɕׂĂ邽߁Aꏊ߂ */
	for(i = 0; i < mem->frees; i++) {
		if(mem->free[i].addr > addr) {
			break;
		}
	}

	/* Oƌ܂Ƃ߂Ă݂ */
	if(i > 0) {
		/* OƂ܂Ƃ߂ */
		if(mem->free[i - 1].addr + mem->free[i - 1].size == addr) {
			mem->free[i - 1].size += size;
			if(i < mem->frees) {
				/* ɂ܂Ƃ߂ */
				if(addr + size == mem->free[i].addr) {
					mem->free[i - 1].size += mem->free[i].size;
					/* Oւ߂ */
					mem->frees--;
					for(; i < mem->frees; i++) {
						mem->free[i] = mem->free[i + 1];
					}
				}
			}
			return 0;
		}
	}

	/* Ƃ܂Ƃ߂Ă݂ */
	if(i < mem->frees) {
		/* Ƃ܂Ƃ߂ */
		if(addr + size == mem->free[i].addr) {
			mem->free[i].addr = addr;
			mem->free[i].size += size;
			return 0;
		}
	}

	/* VɍڂĂĂ݂ */
	if(mem->frees < MEMORY_FREE) {
		/* free[i]ɂ炵āAi[ */
		for(j = mem->frees; j > i; j--) {
			mem->free[j] = mem->free[j - 1];
		}
		mem->frees++;
		/* frees̍ől̍XV */
		if(mem->maxfrees < mem->frees) {
			mem->maxfrees = mem->frees;
		}
		mem->free[i].addr = addr;
		mem->free[i].size = size;
		return 0;
	}

	/* ǂɂi[łɁAs */
	mem->losts++;
	mem->lostsize += size;
	return -1;
}
