/* }EX֌W */

#include "bootpack.h"

void mouse_ihandle(int *esp)
{
	int data;

	outb(PIC1_OCW2, 0x64);	/* IRQ-12ɎtPIC1ɒʒm */
	outb(PIC0_OCW2, 0x62);	/* IRQ-02ɎtPIC0ɒʒm */
	data = inb(PORT_KEYDATA);
	fifo_put(&fifo, 512 + data);
	return;
}

void mouse_enable(struct mdec *mdec)
{
	kc_rwait();
	outb(PORT_KEYCMD, KEYCMD_STMOUSE);
	kc_rwait();
	outb(PORT_KEYDATA, MOUCMD_ENABLE);	/* CPUACKi0xfaj𑗐M */
	mdec->phase = 0;	/* }EX0xfa҂ */
	return;
}

int mouse_decode(struct mdec *mdec, unsigned char data)
{
	if(mdec->phase == 0) {	/* }EX0xfa҂Ă */
		if(data == 0xfa) {
			mdec->phase = 1;
		}
		return 0;
	}
	if(mdec->phase == 1) {	/* }EX1Byteڂ҂Ă */
		if((data&0xc8) == 0x08) {
			mdec->buf[0] = data;
			mdec->phase = 2;
		}
		return 0;
	}
	if(mdec->phase == 2) {	/* }EX2Byteڂ҂Ă */
		mdec->buf[1] = data;
		mdec->phase = 3;
		return 0;
	}
	if(mdec->phase == 3) {	/* }EX3Byteڂ҂Ă */
		mdec->buf[2] = data;
		mdec->phase = 1;
		mdec->btn = mdec->buf[0] & 0x07;
		mdec->x = mdec->buf[1];
		mdec->y = mdec->buf[2];
		if((mdec->buf[0] & 0x10) != 0) {
			mdec->x |= 0xffffff00;
		}
		if((mdec->buf[0] & 0x20) != 0) {
			mdec->y |= 0xffffff00;
		}
		mdec->y = - mdec->y;	/* }EXy͕̕ */
		if(mdec->x == 0 && mdec->y == 0) {
			if(mdec->btn == 0) {
				mdec->stat = MOUSE_RELEASED;
			} else {
				mdec->stat = MOUSE_PRESSED;
			}
		} else {
			if(mdec->btn == 0) {
				mdec->stat = MOUSE_MOVED;
			} else {
				mdec->stat = MOUSE_DRAGGED;
			}
		}
		return 1;
	}
	return -1;
}
