#include "main.h"
#include <stdio.h>
#include <string.h>

struct sheet *consOpen(int *fat)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht = shtAlloc();
	unsigned char *buf = (unsigned char *) memAlloc(mem, 256 * 165);
	struct task *task;
	shtSet(sht, buf, 256, 165, -1);
	winAlloc(sht, "R\[", 0);
	textbox(sht, _000000, 8, 28, 240, 128);
	task = consOpen0(sht, fat, "console");
	sht->task = task;
	sht->flag |= SHEET_CUR;
	return sht;
}

struct task *consOpen0(struct sheet *sht, int *fat, char *name)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *task = taskAlloc(name);
	int *fifo = (int *) memAlloc(mem, 128 * 4);
	task->cons = 0;
	task->stack = memAlloc(mem, 64 * 1024);
	task->tss.esp = task->stack + 64 * 1024 - 8;
	task->tss.eip = (int) &consTask;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	fifoInit(&task->fifo, fifo, 128, task);
	task->fat = fat;
	taskRun(task, 2, 2);
	return task;
}

void consClose(struct sheet *sht)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *task = sht->task;
	memFree(mem, (int) sht->buf, 42240);
	shtFree(sht);
	consClose0(task);
	return;
}

void consClose0(struct task *task)
{
	extern struct tasks *tctl;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	taskSleep(task);
	memFree(mem, task->stack, 65536);
	memFree(mem, (int) task->fifo.buf, 512);
	cli();
	task->flag = 0;
	if (tctl->tfpu == task) {
		tctl->tfpu = 0;
	}
	sti();
	return;
}

void consExitreq(struct sheet *sht)
{
	extern struct sheets *shts;
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	fifoPut(fifo, 768 + (sht - shts->sheet));
	return;
}

void consExitreq0(struct task *task)
{
	extern struct tasks *tctl;
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	fifoPut(fifo, 1024 + (task - tctl->task));
	return;
}

void consExitreq1(struct sheet *sht)
{
	extern struct sheets *shts;
	struct fifo *fifo = (struct fifo *) *((int *) FIFO_ADDR);
	fifoPut(fifo, 2024 + (sht - shts->sheet));
	return;
}

void consNline(struct console *cons)
{
	struct task *task = taskNow();
	struct sheet *sht = cons->sht;
	int x, y;
	if (cons->cy < 140) {
		cons->cy += 16;
	} else if (sht != 0) {
		for (y = 28; y < 140; y++) {
			for (x = 8; x < 248; x++) {
				sht->buf[y * sht->sx + x] = sht->buf[(y + 16) * sht->sx + x];
			}
		}
		for (y = 140; y < 156; y++) {
			for (x = 8; x < 248; x++) {
				sht->buf[y * sht->sx + x] = _000000;
			}
		}
		shtRefresh(sht, 8, 28, 248, 156);
	}
	cons->cx = 8;
	if (task->lbyte != 0) {
		cons->cx += 8;
	}
	return;
}

void consPutc(struct console *cons, unsigned char c, char m)
{
	struct sheet *sht = cons->sht;
	unsigned char s[2];

	s[0] = c;
	s[1] = 0;
	if (s[0] == 0x09) {
		for (;;) {
			if (cons->sht != 0) {
				graphicBox(sht, _000000, cons->cx, cons->cy, cons->cx + 7, cons->cy + 15);
				graphicPuts(sht, _FFFFFF, cons->cx, cons->cy, " ");
				shtRefresh(sht, cons->cx, cons->cy, cons->cx + 8, cons->cy + 16);
			}
			cons->cx += 8;
			if (cons->cx == 248) {
				consNline(cons);
			}
			if (((cons->cx - 8) & 0x1f) == 0) {
				break;
			}
		}
	} else if (s[0] == 0x0a) {
		consNline(cons);
	} else if (s[0] == 0x0d) {
	} else {
		if (cons->sht != 0) {
			graphicBox(sht, _000000, cons->cx, cons->cy, cons->cx + 7, cons->cy + 15);
			graphicPuts(sht, _FFFFFF, cons->cx, cons->cy, s);
			shtRefresh(sht, cons->cx - 8, cons->cy, cons->cx + 8, cons->cy + 16);
		}
		if (m != 0) {
			cons->cx += 8;
			if (cons->cx == 248) {
				consNline(cons);
			}
		}
	}
	return;
}

void consPuts(struct console *cons, unsigned char *s, int n)
{
	int i;

	if (n != -1) {
		for (i = 0; i < n; i++) {
			consPutc(cons, s[i], 1);
		}
	} else {
		for (; *s != 0; s++) {
			consPutc(cons, *s, 1);
		}
	}
	return;
}

void consExit(struct console *cons, int *fat)
{
	struct task *task = taskNow();
	cli();
	if (cons->sht != 0) {
		consExitreq(cons->sht);
	} else {
		consExitreq0(task);
	}
	sti();
	for (;;) {
		taskSleep(task);
	}
}

struct task *consNcst(unsigned char *line, int *fat)
{
	struct task *task;
	struct fifo *fifo;
	int i;
	char s[13];
	for (i = 0; i < 12; i++) {
		if (line[i] == 0 || line[i] == ' ') {
			s[i] = 0;
			break;
		}
		s[i] = line[i];
	}
	task = consOpen0(0, fat, s);
	fifo = &task->fifo;
	for (i = 0; line[i] != 0; i++) {
		fifoPut(fifo, 256 + line[i]);
	}
	fifoPut(fifo, 256 + 10);
	return task;
}

int consApp(struct console *cons, int *fat)
{
	struct file *file;
	struct task *task = taskNow();
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	unsigned char s[13], *p, *q;
	int apps, segs, esp, dats, dhrb, ahrb, i;
	for (i = 0; i < 13; i++) {
		if (cons->line[i] <= ' ') {
			break;
		}
		s[i] = cons->line[i];
	}
	s[i] = 0;
	file = fileSearch(s);
	if (file == 0 && s[i - 1] != '.') {
		s[i] = '.';
		s[i + 1] = 'H';
		s[i + 2] = 'R';
		s[i + 3] = 'B';
		s[i + 4] = 0;
		file = fileSearch(s);
	}

	if (file != 0) {
		apps = file->size;
		p = fileReadTek(fat, file->cno, &apps);
		if (apps >= 36 && strncmp(p + 4, "Hari", 4) == 0 && *p == 0x00) {
			segs = *((int *) p);
			esp = *((int *) (p + 0x0c));
			dats = *((int *) (p + 0x10));
			dhrb = *((int *) (p + 0x14));
			q = (unsigned char *) memAlloc(mem, segs);
			task->ds = (int) q;
			segdescSet(task->ldt, (int) p, apps - 1, RXCODE + 0x60);
			segdescSet(task->ldt + 1, (int) q, segs - 1, RWDATA + 0x60);
			for (i = 0; i < dats; i++) {
				q[esp + i] = p[dhrb + i];
			}
			task->mem = 0;
			/* HariMainĂяoA߂ƂɏIpAPIĂяo */
			ahrb = *((int *) (p + 0x1c)) + 0x20 - 9;
			p[4] = 0xe8;
			p[5] = ahrb & 0xff;
			p[6] = (ahrb >> 8) & 0xff;
			p[7] = (ahrb >> 16) & 0xff;
			p[8] = (ahrb >> 24) & 0xff;
			p[9] = 0xb8;
			p[10] = 0x00;
			p[11] = 0x00;
			p[12] = 0x00;
			p[13] = 0x00;
			p[14] = 0xcd;
			p[15] = 0x30;
			appRun(0x04, 0 * 8 + 4, 1 * 8 + 4, esp, &(task->tss.esp0));

			shtClean(task);
			timerAllcancel(&task->fifo);
			beep(0);
			for (i = 0; i < 8; i++) {
				if (task->fh[i].buf != 0) {
					bufFlush(&task->fh[i]);
					memFree(mem, (int) task->fh[i].buf, 512);
					task->fh[i].buf = 0;
				}
			}
			task->lbyte = 0;
			memFree(mem, (int) q, segs);
		} else {
			consPuts(cons, "Ȏst@Cł͂܂B", -1);
		}
		memFree(mem, (int) p, apps);
		return 1;
	}
	return 0;
}

void consRuncmd(struct console *cons, int *fat)
{
	if (strcmp(cons->line, "exit") == 0) {
		consExit(cons, fat);
	} else if (strncmp(cons->line, "ncst ", 5) == 0) {
		consNcst(cons->line + 5, fat);
	} else if (cons->line[0] != 0) {
		if (consApp(cons, fat) == 0) {
			consPuts(cons, "R}hsł܂B", -1);
		}
	}
	return;
}

void consTask(struct sheet *sht)
{
	struct task *task = taskNow();
	struct console cons;
	struct fhandle fh[8];
	int i;
	for (i = 0; i < 8; i++) {
		fh[i].buf = 0;
	}
	cons.sht = sht;
	cons.cx = 8;
	cons.cy = 28;
	cons.cc = -1;
	task->cons = &cons;
	task->fh = fh;
	consPutc(&cons, '>', 1);

	for (;;) {
		cli();
		if (fifoStat(&task->fifo) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(&task->fifo);
			sti();
			if (i == 1) {
				consExit(&cons, task->fat);
			} else if (i == 2) {
				cons.cc = _FFFFFF;
			} else if (i == 3) {
				if (cons.sht != 0) {
					consPutc(&cons, ' ', 0);
				}
				cons.cc = -1;
			} else if (256 <= i && i <= 511) {
				i -= 256;
				if (i == 8) {
					if (cons.cx > 16) {
						consPutc(&cons, ' ', 0);
						cons.cx -= 8;
					}
				} else if (i == 10) {
					cons.line[cons.cx / 8 - 2] = 0;
					consPutc(&cons, ' ', 0);
					consNline(&cons);
					consRuncmd(&cons, task->fat);
					consNline(&cons);
					consPutc(&cons, '>', 1);
					if (cons.sht == 0) {
						consExit(&cons, task->fat);
					}
				} else {
					if (cons.cx < 240) {
						cons.line[cons.cx / 8 - 2] = i;
						consPutc(&cons, (unsigned char) i, 1);
					}
				}
			}
			if (cons.sht != 0) {
				if (cons.cc >= 0) {
					graphicBox(sht, cons.cc, cons.cx, cons.cy, cons.cx + 7, cons.cy + 15);
				}
				shtRefresh(sht, cons.cx, cons.cy, cons.cx + 8, cons.cy + 16);
			}
		}
	}
}

int *api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	extern struct timers *tms;
	struct task *task = taskNow();
	struct console *cons = task->cons;
	struct sheet *sht;
	struct timer *timer;
	struct file *file;
	struct fhandle *fh;
	struct memory *mem;
	struct DLL_STRPICENV *env;
	struct RGB *pbuf, *q;
	struct pict *pict;
	struct clock *clock;
	struct mapi *mouse;
	struct meminfo *minfo;
	unsigned char *fbuf, *p, *s = 0;
	int *reg = &eax + 1, ds = task->ds, info[8], i = 0, j;
	if (eax == 0) {
		/* eax = 0 : AvP[VI */
		return &(task->tss.esp0);
	} else if (eax == 1) {
		/* eax = 1 : R\[ꕶ\
		  edx = R[h */
		consPutc(cons, edx & 0xff, 1);
	} else if (eax == 2) {
		/* eax = 2 : R\[\
		  ebx = ւ̃|C^
		  ecx = \JEgi-1ȂNULL܂Łj */
		consPuts(cons, (char *) (ds + ebx), ecx);
	} else if (eax == 3) {
		/* eax = 3 : EBhE쐬
		  ecx = ̃TCY
		  edx = c̃TCY
		  ebx = EBhEobt@
		  esi = EBhE
		  edi = F
		  ߂l:eax = EBhEnh */
		sht = shtAlloc();
		sht->task = task;
		sht->flag |= SHEET_APP;
		shtSet(sht, (unsigned char *) (ds + ebx), ecx, edx, edi);
		winAlloc(sht, (unsigned char *) (ds + esi), 0);
		shtApp(sht);
		winRefresh();
		reg[7] = (int) sht;
	} else if (eax == 4) {
		/* eax = 4 : EBhElp`\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̃TCY
		  edi = c̃TCY
		  ebp = Fԍ */
		sht = (struct sheet *) (ebx & 0xfffffffe);
		if (ecx < 0) { ecx = 0; }
		if (edx < 0) { edx = 0; }
		if (esi > sht->sx - 1) { esi = sht->sx - 1; }
		if (edi > sht->sy - 1) { edi = sht->sy - 1; }
		graphicBox(sht, ebp, ecx, edx, esi, edi);
		if ((ebx & 1) == 0) {
			shtRefresh(sht, ecx, edx, esi + 1, edi + 1);
		}
	} else if (eax == 5) {
 		/* eax = 5 : EBhE\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ւ̃|C^
		  ebp = Fԍ
		  edi = \JEgi-1ȂNULL܂Łj */
		sht = (struct sheet *) (ebx & 0xfffffffe);
		s = (char *) (ds + esi);
		if (ecx < 0) { ecx = 0; }
		if (edx < 0) { edx = 0; }
		if (ecx > sht->sx - 1) { ecx = sht->sx - 1; }
		if (edx > sht->sy - 1) { edx = sht->sy - 1; }
		if (edi == -1) {
			for (edi = 0; s[edi] != 0; edi++) { }
			graphicPuts(sht, ebp, ecx, edx, s);
		} else {
			graphicPutsl(sht, ebp, ecx, edx, s, edi);
		}
		if ((ebx & 1) == 0) {
			shtRefresh(sht, ecx, edx, ecx + edi * 16, edx + 16);
		}
		task->lbyte = 0;
	} else if (eax == 6) {
		/* eax = 6 : 擾
		  ebx = Ǘ\̂ւ̃|C^
		  ecx = TCY
		  edx = ǗTCY
		  ߂l:eax = AhX
		  ŏ̏ꍇAǗ\̂̏ */
		if (task->mem == 0) {	/* ŏ */
			memInit((struct memory *) (ds + ebx));
			task->mem = (struct memory *) (ds + ebx);
			memFree(task->mem, (int) (ebx + 32768), edx);
		}
		reg[7] = memAlloc(task->mem, ecx);
	} else if (eax == 7) {
		/* eax = 7 : J
		  ecx = TCY
		  edx = AhX */
		if (task->mem == 0) {
			return 0;
		}
		memFree(task->mem, edx, ecx);
	} else if (eax == 8) {
		/* eax = 8 : EBhE_\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = Fԍ */
		sht = (struct sheet *) (ebx & 0xfffffffe);
		if (ecx < 0) { ecx = 0; }
		if (edx < 0) { edx = 0; }
		if (ecx > sht->sx - 1) { ecx = sht->sx - 1; }
		if (edx > sht->sy - 1) { edx = sht->sy - 1; }
		sht->buf[edx * sht->sx + ecx] = esi;
		if ((ebx & 1) == 0) {
			shtRefresh(sht, ecx, edx, ecx + 1, edx + 1);
		}
	} else if (eax == 9) {
		/* eax = 9 : EBhEtbV
		  ebx = EBhEnh
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̏I[ʒu
		  edi = c̏I[ʒu */
		shtRefresh((struct sheet *) ebx, ecx, edx, esi + 1, edi + 1);
	} else if (eax == 10) {
		/* eax = 10 : EBhE\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̏I[ʒu
		  edi = c̏I[ʒu
		  ebp = Fԍ */
		sht = (struct sheet *) (ebx & 0xfffffffe);
		if (ecx < 0) { ecx = 0; }
		if (edx < 0) { edx = 0; }
		if (esi > sht->sx - 1) { esi = sht->sx - 1; }
		if (edi > sht->sy - 1) { edi = sht->sy - 1; }
		graphicLine(sht, ebp, ecx, edx, esi, edi);
		if ((ebx & 1) == 0) {
			if (ecx > esi) {
				i = ecx;
				ecx = esi;
				esi = i;
			}
			if (edx > edi) {
				i = edx;
				edx = edi;
				edi = i;
			}
			shtRefresh(sht, ecx, edx, esi + 1, edi + 1);
		}
	} else if (eax == 11) {
		/* eax = 11 : EBhE폜
		  ebx = EBhEnh */
		shtFree((struct sheet *) ebx);
		winRefresh();
	} else if (eax == 12) {
		/* eax = 12 : L[
		  ecx = 0ȂAL[͂ȂȂ0ԂA
		        1ȂAL[͂܂ŃX[v
		  ߂l:eax = L[R[hiASCIIj */
		for (;;) {
			cli();
			if (fifoStat(&task->fifo) == 0) {
				if (ecx != 0) {
					taskSleep(task);
					sti();
				} else {
					sti();
					reg[7] = -1;
					return 0;
				}
			} else {
				i = fifoGet(&task->fifo);
				sti();
				if (i == 1) {
					cli();
					consExitreq1(cons->sht);
					cons->sht = 0;
					sti();
				} else if (i == 2) {
					cons->cc = _FFFFFF;
				} else if (i == 3) {
					cons->cc = -1;
				} else if (i >= 256) {
					reg[7] = i - 256;
					return 0;
				}
			}
		}
	} else if (eax == 13) {
		/* eax = 13 : ^C}擾
		  ߂l:eax = ^C}nh */
		timer = timerAlloc();
		timer->fapp = 1;
		reg[7] = (int) timer;
	} else if (eax == 14) {
		/* eax = 14 : ^C}ݒ
		  ebx = ^C}nh
		  ecx = ԁi0.01bPʁj
		  edx = f[^ */
		timer = (struct timer *) ebx;
		timerInit(timer, &task->fifo);
		timerSet(timer, ecx, edx + 256);
	} else if (eax == 15) {
		/* eax = 15 : ^C}J
		  ebx = ^C}nh */
		timerFree((struct timer *) ebx);
	} else if (eax == 16) {
		/* eax = 16 : BEEPTEh
		  ecx = gimhzj */
		beep(ecx);
	} else if (eax == 17) {
		/* eax = 17 : t@CI[v
		  ebx = t@C
		  ߂l:eax = t@Cnh */
		for (i = 0; i < 8; i++) {
			if (task->fh[i].buf == 0) {
				break;
			}
		}
		reg[7] = 0;
		if (i < 8) {
			file = fileSearch((unsigned char *) (ds + ebx));
			if (file != 0) {
				reg[7] = i + 1;
				fh = &task->fh[i];
				fh->file = file;
				fh->size = file->size;
				fh->pos = 0;
				fh->mode = 0;
				bufSet(fh, 0);
			}
		}
	} else if (eax == 18) {
		/* eax = 18 : t@CN[Y
		  ebx = t@Cnh */
		mem = (struct memory *) MEMORY_ADDR;
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		bufFlush(fh);
		memFree(mem, (int) fh->buf, 512);
		fh->buf = 0;
	} else if (eax == 19) {
		/* eax = 19 : t@CTCY擾
		  ebx = t@Cnh
		@ecx = t@C擾[h
		        0:t@CTCYA1:ǂݍ݈ʒuA2:I[ǂݍ݈ʒu
		  ߂l:eax = t@CTCY */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		if (ecx == 0) {
			reg[7] = fh->size;
		} else if (ecx == 1) {
			reg[7] = fh->pos;
		} else if (ecx == 2) {
			reg[7] = fh->pos - fh->size;
		}
	} else if (eax == 20) {
		/* eax = 20 : t@CV[N
		  ebx = t@Cnh
		  ecx = V[NTCY
		  edx = V[N[h
		        0:ŏ 1:݂̈ʒuA2:I[ */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		if (edx == 0) {
			fh->pos = ecx;
		} else if (edx == 1) {
			fh->pos += ecx;
		} else if (edx == 2) {
			fh->pos = fh->size + ecx;
		}
		if (fh->pos < 0) {
			fh->pos = 0;
		}
		if (fh->pos > fh->size) {
			fh->pos = fh->size;
		}
		bufSet(fh, fh->pos);
	} else if (eax == 21) {
		/* eax = 21 : t@C[h
		  ebx = t@Cnh
		  ecx = oCgJEg
		  edx = obt@
		  ߂l:eax = ǂݍ񂾃oCgJEg */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		for (i = 0; i < ecx; i++) {
			if (fh->pos > fh->size) {
				break;
			}
			if (fh->pos - fh->baddr >= 512) {
				bufSet(fh, fh->pos);
			}
			*((unsigned char *) (ds + edx + i)) = fh->buf[fh->pos - fh->baddr];
			fh->pos++;
		}
		reg[7] = i;
	} else if (eax == 22) {
		/* eax = 22 : R}hC擾
		  ebx = obt@iƁAst@C΂ĕԂBj
		  ecx = oCgJEg
		  ߂l:eax = ǂݍ񂾃oCgJEg */
		if ((ebx & 0x01) != 0) {
			for (i = 0; cons->line[i] > ' '; i++) { }
			for (; cons->line[i] == ' '; i++) { }
		}
		ebx &= ~1;
		for (j = 0; ; j++) {
			*((unsigned char *) (ds + ebx + j)) = cons->line[i + j];
			if (cons->line[j] == 0) {
				break;
			}
			if (j >= ecx) {
				break;
			}
		}
		*((unsigned char *) (ds + ebx + j)) = 0;
		reg[7] = j + 1;
	} else if (eax == 23) {
		/* eax = 23 : 摜t@C擾
		  ebx = t@Cnh
		  edx = 摜\̂ւ̃|C^ */
		mem = (struct memory *) MEMORY_ADDR;
		env = (struct DLL_STRPICENV *) memAlloc(mem, sizeof(struct DLL_STRPICENV));
		pict = (struct pict *) (ds + edx);
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			pict->m = 0;
			goto end023_2;
		}
		fbuf = fileRead(task->fat, fh->file->cno, fh->size);
		if (info_BMP(env, info, fh->size, fbuf) == 0) {
			if (info_JPEG(env, info, fh->size, fbuf) == 0) {
				pict->m = 0;
				goto end023;
			}
		}
		pict->m = info[0];
		pict->sx = info[2];
		pict->sy = info[3];
end023:
		memFree(mem, (unsigned int) fbuf, fh->size);
end023_2:
		memFree(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	} else if (eax == 24) {
		/* eax = 24 : 摜\
		  ebx = EBhEnh
		  ecx = x0
		  edx = t@Cnh
		  esi = y0
		  edi = x1
		  ebp = y1 */
		mem = (struct memory *) MEMORY_ADDR;
		sht = (struct sheet *) ebx;
		env = (struct DLL_STRPICENV *) memAlloc(mem, sizeof(struct DLL_STRPICENV));
		pbuf = (struct RGB *) memAlloc(mem, 786432 * sizeof(struct RGB));
		if ((unsigned int) (edx - 1) < 8) {
			fh = task->fh + (edx - 1);
		} else {
			reg[7] = 0;
			goto end024_2;
		}
		fbuf = fileRead(task->fat, fh->file->cno, fh->size);
		if (info_BMP(env, info, fh->size, fbuf) == 0) {
			if (info_JPEG(env, info, fh->size, fbuf) == 0) {
				reg[7] = 0;
				goto end024;
			}
		}
		if (info[0] == 1) {
			i = decode0_BMP(env, fh->size, fbuf, 4, (char *) pbuf, 0);
		} else {
			i = decode0_JPEG(env, fh->size, fbuf, 4, (char *) pbuf, 0);
		}
		if (i != 0) {
			reg[7] = 0;
			goto end024;
		}
		for (i = esi; i < ebp; i++) {
			p = sht->buf + i * sht->sx;
			q = pbuf + (i - esi) * info[2];
			for (j = ecx; j < edi; j++) {
				p[j] = rgb2pal(j, i, q[j - ecx].r, q[j - ecx].g, q[j - ecx].b);
			}
		}
		shtRefresh(sht, ecx, esi, edi, ebp);
		reg[7] = 1;
end024:
		memFree(mem, (unsigned int) fbuf, fh->size);
end024_2:
		memFree(mem, (unsigned int) pbuf, 786432 * sizeof(struct RGB));
		memFree(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	} else if (eax == 25) {
		/* eax = 25 : v
		  ebx = v\̂ւ̃|C^ */
		clock = (struct clock *) (ds + ebx);
		clockGet(clock);
	} else if (eax == 26) {
		/* eax = 26 : }EX
		  ebx = }EX\̂ւ̃|C^
		  edx = EBhEnhiȂ烊A^Cł̈ʒuԂj */
		mouse = (struct mapi *) (ds + ebx);
		mouseGet(mouse);
		if (edx != 0) {
			sht = (struct sheet *) (edx & ~1);
			if ((edx & 0x01) == 0) {
				sht->flag |= SHEET_MOUSE;
				for (;;) {
					cli();
					if (fifoStat(&task->fifo) == 0) {
						taskSleep(task);
						sti();
					} else {
						i = fifoGet(&task->fifo);
						sti();
						if (i == 1) {
							cli();
							consExitreq1(cons->sht);
							cons->sht = 0;
							sti();
						} else if (i == 2) {
							cons->cc = _FFFFFF;
						} else if (i == 3) {
							cons->cc = -1;
						} else if (i == 4) {
							break;
						}
					}
				}
				sht->flag &= ~SHEET_MOUSE;
				mouseGet(mouse);
			}
			mouse->x -= sht->x;
			mouse->y -= sht->y;
		}
	} else if (eax == 27) {
		/* eax = 27 : t@C̍쐬
		  ebx = t@C
		  ߂l:eax = t@Cnh */
		mem = (struct memory *) MEMORY_ADDR;
		for (i = 0; i < 8; i++) {
			if (task->fh[i].buf == 0) {
				break;
			}
		}
		reg[7] = 0;
		if (i < 8) {
			file = fileCreate(task->fat, (unsigned char *) (ds + ebx));
			if (file != 0) {
				reg[7] = i + 1;
				fh = &task->fh[i];
				fh->file = file;
				fh->size = file->size;
				fh->pos = 0;
				fh->buf = (unsigned char *) memAlloc(mem, 512);
				fh->mode = 0;
				fh->bcaddr = file->cno;
				fh->baddr = 0;
			}
		}
	} else if (eax == 28) {
		/* eax = 28 : t@C̍폜
		  ebx = t@Cnh */
		mem = (struct memory *) MEMORY_ADDR;
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		fileDelete(task->fat, fh->file);
		memFree(mem, (int) fh->buf, 512);
		fh->buf = 0;
	} else if (eax == 29) {
		/* eax = 29 : t@C̉
		  ebx = t@Cnh
		  edx = t@C
		  ߂l:eax = G[R[hi1Ȃ琳A0ȂG[j */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			reg[7] = 0;
			return 0;
		}
		reg[7] = fileRename(fh->file, (unsigned char *) (ds + edx));
	} else if (eax == 30) {
		/* eax = 30 : t@C̏
		  ebx = t@Cnh
		  ecx = ރTCY
		  edx = obt@AhX
		  ߂l:eax = 񂾃TCY */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		for (i = 0; i < ecx; i++) {
			if (fh->pos >= fh->size) {
				fh->size = fh->pos + 1;
				fh->file->size = fh->pos + 1;
			}
			if (fh->pos - fh->baddr >= 512) {
				bufSet(fh, fh->pos);
			}
			fh->mode = 1;
			fh->buf[fh->pos - fh->baddr] = *((unsigned char *) (ds + edx + i));
			fh->pos++;
		}
		reg[7] = i;
	} else if (eax == 31) {
		/* eax = 31 : _CAO
		  edx =  */
		dialog((char *) (ds + edx));
	} else if (eax == 32) {
		/* eax = 32 : ̓_CAO
		  ecx = obt@̃TCY
		  edx = obt@̃AhX
		  ߂l:eax = ǂݍ񂾃TCY */
		reg[7] = inputDialog((char *) (ds + edx), ecx);
	} else if (eax == 33) {
		/* eax = 33 : t@C擾
		  ebx = t@Cnh
		  edx = v\̂ւ̃|C^ */
		if ((unsigned int) (ebx - 1) < 8) {
			fh = task->fh + (ebx - 1);
		} else {
			return 0;
		}
		clock = (struct clock *) (ds + edx);
		fileGetdate(fh->file, clock);
	} else if (eax == 34) {
		/* eax = 34 : Ԏ擾
		  ebx = \̂ւ̃|C^ */
		minfo = (struct meminfo *) (ds + ebx);
		mem = (struct memory *) MEMORY_ADDR;
		minfo->all = mem->allsize;
		minfo->free = memStat(mem);
	} else if (eax == 35) {
		/* eax = 35 : VXeJEg擾
		  ߂l:eax = VXeJEg */
		reg[7] = tms->count;
	}
	return 0;
}
