#include "main.h"
#include <stdio.h>
struct fifo *fdcfifo;

void fdcCmdinit(char data)
{
	for (;;) {
		if ((in8(0x03f4) & data) == 0) {
			return;
		}
	}
}

void fdcCmd(char data)
{
	for (;;) {
		if ((in8(0x03f4) & 0xc0) == 0x80) {
			out8(0x03f5, data);
			return;
		}
	}
}

char fdcRstat(void)
{
	char data;
	for (;;) {
		if ((in8(0x03f4) & 0xc0) == 0xc0) {
			data = in8(0x03f5);
			return data;
		}
	}
}

int fdcCmd08(void)
{
	char st0;
	fdcCmdinit(0x10);
	fdcCmd(0x08);
	st0 = fdcRstat();
	fdcRstat();
	if ((st0 & 0xc0) == 0x00) {
		return 0;
	}
	return 1;
}

void fdcSeek(int sect)
{
	fdcCmdinit(0x11);
	fdcCmd(0x0f);
	fdcCmd((sect % 36 / 18) << 2);
	fdcCmd(sect / 36);
	return;
}

void dmaSet(unsigned char mode, int n)
{
	if (mode == 1) {
		out8(0x000b, 0x06);
	} else {
		out8(0x000b, 0x0a);
	}
	out8(0x0005, 0xff);
	out8(0x0005, n * 2 - 1);
	out8(0x0004, FDCBUF_ADDR);
	out8(0x0004, FDCBUF_ADDR >> 8);
	out8(0x0081, FDCBUF_ADDR >> 16);
	out8(0x000a, 0x02);
	return;
}

void fdcRW(unsigned char mode, int sect)
{
	fdcCmdinit(0x11);
	if (mode == 1) {
		fdcCmd(0xe6);
	} else {
		fdcCmd(0xc5);
	}
	fdcCmd((sect % 36 / 18) << 2);
	fdcCmd(sect / 36);
	fdcCmd(sect % 36 / 18);
	fdcCmd(sect % 36 % 18 + 1);
	fdcCmd(0x02);
	if (mode == 1) {
		fdcCmd(0x12);
		fdcCmd(0x01);
	} else {
		fdcCmd(0x7f);
		fdcCmd(0x12);
	}
	fdcCmd(0xff);
	return;
}

int fdcRWstat(void)
{
	char st0;
	st0 = fdcRstat();
	fdcRstat();
	fdcRstat();
	fdcRstat();
	fdcRstat();
	fdcRstat();
	fdcRstat();
	if ((st0 & 0xc0) == 0x00) {
		return 0;
	}
	return 1;
}

void fdcTask(void)
{
	struct task *task = taskNow();
	struct fifo *freq = 0;
	struct timer *timer;
	int fdata = 0, sect = 0, n = 0, i;
	unsigned char motor = 0, ph = 0, mode = 0, err = 0, *buf;
	out8(0x03f2, 0x0c);
	out8(0x00d6, 0xc0);
	out8(0x00c0, 0x00);
	out8(0x000a, 0x06);
	timer = timerAlloc();
	timerInit(timer, fdcfifo);

	for (;;) {
		cli();
		if (fifoStat(fdcfifo) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(fdcfifo);
			sti();
			if (i == 1) {
				if (ph == 0) {
					if (fdcCmd08() == 0) {
						fdcRW(mode, sect);
						ph = 1;
					} else {
						fdcSeek(sect);
					}
				} else {
					if (fdcRWstat() == 0) {
						if (mode == 1) {
							buf = (unsigned char *) FDCBUF_ADDR;
							for (i = 0; i < 512 * n; i++) {
								*((unsigned char *) DISK_ADDR + sect * 512 + i) = buf[i];
							}
						}
						out8(0x000a, 0x06);
						fifoPut(freq, fdata);
						mode = 0;
						timerSet(timer, 300, 2);
					} else {
						out8(0x000a, 0x06);
						err++;
						if (err <= 5) {
							dmaSet(mode, n);
							fdcSeek(sect);
							ph = 0;
						} else {
							fifoPut(freq, fdata + 1);
							mode = 0;
							timerSet(timer, 300, 2);
						}
					}
				}
			} else if (i == 2) {
				if (motor == 0) {
					motor = 1;
					dmaSet(mode, n);
					fdcSeek(sect);
				} else {
					motor = 0;
					out8(0x03f2, 0x0c);
				}
			} else if (((i >> 24) & 0xff) != 0) {
				if (mode == 0) {
					timerCancel(timer);
					ph = 0;
					err = 1;
					mode = (i >> 24) & 0xff;
					n = (i >> 16) & 0xff;
					sect = i & 0xffff;
					freq = (struct fifo *) fifoGet(fdcfifo);
					fdata = fifoGet(fdcfifo);
					if (mode != 1) {
						buf = (unsigned char *) FDCBUF_ADDR;
						for (i = 0; i < 512 * n; i++) {
							buf[i] = *((unsigned char *) DISK_ADDR + sect * 512 + i);
						}
					}
					if (motor == 0) {
						timerSet(timer, 300, 2);
						out8(0x03f2, 0x1c);
					} else {
						dmaSet(mode, n);
						fdcSeek(sect);
					}
				} else {
					cli();
					fifoPut(fdcfifo, i);
					i = fifoGet(fdcfifo);
					fifoPut(fdcfifo, i);
					i = fifoGet(fdcfifo);
					fifoPut(fdcfifo, i);
					sti();
				}
			}
		}
	}
}

void fdcInit(int *fat)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct task *task = taskAlloc("FDC driver");
	int *fbuf = (int *) memAlloc(mem, 128 * 4);
	task->stack = memAlloc(mem, 64 * 1024);
	task->tss.esp = task->stack + 64 * 1024;
	task->tss.eip = (int) &fdcTask;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	fifoInit(&task->fifo, fbuf, 128, task);
	task->fat = fat;
	fdcfifo = &task->fifo;
	taskRun(task, 2, 2);
	return;
}

void fdcReq(unsigned char mode, int sect, int n)
{
	struct task *task = taskNow();
	struct fifo freq;
	int fbuf[32], i;
	fifoInit(&freq, fbuf, 32, task);
restart:
	cli();
	fifoPut(fdcfifo, (unsigned short) sect | ((unsigned char) n << 16) | ((unsigned char) mode << 24));
	fifoPut(fdcfifo, (int) &freq);
	fifoPut(fdcfifo, 1);
	sti();
	for (;;) {
		cli();
		if (fifoStat(&freq) == 0) {
			taskSleep(task);
			sti();
		} else {
			i = fifoGet(&freq);
			sti();
			if (i == 1) {
				return;
			} else if (i == 2) {
				goto restart;
			}
		}
	}
}

void int26(int *esp)
{
	in8(0x03f4);
	out8(0x0020, 0x66);
	fifoPut(fdcfifo, 1);
	return;
}
