// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ModelChangeEvent.java
//	DATE:		2003.5.9
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

/**
 *	model̕ύXێCxg
 */
public class ModelChangeEvent {
	/** IԂɑ΂Cxg^Cv */
	public static final int SELECT_MODE = 0;
	
	/** Ԃɑ΂Cxg^Cv */
	public static final int DETERMINE_MODE = 1;
	
	/** ύX萔 */
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	
	/** IꂽXWiBoardWnj */
	private int mX;
	
	/** IꂽYWiBoardWnj */
	private int mY;
	
	/** Iꂽ */
	private Direction mDirection;
	
	/** Cxg^Cv */
	private int mMode;
	
	/** Jڕinext or previous) */
	private boolean mTransitToNext = true;
	

	/**
	 *	t@Ng[\bh
	 *	IԂɊւCxg쐬B
	 *
	 *	@param	inX ύXՖʂXWiBoardWnj
	 *	@param	inY ύXՖʂYWiBoardWnj
	 *	@param	inDirection w肳ꂽ
	 */	
	public static ModelChangeEvent createSelectionEvent(
								final int inX, final int inY, 
								Direction inDirection) 
	{
		return new ModelChangeEvent(inX, inY, inDirection, SELECT_MODE);
	}
	
	/**
	 *	t@Ng[\bh
	 *	mԂɊւCxg쐬B
	 *
	 *	@param	inX ύXՖʂXWiBoardWnj
	 *	@param	inY ύXՖʂYWiBoardWnj
	 *	@param	inDirection w肳ꂽ
	 */	
	public static ModelChangeEvent createDeterminationEvent(
									final int inX, final int inY, 
									Direction inDirection) 
	{
		return new ModelChangeEvent(inX, inY, inDirection, DETERMINE_MODE);
	}
	
	/**
	 *	@return	ύXՖʂ̈ʒuԂ
	 */
	public java.awt.Point getPos() {
		return new java.awt.Point(mX, mY);
	}
	
	/**
	 *	@return	ύXw肳ꂽԂ
	 */
	public Direction getDirection() {
		return mDirection;
	}
	
	/**
	 *	@return	̃Cxg̃[hԂ
	 */
	public int getMode() {
		return mMode;
	}
	
	/**
	 *	JڕύXB
	 */
	public void changeTransit(boolean inToNext) {
		mTransitToNext = inToNext;
	}
	
	/**
	 *	JڕłtrueԂB
	 */
	public boolean isTransitNext() {
		return mTransitToNext;
	}

	/**
	 *	RXgN^
	 *
	 *	@param	inX ύXՖʂXWiBoardWnj
	 *	@param	inY ύXՖʂYWiBoardWnj
	 *	@param	inDirection w肳ꂽ
	 */	
	private ModelChangeEvent(final int inX, final int inY, Direction inDirection, final int inMode) {
		mX = inX;
		mY = inY;
		mDirection = inDirection;
		mMode = inMode;
	}
}