// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuItemBean.java
//	DATE:		2003.8.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

class MenuItemBean extends AbstractMenuItemBean {
	public java.awt.MenuItem createMenuItem(MenuManager inManager) {
		String aName = getName();
		String aI18NName = PropertyBundle.getInstance().getString(aName);
		if (aI18NName.length() == 0) aI18NName = aName;
			
		java.awt.MenuItem aItem = new java.awt.MenuItem(aI18NName);
		aItem.setActionCommand(aName);
		
		if (0 != getShortcut().length()) {
			int akey = getShortcut().charAt(0);
			boolean aModifierShift = false;
			
			if (MODIFIER_SHIFT.equals(getShortCutModifier())) {
				aModifierShift = true;
			}
			
			java.awt.MenuShortcut aShortcut = new java.awt.MenuShortcut(akey, aModifierShift);
			aItem.setShortcut(aShortcut);
		}
		
		aItem.addActionListener(inManager.getActionDispatcher());
		
		inManager.installMenuItem(aName, aItem);
		inManager.installDelegateAction(aName, getClassName());
		
		return aItem;
	}
}
	
