/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassCache {
    protected static ClassCache s_instance;
    protected String[] m_paths;
    protected File[] m_roots;
    protected HashMap m_classMap;

    private ClassCache(String[] paths) {
        ArrayList<String> keepers = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            int mark = path.lastIndexOf(46);
            if (mark < 0 || !"jar".equalsIgnoreCase(path.substring(mark + 1))) {
                keepers.add(paths[i]);
            }
            ++i;
        }
        this.m_paths = new String[keepers.size()];
        this.m_roots = new File[keepers.size()];
        int i2 = 0;
        while (i2 < keepers.size()) {
            String path = (String)keepers.get(i2);
            int length = path.length();
            if (length > 0 && path.charAt(length - 1) != File.separatorChar) {
                path = path + File.separator;
            }
            this.m_paths[i2] = path;
            this.m_roots[i2] = new File(path);
            ++i2;
        }
        this.m_classMap = new HashMap();
    }

    private ClassFile getClassFileImpl(String name) throws JiBXException {
        Object match = this.m_classMap.get(name);
        if (match != null) {
            return (ClassFile)match;
        }
        try {
            ClassFile cf = null;
            String path = name.replace('.', File.separatorChar) + ".class";
            int i = 0;
            while (i < this.m_paths.length) {
                File file = new File(this.m_paths[i], path);
                if (file.exists()) {
                    cf = new ClassFile(name, this.m_roots[i], file);
                    break;
                }
                ++i;
            }
            if (cf == null) {
                cf = new ClassFile(name);
            }
            if (cf != null) {
                String sname = cf.getSuperName();
                if (!name.equals(sname)) {
                    ClassFile sf = this.getClassFileImpl(sname);
                    if (sf == null) {
                        throw new JiBXException("Superclass " + sname + " of class " + name + " not found");
                    }
                    cf.setSuperFile(sf);
                }
                this.m_classMap.put(name, cf);
            }
            return cf;
        }
        catch (IOException ex) {
            throw new JiBXException("Error loading class " + name);
        }
    }

    public static ClassFile getClassFile(String name) throws JiBXException {
        return s_instance.getClassFileImpl(name);
    }

    public static void setPaths(String[] paths) {
        s_instance = new ClassCache(paths);
    }
}

