/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.runtime.JiBXException;

public class NameDefinition {
    private final String m_name;
    private String m_namespace;
    private final boolean m_isAttribute;
    private int m_namespaceIndex;

    public NameDefinition(String name, String ns, boolean attr) {
        this.m_name = name;
        this.m_namespace = ns;
        this.m_isAttribute = attr;
    }

    public boolean isNullUri() {
        return this.m_namespace == null;
    }

    public void genPushUri(MethodBuilder mb) throws JiBXException {
        if (this.m_namespace == null) {
            mb.append(InstructionConstants.ACONST_NULL);
        } else {
            mb.appendLoadConstant(this.m_namespace);
        }
    }

    public void genPushName(MethodBuilder mb) throws JiBXException {
        mb.appendLoadConstant(this.m_name);
    }

    public void genPushUriPair(MethodBuilder mb) throws JiBXException {
        this.genPushUri(mb);
        this.genPushName(mb);
    }

    public void genPushIndexPair(MethodBuilder mb) throws JiBXException {
        mb.appendLoadConstant(this.m_namespaceIndex);
        this.genPushName(mb);
    }

    public void fixNamespace(DefinitionContext defc) throws JiBXException {
        if (this.m_namespace == null) {
            this.m_namespace = defc.getDefaultURI(this.m_isAttribute);
            this.m_namespaceIndex = defc.getDefaultIndex(this.m_isAttribute);
        } else {
            try {
                this.m_namespaceIndex = defc.getNamespaceIndex(this.m_namespace, this.m_isAttribute);
            }
            catch (JiBXException ex) {
                throw new JiBXException("Undefined or unusable namespace \"" + this.m_namespace + '\"');
            }
        }
    }

    public String toString() {
        if (this.m_namespace == null) {
            return this.m_name;
        }
        return "{" + this.m_namespace + "}:" + this.m_name;
    }
}

