/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.runtime.JiBXException;

public abstract class NestedBase
extends BindingBuilder.ContainerBase
implements IComponent,
IContainer {
    private final IContextObj m_contextObject;
    private final boolean m_hasContext;
    protected final boolean m_isOrdered;
    private final DefinitionContext m_defContext;
    protected ArrayList m_attributes;
    protected ArrayList m_contents;

    public NestedBase(IContainer contain, IContextObj objc, boolean ord, boolean defc) {
        super(contain);
        this.m_nameStyle = -1;
        this.m_accessLevel = -1;
        this.m_autoLink = -1;
        this.m_styleDefault = -1;
        this.m_contextObject = objc;
        this.m_contents = new ArrayList();
        this.m_isOrdered = ord;
        this.m_hasContext = defc;
        this.m_defContext = defc ? new DefinitionContext(contain) : contain.getDefinitionContext();
    }

    public ArrayList getAttributes() {
        return this.m_attributes;
    }

    public ArrayList getContents() {
        return this.m_contents;
    }

    public void addComponent(IComponent comp) {
        this.m_contents.add(comp);
    }

    public boolean isContentOrdered() {
        return this.m_isOrdered;
    }

    public boolean hasNamespaces() {
        return this.m_hasContext && this.m_defContext.hasNamespace();
    }

    public BindingDefinition getBindingRoot() {
        return this.m_container.getBindingRoot();
    }

    public DefinitionContext getDefinitionContext() {
        return this.m_defContext;
    }

    public boolean isOptional() {
        int i;
        if (this.m_attributes != null) {
            i = 0;
            while (i < this.m_attributes.size()) {
                if (!((IComponent)this.m_attributes.get(i)).isOptional()) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.m_contents.size()) {
            if (!((IComponent)this.m_contents.get(i)).isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (!this.m_isOrdered) {
            throw new IllegalStateException("Internal error - content not ordered");
        }
        if (this.m_contents.size() > 0) {
            int count = this.m_contents.size();
            if (count == 1) {
                ((IComponent)this.m_contents.get(0)).genContentPresentTest(mb);
            } else {
                BranchHandle[] tofound = new BranchHandle[count];
                int i = 0;
                while (i < count) {
                    IComponent comp = (IComponent)this.m_contents.get(i);
                    comp.genContentPresentTest(mb);
                    tofound[i] = mb.append((BranchInstruction)new IFNE(null));
                    ++i;
                }
                mb.append(InstructionConstants.ICONST_0);
                BranchHandle toend = mb.append((BranchInstruction)new GOTO(null));
                int i2 = 0;
                while (i2 < count) {
                    mb.targetNext(tofound[i2]);
                    ++i2;
                }
                mb.append(InstructionConstants.ICONST_1);
                mb.targetNext(toend);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public void genNewInstance(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no instance creation");
    }

    public String getType() {
        return this.m_contextObject.getBoundClass().getClassName();
    }
}

