/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.AbstractSolverState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverFinishedState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverIllegalState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverProcessingState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStartState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverStateModel
extends AbstractDecoratedModel {
    private static final AbstractSolverState START_STATE = new SolverStartState();
    private static final AbstractSolverState PROCESSING_STATE = new SolverProcessingState();
    private static final AbstractSolverState FINISHED_STATE = new SolverFinishedState();
    private static final AbstractSolverState ILLEGAL_STATE = new SolverIllegalState();
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Entry[] mSolverEntries = new Entry[0];
    private Set mLastModified = new HashSet();
    private boolean mIsAcceptModel;

    public SolverStateModel(boolean bl, Model model) {
        this.addModel(model);
        this.mIsAcceptModel = bl;
    }

    public SolverStateModel(boolean bl) {
        this(bl, NullModel.getInstance());
    }

    public SolverStateModel(Model model) {
        this(true, model);
    }

    protected void createBoardSelf(int n, int n2) {
        this.mSolverEntries = new Entry[n * n2];
    }

    public int setProblem(ProblemInfo problemInfo) {
        if (this.getWidth() != problemInfo.getWidth() || this.getHeight() != problemInfo.getHeight()) {
            this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        }
        if (problemInfo.isMoreRead()) {
            int n = 0;
            if (problemInfo.isDivideRead()) {
                n = problemInfo.getOffset();
            }
            for (int i = n; i < n + problemInfo.getReadOnce(); ++i) {
                try {
                    int n2 = Integer.parseInt((String)problemInfo.getRecordAt(i));
                    this.mSolverEntries[i] = new Entry(n2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.getDecorated().setProblem(problemInfo);
    }

    public void reset() {
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                this.resetAtSelf(j, i);
            }
        }
        this.getDecorated().reset();
    }

    protected void resetAtSelf(int n, int n2) {
        if (this.isNumberAt(n, n2)) {
            try {
                this.getEntryAt(n, n2).reset();
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("illegal reset at " + new Point(n, n2));
            }
        }
    }

    protected boolean acceptableModelState(ModelState modelState) {
        return ModelStateUtility.isAcceptSolverModelState(modelState);
    }

    protected void setModelStateSelf(ModelState modelState) {
        this.mIsAcceptModel = ModelStateUtility.isAcceptSolverModelState(modelState);
    }

    public State getCurStateAt(int n, int n2) {
        State state = this.getDecorated().getCurStateAt(n, n2);
        if (this.mIsAcceptModel && this.mLastModified.contains(new Point(n, n2)) && state instanceof HashikakeNumberState) {
            HashikakeNumberState hashikakeNumberState = (HashikakeNumberState)state;
            AbstractSolverState abstractSolverState = this.getEntryAt(n, n2).getState();
            hashikakeNumberState.setColorState(abstractSolverState);
        }
        return state;
    }

    protected boolean isAcceptableEvent(StateEventCode stateEventCode) {
        return UtilityFuncs.isDeterminationType(stateEventCode) || stateEventCode instanceof HashikakeStateEventCode;
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (stateEventCode == UtilityFuncs.createSpaceCode()) {
            this.mSolverEntries[this.toIndex((int)n, (int)n2)] = null;
        } else if (stateEventCode instanceof HashikakeStateEventCode) {
            int n3 = Integer.parseInt(stateEventCode.getValue());
            Entry entry = null;
            entry = this.getEntryAt(n, n2);
            if (null != entry && n3 == entry.getMaxNum()) {
                entry.reset();
            } else {
                this.mSolverEntries[this.toIndex((int)n, (int)n2)] = new Entry(n3);
            }
        } else {
            if (this.isNumberAt(n, n2)) {
                try {
                    this.getEntryAt(n, n2).nextState();
                }
                catch (IllegalStateException illegalStateException) {
                    System.out.println(illegalStateException);
                    throw illegalStateException;
                }
            }
            this.mLastModified.add(new Point(n, n2));
        }
    }

    private Entry getEntryAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            throw new IllegalArgumentException("Specified position is out of the board.");
        }
        return this.mSolverEntries[this.toIndex(n, n2)];
    }

    private int toIndex(int n, int n2) {
        return n2 * this.getWidth() + n;
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
    }

    protected Point[] lastModifiedSelf() {
        if (this.isModifiedSelf()) {
            return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
        }
        return NO_MODIFIED;
    }

    protected boolean isModifiedSelf() {
        return !this.mLastModified.isEmpty();
    }

    protected void flushSelf() {
        if (!this.mLastModified.isEmpty()) {
            this.mLastModified.clear();
        }
    }

    private static class Entry {
        private final int mMaxNum;
        private int mResidue;
        private AbstractSolverState mState;

        Entry(int n) {
            this.mMaxNum = n;
            this.reset();
        }

        void reset() {
            this.mResidue = this.mMaxNum;
            this.mState = START_STATE;
        }

        void nextState() {
            --this.mResidue;
            if (0 > this.mResidue) {
                this.mState = ILLEGAL_STATE;
            }
            this.mState = 0 < this.mResidue ? PROCESSING_STATE : FINISHED_STATE;
        }

        int getMaxNum() {
            return this.mMaxNum;
        }

        AbstractSolverState getState() {
            return this.mState;
        }
    }
}

