/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.view.AlreadyMonitoredException;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.Monitor;
import jp.gr.java_conf.ktz.puzzle.framework.view.Mutex;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.SolverRendererFactory;

public final class Board
extends Canvas
implements BoardView {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private Model mModel = NullModel.getInstance();
    private SolverHandler mHandler;
    private DefaultRenderer mRenderer;
    private BoardView mParent;
    private Mutex mMutex = new Mutex();
    private Monitor mMonitor;
    private boolean mIsModified;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand;

    public void initialize() {
        System.out.println("init");
        this.mRenderer = SolverRendererFactory.create(9, 9);
        this.setBackground(AppColors.BACK_COLOR);
        this.createBoard(9, 9);
        PieceSizeCommand pieceSizeCommand = new PieceSizeCommand((CommandContainer)this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand((Command)pieceSizeCommand);
    }

    public void addModel(AbstractDecoratedModel abstractDecoratedModel) {
        abstractDecoratedModel.addModel(this.mModel);
        this.mModel = abstractDecoratedModel;
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.mRenderer = defaultRenderer;
    }

    public void processCommand(Command command) {
        if (!command.isConsumed()) {
            this.processCommandImpl(command);
        }
        if (!command.isConsumed() && command instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(command);
        }
    }

    protected void processCommandImpl(Command command) {
        Class<?> clazz = command.getClass();
        if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand)) {
            int n = ((BoardSizeCommand)command).getComponentWidth();
            int n2 = ((BoardSizeCommand)command).getComponentHeight();
            this.setComponentSize(n, n2);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand)) {
            ProblemInfo problemInfo = ((LoadCommand)command).getProblem();
            this.load(problemInfo);
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand)) {
            this.nextSolute();
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand)) {
            this.nextSoluteAll();
            command.consume();
        }
    }

    public void setParent(BoardView boardView) {
        this.mParent = boardView;
    }

    private void load(ProblemInfo problemInfo) {
        if (null == problemInfo) {
            throw new IllegalArgumentException("null object is passed to inInfo");
        }
        if (this.isMonitored()) {
            return;
        }
        try {
            class LoadRunner
            implements Runnable {
                private final int ONCE_READ_COUNT = 100;
                private final /* synthetic */ ProblemInfo val$inInfo;

                LoadRunner(ProblemInfo problemInfo) {
                    this.val$inInfo = problemInfo;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void run() {
                    long l = System.currentTimeMillis();
                    System.out.println("set problem");
                    if (Board.this.mModel instanceof NullModel) {
                        Board.this.mModel = (Model)new SolverStateModel((Model)new BoardModel(Board.this.mModel));
                        Board.this.mHandler = new HashikakeSolverHandler(Board.this.mModel);
                    }
                    Board.this.createBoard(this.val$inInfo.getWidth(), this.val$inInfo.getHeight());
                    try {
                        int n;
                        int n2 = 0;
                        do {
                            ProblemInfo problemInfo = new ProblemInfo(n2, 100, this.val$inInfo);
                            Mutex mutex = Board.this.mMutex;
                            synchronized (mutex) {
                                n = Board.this.mModel.setProblem(problemInfo);
                            }
                            n2 += n;
                            Board.this.repaint();
                            while (Board.this.mModel.isModified()) {
                                Board.this.mMonitor.suspend();
                            }
                        } while (Integer.MIN_VALUE != n);
                        Object var9_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        Mutex mutex = Board.this.mMutex;
                        synchronized (mutex) {
                            Board.this.setModified(false);
                            Board.this.mHandler.reset();
                        }
                        long l2 = System.currentTimeMillis();
                        System.out.println("ellapsed tile for load : " + (l2 - l) + " msec\n");
                        throw throwable;
                    }
                    Mutex mutex = Board.this.mMutex;
                    synchronized (mutex) {
                        Board.this.setModified(false);
                        Board.this.mHandler.reset();
                    }
                    long l3 = System.currentTimeMillis();
                    System.out.println("ellapsed tile for load : " + (l3 - l) + " msec\n");
                }
            }
            this.invokeInternalAction(new LoadRunner(problemInfo), "Load Thread");
        }
        catch (AlreadyMonitoredException alreadyMonitoredException) {
            System.out.println((Object)alreadyMonitoredException);
            return;
        }
    }

    private void createBoard(int n, int n2) {
        this.mRenderer.setSize(n, n2);
        this.mModel.createBoard(n, n2);
        Dimension dimension = this.mRenderer.getBoardSize();
        BoardSizeCommand boardSizeCommand = new BoardSizeCommand((CommandContainer)this, dimension.width, dimension.height);
        AWTDispatchCommandQueue.postCommand((Command)boardSizeCommand);
    }

    public void save(File file) {
        throw new UnsupportedOperationException("This view isnot supported save method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            return this.mIsModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setModified(boolean bl) {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            this.mIsModified = bl;
        }
    }

    public Component getComponent() {
        return this;
    }

    void invokeInternalAction(Runnable runnable, String string) throws AlreadyMonitoredException {
        if (this.isMonitored()) {
            throw new AlreadyMonitoredException(string);
        }
        this.mMutex.lock();
        this.mMonitor = new Monitor(this.mMutex);
        new Thread((Runnable)new ActionProxy(runnable), string).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMonitored() {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            return null != this.mMonitor;
        }
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().width;
    }

    private void setComponentSize(int n, int n2) {
        this.setSize(n, n2);
    }

    private void nextSolute() {
        if (this.isMonitored()) {
            return;
        }
        this.mHandler.nextSolute();
        if (this.mModel.isModified()) {
            this.repaint();
            this.setModified(true);
        }
    }

    private void nextSoluteAll() {
        if (this.isMonitored()) {
            return;
        }
        try {
            class SolveRunner
            implements Runnable {
                SolveRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    boolean bl;
                    long l = System.currentTimeMillis();
                    try {
                        try {}
                        catch (SolveDiscompleteException solveDiscompleteException) {
                            System.out.println(solveDiscompleteException);
                            Object var7_6 = null;
                            Board.this.setModified(true);
                            long l3 = System.currentTimeMillis();
                            System.out.println("(" + (l3 - l) + " msec elapsed)\n");
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        Board.this.setModified(true);
                        long l4 = System.currentTimeMillis();
                        System.out.println("(" + (l4 - l) + " msec elapsed)\n");
                        throw throwable;
                    }
                    do {
                        bl = false;
                        Mutex mutex = Board.this.mMutex;
                        // MONITORENTER : mutex
                        bl = Board.this.mHandler.nextSoluteAll();
                        // MONITOREXIT : mutex
                        if (Board.this.mModel.isModified()) {
                            Board.this.repaint();
                        }
                        while (Board.this.mModel.isModified()) {
                            Board.this.mMonitor.suspend();
                        }
                    } while (!bl);
                    Object var7_5 = null;
                    Board.this.setModified(true);
                    long l2 = System.currentTimeMillis();
                    System.out.println("(" + (l2 - l) + " msec elapsed)\n");
                }
            }
            this.invokeInternalAction(new SolveRunner(), "Solver Thread");
        }
        catch (AlreadyMonitoredException alreadyMonitoredException) {
            System.out.println((Object)alreadyMonitoredException);
            return;
        }
    }

    public void setFocus(boolean bl) {
        this.mParent.setFocus(bl);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void clear() {
        if (this.isMonitored()) {
            return;
        }
        if (!this.mIsModified) {
            return;
        }
        try {
            class ClearRunner
            implements Runnable {
                private final int LOOP_LIMIT = 100;

                ClearRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n = 100;
                    try {
                        for (int i = 0; i < Board.this.mModel.getHeight(); ++i) {
                            for (int j = 0; j < Board.this.mModel.getWidth(); ++j) {
                                --n;
                                Mutex mutex = Board.this.mMutex;
                                synchronized (mutex) {
                                    Board.this.mModel.resetAt(j, i);
                                }
                                if (0 != n) continue;
                                Board.this.repaint();
                                n = 100;
                                while (Board.this.mModel.isModified()) {
                                    Board.this.mMonitor.suspend();
                                }
                            }
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (Board.this.mModel.isModified()) {
                            Board.this.repaint();
                        }
                        while (Board.this.mModel.isModified()) {
                            Board.this.mMonitor.suspend();
                        }
                        Mutex mutex = Board.this.mMutex;
                        synchronized (mutex) {
                            Board.this.setModified(false);
                            Board.this.mHandler.reset();
                        }
                        throw throwable;
                    }
                    if (Board.this.mModel.isModified()) {
                        Board.this.repaint();
                    }
                    while (Board.this.mModel.isModified()) {
                        Board.this.mMonitor.suspend();
                    }
                    Mutex mutex = Board.this.mMutex;
                    synchronized (mutex) {
                        Board.this.setModified(false);
                        Board.this.mHandler.reset();
                    }
                }
            }
            this.invokeInternalAction(new ClearRunner(), "Clear Thread");
        }
        catch (AlreadyMonitoredException alreadyMonitoredException) {
            System.out.println((Object)alreadyMonitoredException);
            return;
        }
    }

    private Point calcPortToBoardPos(int n, int n2) {
        return this.mRenderer.calcPortToBoardPos(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            if (this.mModel.isModified()) {
                rectangle = new Rectangle();
                Point[] pointArray = this.mModel.lastModified();
                for (int i = 0; i < pointArray.length; ++i) {
                    this.mRenderer.render(pointArray[i].x, pointArray[i].y, this.mModel.getCurStateAt(pointArray[i].x, pointArray[i].y));
                }
                rectangle = this.getClipBounds();
            }
            graphics.drawImage(this.mRenderer.getImage(), 0, 0, this);
            this.mModel.flush();
        }
        if (this.isMonitored()) {
            this.mMonitor.resume();
        }
    }

    private Rectangle getClipBounds() {
        return this.mRenderer.getClipBounds(this.mModel.lastModified());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ActionProxy
    implements Runnable {
        private Runnable mAction;

        ActionProxy(Runnable runnable) {
            this.mAction = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.mAction.run();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Mutex mutex = Board.this.mMutex;
                synchronized (mutex) {
                    Board.this.mMutex.unlock();
                    Board.this.mMonitor = null;
                }
                System.gc();
                throw throwable;
            }
            Mutex mutex = Board.this.mMutex;
            synchronized (mutex) {
                Board.this.mMutex.unlock();
                Board.this.mMonitor = null;
            }
            System.gc();
        }
    }
}

