/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class CreatorBoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final ModelState DEFAULT_MODEL_STATE = new ModelState(){};
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mLastModified = new HashSet();
    private ModelState mModelState;

    protected void createBoardSelf(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mCells = new Cell[n * n2];
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                this.mCells[this.toIndex((int)j, (int)i)] = new Cell();
                this.mLastModified.add(new Point(j, i));
            }
        }
    }

    private int toIndex(int n, int n2) {
        return n2 * this.mWidth + n;
    }

    public int setProblem(ProblemInfo problemInfo) {
        if (this.mWidth != problemInfo.getWidth() || this.mHeight != problemInfo.getHeight()) {
            this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        }
        StateManager stateManager = StateManager.getInstance();
        int n = 0;
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                StateEventCode stateEventCode = null;
                try {
                    int n2 = Integer.parseInt((String)problemInfo.getRecordAt(n++));
                    stateEventCode = UtilityFuncs.createNumberCodeOf(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    stateEventCode = UtilityFuncs.createSpaceCode();
                }
                Cell cell = this.getCellAt(j, i);
                State state = stateManager.getNextState(cell.getCurState(), stateEventCode);
                cell.setCurState(state);
                this.mLastModified.add(new Point(j, i));
            }
        }
        return this.mCells.length;
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        if (!this.acceptableModelState(this.mModelState)) {
            return;
        }
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                if (ModelStateUtility.isClearAllState(this.mModelState)) {
                    this.resetAtSelf(j, i);
                    continue;
                }
                this.resetSolvedStateAt(j, i);
            }
        }
    }

    protected void resetAtSelf(int n, int n2) {
        if (!this.isSpaceAt(n, n2)) {
            this.getCellAt(n, n2).reset();
            this.mLastModified.add(new Point(n, n2));
        }
    }

    protected boolean acceptableModelState(ModelState modelState) {
        return ModelStateUtility.isClearAllState(modelState) || ModelStateUtility.isAcceptSolverModelState(modelState);
    }

    private void resetSolvedStateAt(int n, int n2) {
        if (this.isNumberAt(n, n2)) {
            Cell cell = this.getCellAt(n, n2);
            State state = cell.getCurState();
            StateManager stateManager = StateManager.getInstance();
            String string = stateManager.findIdentityOf(state);
            StateEventCode stateEventCode = HashikakeStateEventCode.createNumberCodeOf(string);
            state = stateManager.getNextState(cell.getCurState(), stateEventCode);
            cell.setCurState(state);
            this.mLastModified.add(new Point(n, n2));
        } else {
            this.resetAt(n, n2);
        }
    }

    protected void setModelStateSelf(ModelState modelState) {
        this.mModelState = modelState;
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int n, int n2) {
        return this.getCellAt(n, n2).getCurState();
    }

    public State getCorrectStateAt(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean isAcceptableEvent(StateEventCode stateEventCode) {
        if (UtilityFuncs.isDeterminationType(stateEventCode)) {
            return true;
        }
        if (stateEventCode == HashikakeStateEventCode.createSpaceCode()) {
            return true;
        }
        try {
            int n = Integer.parseInt(stateEventCode.getValue());
            if (n > 0 && n < 9) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void nextStateAt(int n, int n2) {
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (!this.contains(n, n2)) {
            return;
        }
        if (!this.isTransitAt(n, n2, stateEventCode)) {
            return;
        }
        Cell cell = this.getCellAt(n, n2);
        State state = StateManager.getInstance().getNextState(cell.getCurState(), stateEventCode);
        cell.setCurState(state);
        this.mLastModified.add(new Point(n, n2));
    }

    public void prevStateAt(int n, int n2) {
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (!this.contains(n, n2)) {
            return;
        }
        if (!this.isTransitAt(n, n2, stateEventCode)) {
            return;
        }
        State state = this.getCurStateAt(n, n2);
        state = StateManager.getInstance().getPrevState(state, stateEventCode);
        this.getCellAt(n, n2).setCurState(state);
        this.mLastModified.add(new Point(n, n2));
    }

    private boolean checkSpaceForNeighborAt(int n, int n2) {
        StateManager stateManager = StateManager.getInstance();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point point = new Point(n, n2);
            Point point2 = DIRECTIONS[i].getDifference();
            point.translate(point2.x, point2.y);
            if (!this.isNumberAt(point.x, point.y)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int n, int n2) {
        return n < this.mWidth && n >= 0 && n2 < this.mHeight && n2 >= 0;
    }

    private Cell getCellAt(int n, int n2) {
        if (n > this.mWidth || n < 0 || n2 > this.mHeight || n2 < 0) {
            throw new IllegalArgumentException("Must be 0 <= inX < " + this.mWidth + ", 0 <= inY < " + this.mHeight + " (was inX = " + n + ", inY = " + n2 + ")");
        }
        return this.mCells[this.toIndex(n, n2)];
    }

    public boolean isNumberAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isNumber();
    }

    public boolean isSpaceAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isSpace();
    }

    public boolean isTransitAt(int n, int n2) {
        return false;
    }

    public boolean isTransitAt(int n, int n2, StateEventCode stateEventCode) {
        Cell cell = this.getCellAt(n, n2);
        if (stateEventCode == HashikakeStateEventCode.createSpaceCode()) {
            return cell.isNumber();
        }
        if (UtilityFuncs.isDeterminationType(stateEventCode)) {
            State state = cell.getCurState();
            return StateManager.getInstance().isTransit(state, stateEventCode);
        }
        return this.checkSpaceForNeighborAt(n, n2);
    }

    protected Point[] lastModifiedSelf() {
        return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
    }

    protected boolean isModifiedSelf() {
        return this.mLastModified.size() > 0;
    }

    protected void flushSelf() {
        this.mLastModified.clear();
        this.mLastModified = new HashSet();
    }

    private static class Cell {
        State mState;

        Cell() {
            this.reset();
        }

        void reset() {
            this.mState = StateManager.getInstance().createDefaultState();
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State state) {
            this.mState = state;
        }

        void setCurState(String string) {
            this.mState = StateManager.getInstance().createStateOf(string);
        }
    }
}

