/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.util.marshal.SaveDiscompletedException;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.KeyScrollCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.SaveCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CellActivationModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CreatorBoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.IllegalSolverStateException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.NullSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.SolverRendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class Board
extends Canvas
implements BoardView {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private DefaultRenderer mRenderer;
    private Model mModel = NullModel.getInstance();
    private SolverHandler mSolverHandler = NullSolverHandler.getInstance();
    private BoardView mParent;
    private boolean mIsModified = false;
    private boolean mIsCreatorMode;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$SaveCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ChangeModeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$BoardFocusibleCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection;

    public void initialize() {
        this.mRenderer = SolverRendererFactory.create(9, 9);
        this.mRenderer.setDefaultRenderListener(new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                graphics.setColor(AppColors.SPACE);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(AppColors.WALL_COLOR);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        });
        this.addModel((Model)new CreatorBoardModel());
        this.addModel((Model)new SolverStateModel(false));
        this.addModel((Model)new CellActivationModel());
        this.mModel.nextStateAt(0, 0);
        this.setBackground(AppColors.BACK_COLOR);
        MouseHandler mouseHandler = new MouseHandler(new Point(0, 0));
        this.addKeyListener(mouseHandler);
        this.addMouseListener(mouseHandler);
        PieceSizeCommand pieceSizeCommand = new PieceSizeCommand((CommandContainer)this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand((Command)pieceSizeCommand);
    }

    private void addModel(Model model) {
        if (model instanceof AbstractDecoratedModel) {
            ((AbstractDecoratedModel)model).addModel(this.mModel);
        }
        this.mModel = model;
    }

    public void processCommand(Command command) {
        if (!command.isConsumed()) {
            this.processCommandImpl(command);
        }
        if (!command.isConsumed() && command instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(command);
        }
    }

    protected void processCommandImpl(Command command) {
        Class<?> clazz = command.getClass();
        if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clearAll();
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$BoardSizeCommand)) {
            BoardSizeCommand boardSizeCommand = (BoardSizeCommand)command;
            int n = boardSizeCommand.getComponentWidth();
            int n2 = boardSizeCommand.getComponentHeight();
            this.setComponentSize(n, n2);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeCommand)) {
            CommandContainer commandContainer = ((ResizeCommand)command).getDestination();
            int n = this.mModel.getWidth();
            int n3 = this.mModel.getHeight();
            ResizeResultCommand resizeResultCommand = new ResizeResultCommand(commandContainer, n, n3);
            AWTDispatchCommandQueue.postCommand((Command)resizeResultCommand);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand)) {
            int n = ((ResizeResultCommand)command).getWidth();
            int n4 = ((ResizeResultCommand)command).getHeight();
            this.createBoard(n, n4);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$SaveCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$SaveCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.SaveCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$SaveCommand)) {
            File file = ((SaveCommand)command).getFile();
            this.save(file);
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$framework$view$command$LoadCommand)) {
            ProblemInfo problemInfo = ((LoadCommand)command).getProblem();
            this.load(problemInfo);
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ChangeModeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ChangeModeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ChangeModeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ChangeModeCommand)) {
            this.changeMode();
            command.consume();
        } else if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$BoardFocusibleCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$BoardFocusibleCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.BoardFocusibleCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$BoardFocusibleCommand)) {
            FocusEvent focusEvent = new FocusEvent(this, 1004);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(focusEvent);
        }
    }

    private void createBoard(int n, int n2) {
        if (n == this.mModel.getWidth() && n2 == this.mModel.getHeight()) {
            return;
        }
        this.mModel.createBoard(n, n2);
        this.mRenderer.setSize(n, n2);
        Dimension dimension = this.getComponentSize();
        BoardSizeCommand boardSizeCommand = new BoardSizeCommand((CommandContainer)this, dimension.width, dimension.height);
        AWTDispatchCommandQueue.postCommand((Command)boardSizeCommand);
        Point point = new Point(0, 0);
        this.mModel.nextStateAt(point.x, point.y);
    }

    private Rectangle getClipBounds() {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.mRenderer.getClipBounds(this.mModel.lastModified());
        rectangle.translate(insets.left, insets.top);
        return rectangle;
    }

    private Point calcPortToBoardPos(int n, int n2) {
        Insets insets = this.getInsets();
        return this.mRenderer.calcPortToBoardPos(n - insets.left, n2 - insets.top);
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        graphics.getClipBounds(rectangle);
        Insets insets = this.getInsets();
        rectangle.translate(-insets.left, -insets.top);
        graphics.translate(insets.left, insets.top);
        if (this.mModel.isModified()) {
            Point[] pointArray = this.mModel.lastModified();
            for (int i = 0; i < pointArray.length; ++i) {
                this.mRenderer.render(pointArray[i].x, pointArray[i].y, this.mModel.getCurStateAt(pointArray[i].x, pointArray[i].y));
            }
        }
        graphics.drawImage(this.mRenderer.getImage(), 0, 0, this);
        graphics.translate(-insets.left, -insets.top);
        this.mModel.flush();
    }

    private void changeMode() {
        this.mIsCreatorMode = !this.mIsCreatorMode;
        this.mModel.setModelState(ModelStateUtility.createSolverModelState(this.mIsCreatorMode));
        if (this.mIsCreatorMode) {
            if (this.mSolverHandler == NullSolverHandler.getInstance()) {
                this.mSolverHandler = new HashikakeSolverHandler(this.mModel);
            }
            try {
                this.mSolverHandler.reset();
                while (!this.mSolverHandler.nextSoluteAll()) {
                }
            }
            catch (SolveDiscompleteException solveDiscompleteException) {}
        } else {
            this.mModel.reset();
            this.mSolverHandler.reset();
        }
        this.changeMenuCheckMark("Input Mode", !this.mIsCreatorMode);
        this.changeMenuCheckMark("Create Mode", this.mIsCreatorMode);
        this.enableMenu("Open", !this.mIsCreatorMode);
        if (this.mModel.isModified()) {
            this.repaint();
        }
    }

    private void save(File file) {
        File file2 = file;
        ProblemCollection problemCollection = this.createProblemCollection(file);
        try {
            this.saveProblem(file2, problemCollection);
            System.out.println("save complete");
        }
        catch (SaveDiscompletedException saveDiscompletedException) {
            System.out.println((Object)saveDiscompletedException);
            return;
        }
        this.enableMenu("Save", false);
        this.mIsModified = false;
    }

    private ProblemCollection createProblemCollection(File file) {
        int n = this.mModel.getWidth();
        int n2 = this.mModel.getHeight();
        StateManager stateManager = StateManager.getInstance();
        int n3 = n * n2 * 3;
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                String string = stateManager.findIdentityOf(this.mModel.getCurStateAt(j, i));
                stringBuffer.append(string).append(',');
            }
        }
        String string = stringBuffer.substring(0, stringBuffer.length() - 1);
        ProblemCollection problemCollection = new ProblemCollection();
        problemCollection.addProblem(new ProblemInfoBean(n, n2, string));
        return problemCollection;
    }

    private void saveProblem(File file, ProblemCollection problemCollection) throws SaveDiscompletedException {
        try {
            IBindingFactory iBindingFactory = BindingDirectory.getFactory(class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$util$marshal$ProblemCollection);
            IMarshallingContext iMarshallingContext = iBindingFactory.createMarshallingContext();
            iMarshallingContext.setIndent(4);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("specified file : " + file.getName() + ", could not be found !");
                throw new SaveDiscompletedException("save discomplete");
            }
            iMarshallingContext.marshalDocument((Object)problemCollection, "utf-8", null, fileOutputStream);
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                System.out.println("close operation is not successful !");
            }
        }
        catch (JiBXException jiBXException) {
            throw new SaveDiscompletedException("save discomplete");
        }
    }

    private void load(ProblemInfo problemInfo) {
        this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        this.mModel.nextStateAt(0, 0);
        this.mModel.setProblem(problemInfo);
        if (this.mModel.isModified()) {
            this.enableMenu("Save", false);
            Rectangle rectangle = this.getClipBounds();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void clearAll() {
        this.mModel.setModelState(ModelStateUtility.createClearAllState());
        this.mModel.reset();
        this.mModel.setModelState(ModelStateUtility.createSolverModelState(this.mIsCreatorMode));
        if (this.mModel.isModified()) {
            MenuManager.currentMenuManager().setEnabledFor("Clear", false);
            if (!this.isModified()) {
                this.mIsModified = true;
                MenuManager.currentMenuManager().setEnabledFor("Save", true);
            }
            Rectangle rectangle = this.getClipBounds();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setParent(BoardView boardView) {
        this.mParent = boardView;
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().height;
    }

    public Component getComponent() {
        return this;
    }

    public Insets getInsets() {
        int n = this.getPieceSize();
        return new Insets(n, n, n, n);
    }

    private void setComponentSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getComponentSize();
    }

    private Dimension getComponentSize() {
        Dimension dimension = new Dimension(this.mRenderer.getBoardSize());
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void setFocus(boolean bl) {
        this.mParent.setFocus(bl);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void enableMenu(String string, boolean bl) {
        MenuManager.currentMenuManager().setEnabledFor(string, bl);
    }

    private void changeMenuCheckMark(String string, boolean bl) {
        MenuManager.currentMenuManager().setCheckMark(string, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MouseHandler
    implements KeyListener,
    MouseListener {
        private final Point ILLEGAL = ModelConstants.ILLEGAL_POS;
        private Point mActivePiece;

        MouseHandler(Point point) {
            this.mActivePiece = point;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (0 < keyEvent.getModifiers()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 127 || n == 8) {
                StateEventCode stateEventCode = HashikakeStateEventCode.createSpaceCode();
                Board.this.mModel.nextStateAt(this.mActivePiece.x, this.mActivePiece.y, stateEventCode);
                if (Board.this.mModel.isModified()) {
                    if (Board.this.mIsCreatorMode) {
                        try {
                            Board.this.mModel.reset();
                            Board.this.mSolverHandler.reset();
                            while (!Board.this.mSolverHandler.nextSoluteAll()) {
                            }
                        }
                        catch (SolveDiscompleteException solveDiscompleteException) {
                            // empty catch block
                        }
                    }
                    Board.this.enableMenu("Save", true);
                    Board.this.enableMenu("Clear", true);
                    Board.this.mIsModified = true;
                }
            } else if (n == 37 || n == 39 || n == 38 || n == 40) {
                Direction direction = UtilityFuncs.resolveDirectionOf(n);
                Point point = direction.getDifference();
                StateEventCode stateEventCode = UtilityFuncs.getSelectionEventCode();
                Board.this.mModel.nextStateAt(point.x, point.y, stateEventCode);
                if (Board.this.mModel.isModified()) {
                    this.mActivePiece.translate(point.x, point.y);
                    int n2 = Board.this.getPieceSize();
                    Insets insets = Board.this.getInsets();
                    Rectangle rectangle = new Rectangle(insets.left + this.mActivePiece.x * n2 + Board.this.getX(), insets.top + this.mActivePiece.y * n2 + Board.this.getY(), n2, n2);
                    KeyScrollCommand keyScrollCommand = new KeyScrollCommand((BoardView)Board.this, rectangle);
                    AWTDispatchCommandQueue.postCommand((Command)keyScrollCommand);
                }
            } else {
                try {
                    int n3 = Integer.parseInt(KeyEvent.getKeyText(n));
                    if (n3 > 0 && n3 < 9) {
                        StateEventCode stateEventCode = HashikakeStateEventCode.createNumberCodeOf(n3);
                        Board.this.mModel.nextStateAt(this.mActivePiece.x, this.mActivePiece.y, stateEventCode);
                        if (Board.this.mModel.isModified()) {
                            if (Board.this.mIsCreatorMode && (!Board.this.mModel.isSpaceAt(this.mActivePiece.x, this.mActivePiece.y) || Board.this.mSolverHandler.isSolute())) {
                                Board.this.mModel.reset();
                                Board.this.mSolverHandler.reset();
                                while (!Board.this.mSolverHandler.nextSoluteAll()) {
                                }
                            }
                            Board.this.enableMenu("Save", true);
                            Board.this.enableMenu("Clear", true);
                            Board.this.mIsModified = true;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                catch (SolveDiscompleteException solveDiscompleteException) {
                }
                catch (SoluteSeparatedException soluteSeparatedException) {
                    System.out.println(soluteSeparatedException);
                }
                catch (IllegalSolverStateException illegalSolverStateException) {
                    System.out.println(illegalSolverStateException);
                }
            }
            if (Board.this.mModel.isModified()) {
                Rectangle rectangle = Board.this.getClipBounds();
                Board.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!Board.this.isFocused()) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Point point = Board.this.calcPortToBoardPos(n, n2);
            Board.this.mModel.nextStateAt(point.x, point.y);
            if (Board.this.mModel.isModified()) {
                this.mActivePiece = point;
                Rectangle rectangle = Board.this.getClipBounds();
                Board.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

