/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import javax.swing.table.TableModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.SortStrategy;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.CollectionUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.DefaultSortStrategy;

public class HashikakeBenchResultSorter
implements TableSortHandler {
    private TableModel mModel;
    private int[] mSortedIndex = new int[0];
    private SortStrategy mStrategy = new DefaultSortStrategy();
    private boolean mDescentOrdered = true;
    private int mCurColIndex = Integer.MIN_VALUE;

    public void sort() {
        if (this.mCurColIndex == Integer.MIN_VALUE) {
            this.sort(0, false);
        } else if (this.mSortedIndex.length != this.mModel.getRowCount()) {
            this.sort(this.mCurColIndex, this.mDescentOrdered);
        }
    }

    public void sort(int n) {
        if (this.mCurColIndex == n) {
            this.mDescentOrdered = !this.mDescentOrdered;
        } else {
            this.sort(n, true);
        }
    }

    private void sort(int n, boolean bl) {
        if (this.mModel != null) {
            this.initIndexedArray();
            this.mDescentOrdered = true;
            this.mStrategy.sort(n, this.mModel, this.mSortedIndex);
            this.mDescentOrdered = bl;
            this.mCurColIndex = n;
        }
    }

    public void setSortStrategy(SortStrategy sortStrategy) {
        this.mStrategy = sortStrategy;
    }

    public void setModel(TableModel tableModel) {
        this.mModel = tableModel;
    }

    public int resolveRowIndex(int n) {
        this.initIndexedArray();
        if (this.mDescentOrdered) {
            return this.mSortedIndex[n];
        }
        return this.mSortedIndex[this.mSortedIndex.length - n - 1];
    }

    private void initIndexedArray() {
        int n = this.mModel.getRowCount();
        if (this.mSortedIndex.length != n) {
            this.mSortedIndex = new int[n];
            CollectionUtility.iota(this.mSortedIndex);
        }
    }
}

