/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ActionNotFoundException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuBarBean;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class MenuManager {
    private static Map sLookupManager = new HashMap();
    private static MenuDispatcher sDispatcher = new MenuDispatcher();
    private static MenuBarBean sBean;
    private Map mLookupMenu = new HashMap();
    private MenuBar mMenuBar;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$MenuBarBean;

    public static void initMenuBarInfo(URL uRL) {
        try {
            if (null == uRL) {
                throw new FileNotFoundException();
            }
            IBindingFactory iBindingFactory = BindingDirectory.getFactory((Class)(class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$MenuBarBean == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$MenuBarBean = MenuManager.class$("jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuBarBean")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$util$gui$MenuBarBean));
            IUnmarshallingContext iUnmarshallingContext = iBindingFactory.createUnmarshallingContext();
            sBean = (MenuBarBean)iUnmarshallingContext.unmarshalDocument(uRL.openStream(), null);
        }
        catch (IOException iOException) {
            System.out.println("The property file : " + uRL.getFile() + " is no existance");
            iOException.printStackTrace(System.out);
            System.exit(-1);
        }
        catch (JiBXException jiBXException) {
            System.out.println("Cannot make MenuInfoBean from the property file : " + uRL.getFile());
            jiBXException.printStackTrace(System.out);
            System.exit(-1);
        }
    }

    public static MenuManager currentMenuManager() {
        BoardView boardView = (BoardView)ComponentUsher.getInstance().getActiveComponent();
        return MenuManager.currentMenuManager(boardView);
    }

    public static MenuManager currentMenuManager(BoardView boardView) {
        if (!sLookupManager.containsKey(boardView.getComponent())) {
            throw new IllegalStateException("The MenuManager for the specified frame isnot registered.\nCalling MenuManager.createMenuManager() leads to register the manager for specified the frame .");
        }
        return (MenuManager)sLookupManager.get(boardView.getComponent());
    }

    public static MenuBar createMenuManager(BoardView boardView) {
        if (null == sBean) {
            throw new IllegalStateException("The menu infomation is not initialized. \nCalling initMenuBarInfo(File) is to initialize it.");
        }
        MenuManager menuManager = null;
        if (sLookupManager.containsKey(boardView)) {
            menuManager = (MenuManager)sLookupManager.get(boardView);
        } else {
            menuManager = new MenuManager();
            menuManager.initialize();
            sLookupManager.put(boardView.getComponent(), menuManager);
        }
        return menuManager.getMenuBar();
    }

    private void initialize() {
        this.mMenuBar = new MenuBar();
        for (int i = 0; i < sBean.getMenuCount(); ++i) {
            MenuItem menuItem = sBean.getMenuElementAt(i).createMenuItem(this);
            if (!(menuItem instanceof Menu)) continue;
            this.mMenuBar.add((Menu)menuItem);
        }
    }

    ActionListener getActionDispatcher() {
        return sDispatcher;
    }

    void installDelegateAction(String string, String string2) {
        sDispatcher.installDelegateAction(string, string2);
    }

    void installMenuItem(String string, MenuItem menuItem) {
        this.mLookupMenu.put(string, menuItem);
    }

    public MenuBar getMenuBar() {
        return this.mMenuBar;
    }

    public void setEnabledFor(String string, boolean bl) {
        if (!this.mLookupMenu.containsKey(string)) {
            throw new IllegalArgumentException("The Menu with the specified ID is no existance.");
        }
        MenuItem menuItem = (MenuItem)this.mLookupMenu.get(string);
        menuItem.setEnabled(bl);
    }

    public void setCheckMark(String string, boolean bl) {
        if (!this.mLookupMenu.containsKey(string)) {
            throw new IllegalArgumentException("The Menu with the specified ID is no existance.");
        }
        MenuItem menuItem = (MenuItem)this.mLookupMenu.get(string);
        if (menuItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)menuItem).setState(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MenuDispatcher
    implements ActionListener {
        Map mRealListenerMap = new HashMap();

        private MenuDispatcher() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread((Runnable)new MenuDispatchThread(actionEvent), "MenuDispatchThread").start();
        }

        void installDelegateAction(String string, String string2) {
            ActionEntry actionEntry = (ActionEntry)this.mRealListenerMap.get(string);
            if (null == actionEntry) {
                actionEntry = new ActionEntry(string, string2);
                this.mRealListenerMap.put(string, actionEntry);
            }
        }

        private class MenuDispatchThread
        implements Runnable {
            private ActionEvent mEvent;

            MenuDispatchThread(ActionEvent actionEvent) {
                this.mEvent = actionEvent;
            }

            public void run() {
                String string = ((MenuItem)this.mEvent.getSource()).getActionCommand();
                try {
                    ActionEntry actionEntry = (ActionEntry)MenuDispatcher.this.mRealListenerMap.get(string);
                    actionEntry.getListener().actionPerformed(this.mEvent);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    System.out.println(actionNotFoundException);
                    actionNotFoundException.printStackTrace(System.out);
                }
            }
        }

        private static class ActionEntry {
            String mCommand;
            String mClassName;
            ActionListener mListener;

            ActionEntry(String string, String string2) {
                this.mCommand = string;
                this.mClassName = string2;
            }

            ActionListener getListener() throws ActionNotFoundException {
                if (null != this.mListener) {
                    return this.mListener;
                }
                try {
                    Class<?> clazz = Class.forName(this.mClassName);
                    this.mListener = (ActionListener)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("The specified action class is no existance");
                    throw new ActionNotFoundException(this.mClassName);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("The specified action class could not be instantiated");
                    throw new ActionNotFoundException(this.mClassName);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Could not be accessed in the default constructor");
                    throw new ActionNotFoundException(this.mClassName);
                }
                return this.mListener;
            }
        }
    }
}

