/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class BoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mModifiedPos = new HashSet();

    public BoardModel() {
        this(NullModel.getInstance());
    }

    public BoardModel(Model model) {
        super(model);
    }

    protected void createBoardSelf(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mCells = new Cell[n * n2];
    }

    public int setProblem(ProblemInfo problemInfo) {
        if (this.mWidth != problemInfo.getWidth() || this.mHeight != problemInfo.getHeight()) {
            this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        }
        if (!problemInfo.isMoreRead()) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        if (problemInfo.isDivideRead()) {
            n = problemInfo.getOffset();
        }
        for (int i = n; i < n + problemInfo.getReadOnce(); ++i) {
            this.mCells[i] = new Cell((String)problemInfo.getRecordAt(i));
            this.addModifiedSet(i);
        }
        return problemInfo.isDivideRead() ? problemInfo.getReadOnce() : Integer.MIN_VALUE;
    }

    private void addModifiedSet(int n) {
        int n2 = n % this.mWidth;
        int n3 = n / this.mWidth;
        this.mModifiedPos.add(new Point(n2, n3));
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        boolean bl = false;
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                this.resetAtSelf(j, i);
            }
        }
    }

    protected void resetAtSelf(int n, int n2) {
        Cell cell = this.getCellAt(n, n2);
        if (!cell.isSpace()) {
            this.mModifiedPos.add(new Point(n, n2));
            cell.reset();
        }
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int n, int n2) {
        return this.getCellAt(n, n2).getCurState();
    }

    public void nextStateAt(int n, int n2) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (!this.isTransitAt(n, n2, stateEventCode)) {
            return;
        }
        State state = this.getCurStateAt(n, n2);
        state = StateManager.getInstance().getNextState(state, stateEventCode);
        this.setCurStateAt(n, n2, state);
        this.mModifiedPos.add(new Point(n, n2));
    }

    public void prevStateAt(int n, int n2) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (!this.isTransitAt(n, n2, stateEventCode)) {
            return;
        }
        State state = this.getCurStateAt(n, n2);
        state = StateManager.getInstance().getPrevState(state, stateEventCode);
        this.setCurStateAt(n, n2, state);
        this.mModifiedPos.add(new Point(n, n2));
    }

    private void setCurStateAt(int n, int n2, State state) {
        Cell cell = this.getCellAt(n, n2);
        cell.setCurState(state);
    }

    protected synchronized Point[] lastModifiedSelf() {
        return this.mModifiedPos.toArray(new Point[this.mModifiedPos.size()]);
    }

    protected synchronized boolean isModifiedSelf() {
        return !this.mModifiedPos.isEmpty();
    }

    protected synchronized void flushSelf() {
        if (!this.mModifiedPos.isEmpty()) {
            this.mModifiedPos = new HashSet();
        }
    }

    public boolean isNumberAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isNumber();
    }

    public boolean isSpaceAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isSpace();
    }

    public boolean isTransitAt(int n, int n2, StateEventCode stateEventCode) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isTransit(stateEventCode);
    }

    public boolean isTransitAt(int n, int n2) {
        throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
    }

    protected boolean isAcceptableEvent(StateEventCode stateEventCode) {
        return UtilityFuncs.isDeterminationType(stateEventCode);
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n < this.mWidth && n2 >= 0 && n2 < this.mHeight;
    }

    public State getCorrectStateAt(int n, int n2) {
        throw new UnsupportedOperationException("This model isnot supported getCorrectStateAt method.");
    }

    private Cell getCellAt(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.mWidth || n2 >= this.mHeight) {
            throw new IndexOutOfBoundsException("0 < x <= " + this.mWidth + ", 0 < y <= " + this.mHeight + " (inX : " + n + ", inY : " + n2 + ")");
        }
        return this.mCells[this.mWidth * n2 + n];
    }

    private static class Cell {
        private State mState;

        Cell(String string) {
            StateManager stateManager = StateManager.getInstance();
            try {
                Integer.parseInt(string.trim());
                NumberState numberState = (NumberState)stateManager.createStateOf(string);
                this.mState = new HashikakeNumberState(numberState, stateManager.createDefaultState());
            }
            catch (NumberFormatException numberFormatException) {
                this.mState = stateManager.createDefaultState();
            }
        }

        void reset() {
            StateManager stateManager = StateManager.getInstance();
            this.mState = this.isNumber() ? new HashikakeNumberState(((HashikakeNumberState)this.mState).getNumberState(), stateManager.createDefaultState()) : stateManager.createDefaultState();
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isTransit(StateEventCode stateEventCode) {
            return StateManager.getInstance().isTransit(this.mState, stateEventCode);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State state) {
            this.mState = state;
        }
    }
}

