/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeDispatcher;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashikakeModelChangeHandler
implements ModelChangeListener,
ModelChangeDispatcher {
    private Model mModel;

    public HashikakeModelChangeHandler(Model model) {
        this.mModel = model;
    }

    public void processModelChange(ModelChangeEvent modelChangeEvent) {
        switch (modelChangeEvent.getMode()) {
            case 0: {
                this.selectionChanged(modelChangeEvent);
                break;
            }
            case 1: {
                this.selectionDetermined(modelChangeEvent);
            }
        }
    }

    public void selectionChanged(ModelChangeEvent modelChangeEvent) {
        StateEventCode stateEventCode = UtilityFuncs.getSelectDirectionEventCode(modelChangeEvent.getDirection());
        Point point = modelChangeEvent.getPos();
        this.mModel.nextStateAt(point.x, point.y, stateEventCode);
    }

    public void selectionDetermined(ModelChangeEvent modelChangeEvent) {
        Point[] pointArray = this.mModel.lastModified();
        StateEventCode stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(modelChangeEvent.getDirection());
        for (int i = 0; i < pointArray.length; ++i) {
            if (modelChangeEvent.isTransitNext()) {
                this.mModel.nextStateAt(pointArray[i].x, pointArray[i].y, stateEventCode);
                continue;
            }
            this.mModel.prevStateAt(pointArray[i].x, pointArray[i].y, stateEventCode);
        }
    }
}

