/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolutionCheckModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private int[] mCheckArray;
    private boolean mArrayCreated = false;

    public SolutionCheckModel(Model model) {
        super(model);
    }

    public boolean check() {
        StateManager stateManager = StateManager.getInstance();
        if (!this.mArrayCreated) {
            this.mCheckArray = this.initCheckArray();
        }
        return new CheckWorker().start(this.mCheckArray);
    }

    private int[] initCheckArray() {
        StateManager stateManager = StateManager.getInstance();
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        int n = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            int n2 = 0;
            while (n2 < this.getWidth()) {
                if (this.isNumberAt(n2, i)) {
                    try {
                        int n3;
                        nArray[n] = n3 = Integer.parseInt(stateManager.findIdentityOf(this.getCurStateAt(n2, i)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
                    }
                }
                ++n2;
                ++n;
            }
        }
        this.mArrayCreated = true;
        return nArray;
    }

    protected void createBoardSelf(int n, int n2) {
        this.mArrayCreated = false;
        this.mCheckArray = null;
    }

    protected void resetAtSelf(int n, int n2) {
    }

    protected Point[] lastModifiedSelf() {
        return NO_MODIFIED;
    }

    protected boolean isModifiedSelf() {
        return false;
    }

    public boolean isAcceptableEvent(StateEventCode stateEventCode) {
        return true;
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
    }

    protected void flushSelf() {
    }

    private class CheckWorker {
        private List mQueue;
        private boolean[] mDoubleCkecked;
        private int[] mCheckArray;

        private CheckWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean start(int[] nArray) {
            block7: {
                boolean bl;
                block6: {
                    if (null == nArray) throw new IllegalArgumentException("check array isnot correctly initialized.");
                    if (nArray.length == 0) {
                        throw new IllegalArgumentException("check array isnot correctly initialized.");
                    }
                    this.initialize(nArray);
                    try {
                        int n;
                        while (!this.mQueue.isEmpty()) {
                            n = (Integer)this.mQueue.remove(0);
                            if (0 < this.mCheckArray[n]) {
                                this.checkSolution(n);
                            }
                            if (0 <= this.mCheckArray[n]) continue;
                            boolean bl2 = false;
                            Object var5_5 = null;
                            this.mCheckArray = null;
                            this.mDoubleCkecked = null;
                            this.mQueue = null;
                            return bl2;
                        }
                        for (n = 0; n < this.mCheckArray.length; ++n) {
                            if (0 == this.mCheckArray[n]) continue;
                            bl = false;
                            break block6;
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        this.mCheckArray = null;
                        this.mDoubleCkecked = null;
                        this.mQueue = null;
                        throw throwable;
                    }
                }
                Object var5_6 = null;
                this.mCheckArray = null;
                this.mDoubleCkecked = null;
                this.mQueue = null;
                return bl;
            }
            Object var5_7 = null;
            this.mCheckArray = null;
            this.mDoubleCkecked = null;
            this.mQueue = null;
            return true;
        }

        private void checkSolution(int n) {
            int n2 = n % SolutionCheckModel.this.getWidth();
            int n3 = n / SolutionCheckModel.this.getWidth();
            Point point = new Point(n2, n3);
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                StateEventCode stateEventCode;
                Point point2 = DIRECTIONS[i].getDifference();
                point.translate(point2.x, point2.y);
                if (SolutionCheckModel.this.contains(point.x, point.y) && !SolutionCheckModel.this.isSpaceAt(point.x, point.y) && SolutionCheckModel.this.isTransitAt(point.x, point.y, stateEventCode = UtilityFuncs.getDetermineDirectionEventCode(DIRECTIONS[i]))) {
                    int n4 = HashikakeStateManagerImpl.countBridge(SolutionCheckModel.this.getCurStateAt(point.x, point.y));
                    if (0 == n4) {
                        throw new IllegalStateException("Both islands donot neighbor each other.\n\tOne side : " + new Point(n2, n3) + "\n" + "\tOpposite side : " + point);
                    }
                    int n5 = this.findIndexOfOppositeSide(point, point2);
                    if (!this.mDoubleCkecked[n5]) {
                        int n6 = n5;
                        this.mCheckArray[n6] = this.mCheckArray[n6] - n4;
                        int n7 = n;
                        this.mCheckArray[n7] = this.mCheckArray[n7] - n4;
                        this.mDoubleCkecked[n] = true;
                        this.mQueue.add(new Integer(n5));
                    }
                }
                point.translate(-point2.x, -point2.y);
            }
        }

        private int findIndexOfOppositeSide(Point point, Point point2) {
            Point point3 = new Point(point);
            point3.translate(point2.x, point2.y);
            do {
                if (SolutionCheckModel.this.isNumberAt(point3.x, point3.y)) {
                    return this.toIndex(point3.x, point3.y);
                }
                point3.translate(point2.x, point2.y);
            } while (SolutionCheckModel.this.contains(point3.x, point3.y));
            throw new IllegalStateException("The opposite side is no existance.");
        }

        private int toIndex(int n, int n2) {
            return n2 * SolutionCheckModel.this.getWidth() + n;
        }

        private void initialize(int[] nArray) {
            this.mDoubleCkecked = new boolean[nArray.length];
            this.mCheckArray = new int[nArray.length];
            System.arraycopy(nArray, 0, this.mCheckArray, 0, nArray.length);
            this.mQueue = new LinkedList();
            for (int i = 0; i < this.mCheckArray.length; ++i) {
                if (0 >= this.mCheckArray[i]) continue;
                this.mQueue.add(new Integer(i));
                break;
            }
        }
    }
}

