/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;

public class RendererFactory {
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$HashikakeNumberState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$DefaultColorState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberActiveState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$SelectionState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState;

    public static DefaultRenderer create(int n, int n2) {
        DefaultRenderer defaultRenderer = new DefaultRenderer(n, n2, AppColors.BACK_COLOR);
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$HashikakeNumberState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$HashikakeNumberState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$HashikakeNumberState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Renderer renderer = renderEvent.getSource();
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                HashikakeNumberState hashikakeNumberState = (HashikakeNumberState)renderEvent.getState();
                for (int i = 0; i < hashikakeNumberState.getAdjacentCount(); ++i) {
                    HashikakeNumberState.AdjacentState adjacentState = hashikakeNumberState.getAdjacentAt(i);
                    if (StateManager.getInstance().isSpaceState(adjacentState.getState())) continue;
                    Rectangle rectangle2 = graphics.getClipBounds();
                    Rectangle rectangle3 = this.calcClipRegion(graphics, rectangle, adjacentState.getDirection());
                    renderEvent.reset(renderer, graphics, rectangle3, adjacentState.getState());
                    RenderListener renderListener = ((DefaultRenderer)renderer).lookup(renderEvent.getState());
                    renderListener.render(renderEvent);
                    graphics.setClip(rectangle2);
                }
                renderEvent.reset(renderer, graphics, rectangle, hashikakeNumberState.getColorState());
                RenderListener renderListener = ((DefaultRenderer)renderer).lookup(renderEvent.getState());
                renderListener.render(renderEvent);
                renderEvent.reset(renderer, graphics, rectangle, hashikakeNumberState.getNumberState());
                renderListener = ((DefaultRenderer)renderer).lookup(renderEvent.getState());
                renderListener.render(renderEvent);
            }

            private Rectangle calcClipRegion(Graphics graphics, Rectangle rectangle, Direction direction) {
                Rectangle rectangle2 = graphics.getClipBounds();
                Point point = direction.getDifference();
                Rectangle rectangle3 = new Rectangle(rectangle.x + point.x * rectangle.width / 2, rectangle.y + point.y * rectangle.height / 2, rectangle.width, rectangle.height);
                return rectangle3.intersection(rectangle2);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$DefaultColorState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$DefaultColorState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.DefaultColorState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$DefaultColorState, new RenderListener(){
            private static final int INSET = 1;

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = new Rectangle(renderEvent.getBounds());
                rectangle.grow(-1, -1);
                graphics.setColor(AppColors.ISLAND);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = new Rectangle(renderEvent.getBounds());
                int n = ((NumberState)renderEvent.getState()).getValue();
                graphics.setColor(AppColors.ISLAND_NUMBER);
                String string = String.valueOf(n);
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
                int n2 = (int)((double)rectangle.x + ((double)rectangle.width - rectangle2D.getWidth()) / 2.0);
                int n3 = (int)((double)rectangle.y - rectangle2D.getY() + ((double)rectangle.width - rectangle2D.getHeight()) / 2.0);
                graphics.drawString(string, n2, n3);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberActiveState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberActiveState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NumberActiveState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Renderer renderer = renderEvent.getSource();
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                NumberActiveState numberActiveState = (NumberActiveState)renderEvent.getState();
                renderEvent.reset(renderer, graphics, rectangle, numberActiveState.getDecorated());
                RenderListener renderListener = ((DefaultRenderer)renderer).lookup(renderEvent.getState());
                renderListener.render(renderEvent);
                graphics.setColor(AppColors.ACTIVE_COLOR);
                Shape shape = this.calcClipRegion(graphics, rectangle, numberActiveState.getDirection());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setClip(shape);
            }

            private Shape calcClipRegion(Graphics graphics, Rectangle rectangle, Direction direction) {
                Shape shape = graphics.getClip();
                Area area = new Area();
                area.add(new Area(new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height)));
                if (Direction.NO != direction) {
                    Point point = direction.getDifference();
                    area.add(new Area(new Rectangle(rectangle.x + point.x * rectangle.width / 2, rectangle.y + point.y * rectangle.height / 2, rectangle.width, rectangle.height)));
                }
                area.intersect(new Area(shape));
                graphics.setClip(area);
                return shape;
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$SelectionState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$SelectionState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$SelectionState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Renderer renderer = renderEvent.getSource();
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                State state = renderEvent.getState();
                renderEvent.reset(renderer, graphics, rectangle, ((SelectionState)state).getDecorated());
                RenderListener renderListener = ((DefaultRenderer)renderer).lookup(renderEvent.getState());
                renderListener.render(renderEvent);
                graphics.setColor(AppColors.ACTIVE_COLOR);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                graphics.setColor(AppColors.BRIDGE);
                graphics.fillRect(rectangle.x + rectangle.width * 2 / 5, rectangle.y, rectangle.width / 5, rectangle.height);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                graphics.setColor(AppColors.BRIDGE);
                graphics.fillRect(rectangle.x + rectangle.width / 5, rectangle.y, rectangle.width / 5, rectangle.height);
                graphics.fillRect(rectangle.x + rectangle.width * 3 / 5, rectangle.y, rectangle.width / 5, rectangle.height);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                graphics.setColor(AppColors.BRIDGE);
                graphics.fillRect(rectangle.x, rectangle.y + rectangle.height * 2 / 5, rectangle.width, rectangle.height / 5);
            }
        });
        defaultRenderer.addRenderListener(class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState = RendererFactory.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState, new RenderListener(){

            public void render(RenderEvent renderEvent) {
                Graphics graphics = renderEvent.getGraphics();
                Rectangle rectangle = renderEvent.getBounds();
                graphics.setColor(AppColors.BRIDGE);
                graphics.fillRect(rectangle.x, rectangle.y + rectangle.height / 5, rectangle.width, rectangle.height / 5);
                graphics.fillRect(rectangle.x, rectangle.y + rectangle.height * 3 / 5, rectangle.width, rectangle.height / 5);
            }
        });
        return defaultRenderer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

