/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;

public class FileNode {
    private static final File[] NO_DIRECTORY = new File[0];
    private String mAbsPath;
    private String mDisplayedName;
    private File mFile;
    private File[] mSubFiles;
    private FileFilter mFilter;

    public FileNode(File file) {
        this(file, null);
    }

    public FileNode(File file, FileFilter fileFilter) {
        if (null == file) {
            throw new IllegalArgumentException("must specified File-object to construct this object");
        }
        this.mAbsPath = file.getAbsolutePath();
        this.mDisplayedName = FileSystemView.getFileSystemView().getSystemDisplayName(file);
        this.mFile = file;
        this.mFilter = fileFilter;
        if (!this.isLeaf()) {
            this.mSubFiles = this.mFile.listFiles();
            if (null != this.mFilter) {
                ArrayList<File> arrayList = new ArrayList<File>(this.mSubFiles.length);
                for (int i = 0; i < this.mSubFiles.length; ++i) {
                    if (!this.mFilter.accept(this.mSubFiles[i])) continue;
                    arrayList.add(this.mSubFiles[i]);
                }
                this.mSubFiles = arrayList.toArray(new File[arrayList.size()]);
            }
        } else {
            this.mSubFiles = NO_DIRECTORY;
        }
    }

    public String getName() {
        return this.mDisplayedName;
    }

    public String getAbsolutePath() {
        return this.mAbsPath;
    }

    public void setName(String string) {
        throw new UnsupportedOperationException();
    }

    public long getSize() {
        return this.mFile.length();
    }

    public void addChild(FileNode fileNode) {
        FileSystemView.getFileSystemView().createFileObject(this.mFile, fileNode.mAbsPath);
        this.mSubFiles = this.mFile.listFiles(this.mFilter);
    }

    public void addChild(int n, FileNode fileNode) {
        this.addChild(fileNode);
    }

    public void removeChild(FileNode fileNode) {
        if (fileNode.mFile.delete()) {
            this.mSubFiles = this.mFile.listFiles(this.mFilter);
        }
    }

    public FileNode getChild(int n) {
        return new FileNode(this.mSubFiles[n], this.mFilter);
    }

    public int getIndexOfChild(FileNode fileNode) {
        for (int i = 0; i < this.mSubFiles.length; ++i) {
            if (!this.mSubFiles[i].equals(fileNode.mFile)) continue;
            return i;
        }
        return -1;
    }

    public int getChildCount() {
        if (this.isLeaf()) {
            return 0;
        }
        return this.mSubFiles.length;
    }

    public int hashCode() {
        return this.mFile.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FileNode) {
            return this.mFile.equals(((FileNode)object).mFile);
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLeaf() {
        return this.mFile.isFile();
    }
}

