/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;

public class HashikakeBenchmarkHandler
implements BenchmarkHandler {
    private Model mModel = new SolverStateModel((Model)new BoardModel());
    private SolverHandler mHandler = new HashikakeSolverHandler(this.mModel);
    private ProblemInfo mProblem;

    public void reset(ProblemInfo problemInfo) {
        this.mModel.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        this.mModel.setProblem(problemInfo);
        this.mHandler.reset();
        this.mProblem = problemInfo;
    }

    public BenchReport solve(int n) {
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        this.gc();
        long l3 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            long l4 = System.currentTimeMillis();
            try {
                this.mModel.reset();
                this.mHandler.reset();
                while (!this.mHandler.nextSoluteAll()) {
                }
                long l5 = System.currentTimeMillis() - l4;
                l = Math.min(l, l5);
                l2 = Math.max(l2, l5);
                continue;
            }
            catch (SolveDiscompleteException solveDiscompleteException) {
                return BenchReport.illegalBenchReport(this.mProblem, System.currentTimeMillis() - l4);
            }
        }
        l3 = System.currentTimeMillis() - l3;
        return BenchReport.createReport(this.mProblem, l, l2, l3 / (long)n, n);
    }

    private void gc() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(200L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

