// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		AWTDispatchCommand.java
//	DATE:		2003.6.26
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.view.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;

import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;

import jp.gr.java_conf.ktz.puzzle.framework.util.Command;

/**
 *	ViewKw`dCommand|Xg邽߂ProxyNX
 */
class AWTDispatchCommand extends AWTEvent implements ActiveEvent, Command {
	/** CommandAWT Event ID */
	private static final int EVENT_ID = AWTEvent.RESERVED_ID_MAX + 1;
	
	/** ۂɓ]R}h */
	private Command mCommand;
	/**
	 *	RXgN^
	 *
	 *	@param	inSrcView	Command`d̃Gg[|Cg
	 */
	protected AWTDispatchCommand(Command inCommand) {
		super(inCommand.getSource(), EVENT_ID);
		
		mCommand = inCommand;
	}
	
	/**
	 *	java.awt.ActiveEvent̃\bh̎B
	 *	event queuedispatch邽߂̏LqĂB
	 */
	public void dispatch() {
		CommandContainer aCommander = (CommandContainer)getSource();
		
		aCommander.processCommand(mCommand);
	}
	
	/** 
	 *	Command̏
	 */
	public void consume() {
		super.consume();
	}
	
	/** 
	 *	Commandꂽǂ`FbN 
	 *
	 *	@return	Ă΁AtrueԂB
	 */
	public boolean isConsumed() {
		return super.isConsumed();
	}
	
	/** 
	 *	@return	̓]Ԃ
	 */
	public Object getSource() {
		return super.getSource();
	}
}
