//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BenchReport.java
//	DATE:		2003.9.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench;

import java.math.BigDecimal;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

/**
 *	̉𓚂ɗvԂێ邽߂̃IuWFNg
 */
public class BenchReport {
	/**  */
	private ProblemInfo mProblem;
	
	/** 𓚂̍ŒZ */
	private long mElapsedMinTime;
	
	/** 𓚂̍Œ */
	private long mElapsedMaxTime;
	
	/** 𓚂̕ώ */
	private long mAverageTime;
	
	/** 𓚉 */
	private int mSolveCount;
	
	/** 𓚂łǂ */
	private boolean mSolved;
	
	private BenchReport(ProblemInfo inProblem, 
		final long inMinTime, final long inMaxTime, final long inAverageTime, 
		final int inCount, final boolean inSolved)
	{
		mProblem = inProblem;
		mElapsedMinTime = inMinTime;
		mElapsedMaxTime = inMaxTime;
		mAverageTime = inAverageTime;
		mSolveCount = inCount;
		mSolved = inSolved;
	}
	
	public static BenchReport createReport(ProblemInfo inProblem, 
		final long inMinTime, final long inMaxTime, final long inAverageTime, 
		final int inCount)
	{
		return new BenchReport(inProblem,inMinTime, inMaxTime, inAverageTime, inCount, true);
	}
	
	public static BenchReport illegalBenchReport(ProblemInfo inProblem, final long inSolveTime) {
		return new BenchReport(inProblem, inSolveTime, inSolveTime, inSolveTime, 1, false);	
	}
	
	public Object[] flatten() {
		return new Object[] {
			getProblemName(),
			getSize(), 
			new Long(mElapsedMinTime), 
			new Long(mElapsedMaxTime), 
			new Long(mAverageTime), 
			new Integer(mSolveCount), 
			Boolean.valueOf(mSolved), 
		};
	}
	
	public String getProblemName() {
		return mProblem.getProblemName();
	}
	
	public String getSize() {
		StringBuffer aSize = new StringBuffer(16);
		aSize.append(mProblem.getWidth()).append(" X ").append(mProblem.getHeight());
		
		return new String(aSize);
	}
	
	public long getElapsedMinTime() {
		return mElapsedMinTime;
	}
	
	public long getElapsedMaxTime() {
		return mElapsedMaxTime;
	}
	
	public long getAverageTime() {
		return mAverageTime;
	}
	
	public int getSolveCount() {
		return mSolveCount;
	}
	
	public boolean isSolved() {
		return mSolved;
	}
	
	public String toString() {
		return "problem name : " + getProblemName() + "\n"
			+ "problem size      : " + getSize() + "\n"
			+ "elapsed min time  : " + mElapsedMinTime + " msec \n"
			+ "elapsed max time  : " + mElapsedMaxTime + " msec \n"
			+ "average time      : " + mAverageTime + " msec \n"
			+ "measurement count : " + mSolveCount + " msec \n"
			+ "solved            : " + mSolved + "\n"
		;
	}
}
