/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import jp.hrtdotnet.java.lang.DateFormatException;

public class DateUtil {
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYYMM = "yyyyMM";
    public static final String FORMAT_YYMMDD = "yyMMdd";
    public static final String FORMAT_YYMM = "yyMM";
    public static final String FORMAT_MMDD = "MMdd";
    public static final String FORMAT_YYYY = "yyyy";
    public static final String FORMAT_YY = "yy";
    public static final String FORMAT_MM = "MM";
    public static final String FORMAT_DD = "dd";
    public static final int JANUARY_DAYS = 31;
    public static final int FEBRUARY_DAYS = 29;
    public static final int FEBRUARY_NORMAL_DAYS = 28;
    public static final int FEBRUARY_LEAP_DAYS = 29;
    public static final int MARCH_DAYS = 31;
    public static final int APRIL_DAYS = 30;
    public static final int MAY_DAYS = 31;
    public static final int JUNE_DAYS = 30;
    public static final int JULY_DAYS = 31;
    public static final int AUGUST_DAYS = 31;
    public static final int SEPTEMBER_DAYS = 30;
    public static final int OCTOBER_DAYS = 31;
    public static final int NOVEMBER_DAYS = 30;
    public static final int DECEMBER_DAYS = 31;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int FEBRUARY_LEAP = 13;
    public static final int FEBRUARY_NORMAL = 14;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int UNDEFINED_MONTH = 0;
    public static final int MIN_MONTH_OF_YEAR = 1;
    public static final int MAX_MONTH_OF_YEAR = 12;
    public static final int MIN_DAY_OF_MONTH = 1;
    public static final int MAX_DAY_OF_MONTH = 31;
    public static final int VALIDATE_NORMAL = 0;
    public static final int VALIDATE_MONTH_OVERRANGE = 1;
    public static final int VALIDATE_DAY_OVERRANGE = 1;

    public static Calendar getYesterday() {
        return DateUtil.getYesterday(null);
    }

    public static Calendar getYesterday(Calendar c) {
        c = c == null ? Calendar.getInstance() : (Calendar)c.clone();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        if (d == c.getActualMinimum(5) && m == 0) {
            c.set(1, y - 1);
            c.set(2, 11);
            c.set(5, c.getActualMaximum(5));
        } else if (d == c.getActualMinimum(5)) {
            c.set(2, m - 1);
            c.set(5, c.getActualMaximum(5));
        } else {
            c.set(5, d - 1);
        }
        return c;
    }

    public static Calendar getTomorrow() {
        return DateUtil.getTomorrow(null);
    }

    public static Calendar getTomorrow(Calendar c) {
        c = c == null ? Calendar.getInstance() : (Calendar)c.clone();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        if (d == c.getActualMaximum(5) && m == 11) {
            c.set(1, y + 1);
            c.set(2, 0);
            c.set(5, c.getActualMinimum(5));
        } else if (d == c.getActualMaximum(5)) {
            c.set(2, m + 1);
            c.set(5, c.getActualMinimum(5));
        } else {
            c.set(5, d + 1);
        }
        return c;
    }

    public static String getString(Calendar c, String format) {
        c = c == null ? Calendar.getInstance() : (Calendar)c.clone();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(c.getTime());
    }

    public static String getString(Calendar c) {
        return DateUtil.getString(c, FORMAT_YYYYMMDD);
    }

    public static String getYesetdayString(String format) {
        Calendar c = DateUtil.getYesterday();
        return DateUtil.getString(c, format);
    }

    public static String getYesetdayString() {
        return DateUtil.getYesetdayString(FORMAT_YYYYMMDD);
    }

    public static String getTomorrowString(String format) {
        Calendar c = DateUtil.getTomorrow();
        return DateUtil.getString(c, format);
    }

    public static String getTomorrowString() {
        return DateUtil.getTomorrowString(FORMAT_YYYYMMDD);
    }

    public static String getTodayString(String format) {
        return DateUtil.getString(Calendar.getInstance(), format);
    }

    public static String getTodayString() {
        return DateUtil.getTodayString(FORMAT_YYYYMMDD);
    }

    public static Calendar getLastMonth(Calendar c) {
        c = c == null ? Calendar.getInstance() : (Calendar)c.clone();
        int y = c.get(1);
        int m = c.get(2);
        if (m == 0) {
            c.set(1, y - 1);
            c.set(2, 11);
        } else {
            c.set(2, m - 1);
        }
        return c;
    }

    public static Calendar getLastMonth() {
        return DateUtil.getLastMonth(null);
    }

    public static Calendar getNextMonth(Calendar c) {
        c = c == null ? Calendar.getInstance() : (Calendar)c.clone();
        int y = c.get(1);
        int m = c.get(2);
        if (m == 11) {
            c.set(1, y + 1);
            c.set(2, 0);
        } else {
            c.set(2, m + 1);
        }
        return c;
    }

    public static Calendar getNextMonth() {
        return DateUtil.getNextMonth(null);
    }

    public static String getLastMonthString(String format) {
        Calendar c = DateUtil.getLastMonth();
        return DateUtil.getString(c, format);
    }

    public static String getLastMonthString() {
        return DateUtil.getLastMonthString(FORMAT_YYYYMM);
    }

    public static String getNextMonthString(String format) {
        Calendar c = DateUtil.getNextMonth();
        return DateUtil.getString(c, format);
    }

    public static String getNextMonthString() {
        return DateUtil.getNextMonthString(FORMAT_YYYYMM);
    }

    public static String getThisMonthString(String format) {
        return DateUtil.getString(Calendar.getInstance(), format);
    }

    public static String getThisMonthString() {
        return DateUtil.getThisMonthString(FORMAT_YYYYMM);
    }

    public static int toDayOfWeek(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Day-of-week-string is null.");
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 2;
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 3;
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 4;
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 5;
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 6;
        }
        if ("\ufffdy".equals(str)) {
            return 7;
        }
        if ("\ufffd\ufffd".equals(str)) {
            return 1;
        }
        throw new IllegalArgumentException("Day-of-week-string is invalid.");
    }

    public static int validate(String date, String format) throws DateFormatException {
        int iMonth;
        Integer[] iDate = DateUtil.dateSplit(date, format);
        Integer year = iDate[0];
        Integer month = iDate[1];
        Integer day = iDate[2];
        if (month != null && ((iMonth = month.intValue()) < 1 || 12 < iMonth)) {
            return 1;
        }
        if (day != null) {
            GregorianCalendar gc;
            int iMonth2;
            int iDay = day;
            if (iDay < 1) {
                return 1;
            }
            if (month == null ? iDay < 1 || 31 < iDay : ((iMonth2 = month.intValue()) == 1 ? iDay > 31 : (iMonth2 == 2 ? (year == null ? iDay > 29 : ((gc = new GregorianCalendar()).isLeapYear(year) ? iDay > 29 : iDay > 28)) : (iMonth2 == 3 ? iDay > 31 : (iMonth2 == 4 ? iDay > 30 : (iMonth2 == 5 ? iDay > 31 : (iMonth2 == 6 ? iDay > 30 : (iMonth2 == 7 ? iDay > 31 : (iMonth2 == 8 ? iDay > 31 : (iMonth2 == 9 ? iDay > 30 : (iMonth2 == 10 ? iDay > 31 : (iMonth2 == 11 ? iDay > 30 : iMonth2 == 12 && iDay > 31)))))))))))) {
                return 1;
            }
        }
        return 0;
    }

    private static Integer[] dateSplit(String dateString, String format) throws DateFormatException {
        Integer[] ret = null;
        if (format.equals(FORMAT_YYYYMMDD)) {
            if (dateString.length() != FORMAT_YYYYMMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString.substring(0, 4)), new Integer(dateString.substring(4, 6)), new Integer(dateString.substring(6, 8))};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_YYYYMM)) {
            if (dateString.length() != FORMAT_YYYYMM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString.substring(0, 4)), new Integer(dateString.substring(4, 6)), null};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_YYMMDD)) {
            if (dateString.length() != FORMAT_YYMMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString.substring(0, 2)), new Integer(dateString.substring(2, 4)), new Integer(dateString.substring(4, 6))};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_YYMM)) {
            if (dateString.length() != FORMAT_YYMM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString.substring(0, 2)), new Integer(dateString.substring(2, 4)), null};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_MMDD)) {
            if (dateString.length() != FORMAT_MMDD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{null, new Integer(dateString.substring(0, 2)), new Integer(dateString.substring(2, 4))};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_YYYY)) {
            if (dateString.length() != FORMAT_YYYY.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString), null, null};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_YY)) {
            if (dateString.length() != FORMAT_YY.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{new Integer(dateString), null, null};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_MM)) {
            if (dateString.length() != FORMAT_MM.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{null, new Integer(dateString), null};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else if (format.equals(FORMAT_DD)) {
            if (dateString.length() != FORMAT_DD.length()) {
                throw new DateFormatException("date is illegal-length. date = " + dateString + ", format = " + format);
            }
            try {
                ret = new Integer[]{null, null, new Integer(dateString)};
            }
            catch (NumberFormatException e) {
                throw new DateFormatException("date is illegal-format. date = " + dateString + ", format = " + format);
            }
        } else {
            throw new DateFormatException("format is illegal. date = " + dateString + ", format = " + format);
        }
        return ret;
    }
}

