/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import jp.hrtdotnet.java.util.Comparison;
import jp.hrtdotnet.java.util.StringUtil;

public class IntegerUtil {
    public static boolean isBitFlag(int bitInteger, int bitFlag) {
        return ((bitInteger ^= bitFlag) & bitFlag) == 0;
    }

    public static int setBitFlag(int bitInteger, int bitFlag, boolean b) {
        bitInteger |= bitFlag;
        if (!b) {
            bitInteger ^= bitFlag;
        }
        return bitInteger;
    }

    public static int setBitFlag(int bitInteger, int bitFlag) {
        return bitInteger ^= bitFlag;
    }

    public static int toNumber(char c) {
        StringUtil.toSingleByteChar(c);
        if (c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        if (c == '4') {
            return 4;
        }
        if (c == '5') {
            return 5;
        }
        if (c == '6') {
            return 6;
        }
        if (c == '7') {
            return 7;
        }
        if (c == '8') {
            return 8;
        }
        if (c == '9') {
            return 9;
        }
        throw new NumberFormatException("Char is not a number : " + c);
    }

    public static int toInt(String str) {
        if (!IntegerUtil.isInt(str)) {
            throw new IllegalArgumentException("Default value is not a integer.");
        }
        return Integer.parseInt(str);
    }

    public static int toIntIgnoreError(String str) {
        return IntegerUtil.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (!IntegerUtil.isInt(str)) {
            return defaultValue;
        }
        return IntegerUtil.toInt(str);
    }

    public static int toNatural(String str, int defaultValue) {
        if (defaultValue < 0) {
            throw new IllegalArgumentException("Default value is not a natural number.");
        }
        try {
            return IntegerUtil.toNatural(str);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int toNatural(String str) {
        if (!IntegerUtil.isNumber(str)) {
            throw new IllegalArgumentException("Argument is not a natural number.");
        }
        return Integer.parseInt(str);
    }

    public static int toNaturalIgnoreError(String str) {
        return IntegerUtil.toNatural(str, 0);
    }

    public static boolean isInteger(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (IntegerUtil.isNumber(c[i]) || i == 0 && c[0] == '-' && c.length > 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerSingleByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (IntegerUtil.isNumberSingleByte(c[i]) || i == 0 && c[0] == '-' && c.length > 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerMultiByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (IntegerUtil.isNumberMultiByte(c[i]) || i == 0 && c.length > 1 && (c[0] == '\u2212' || c[0] == '\uff0d')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c >= '\uff10' && c <= '\uff19';
    }

    public static boolean isNumberSingleByte(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumberMultiByte(char c) {
        return c >= '\uff10' && c <= '\uff19';
    }

    public static boolean isNumber(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (IntegerUtil.isNumber(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumberMultiByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (IntegerUtil.isNumberMultiByte(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumberSingleByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (IntegerUtil.isNumberSingleByte(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInt(String str) {
        if (!IntegerUtil.isInteger(str)) {
            return false;
        }
        return IntegerUtil.isIntLocal(str);
    }

    public static boolean isIntSingleByte(String str) {
        if (!IntegerUtil.isIntegerSingleByte(str)) {
            return false;
        }
        return IntegerUtil.isIntLocal(str);
    }

    public static boolean isIntMultiByte(String str) {
        if (!IntegerUtil.isIntegerMultiByte(str)) {
            return false;
        }
        return IntegerUtil.isIntLocal(str);
    }

    private static boolean isIntLocal(String str) {
        if (!Comparison.comparisonIntegerLocal(str, Integer.toString(Integer.MIN_VALUE))) {
            return false;
        }
        return Comparison.comparisonIntegerLocal(Integer.toString(Integer.MAX_VALUE), str);
    }
}

