/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtil {
    private static final int UNICODE_MULTIBYTE = 1;
    private static final int UNICODE_ALL = 2;

    public static boolean isAlphabet(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\uff21' && c <= '\uff3a' || c >= '\uff41' && c <= '\uff5a';
    }

    public static boolean isAlphabet(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isAlphabet(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean includeChar(String str, char c) {
        return StringUtil.includeChar(str, c, true);
    }

    public static boolean includeChar(String str, char c, boolean em) {
        if (str == null || str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c2;
            char c1;
            if (!(!em ? (c1 = Character.toLowerCase(str.charAt(i))) == (c2 = Character.toLowerCase(c)) : str.charAt(i) == c)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkFrontSpace(String str) {
        return StringUtil.checkFrontSpace(str, false);
    }

    public static boolean checkFrontSpace(String str, boolean em) {
        if (str == null || str.equals("")) {
            return false;
        }
        if (str.substring(0, 1).equals(" ")) {
            return true;
        }
        return em && str.substring(0, 1).equals("\ufffd@");
    }

    public static boolean checkRearSpace(String str) {
        return StringUtil.checkRearSpace(str, false);
    }

    public static boolean checkRearSpace(String str, boolean em) {
        if (str == null || str.equals("")) {
            return false;
        }
        if (str.substring(str.length() - 1).equals(" ")) {
            return true;
        }
        return em && str.substring(str.length() - 1).equals("\ufffd@");
    }

    public static char toSingleByteChar(char c) {
        if (Character.toString(c).getBytes().length == 1) {
            return c;
        }
        if (c >= '\uff10' && c <= '\uff19' || c >= '\uff21' && c <= '\uff3a' || c >= '\uff41' && c <= '\uff5a') {
            return (char)(c - 65296 + 48);
        }
        if (c == '\u2212' || c == '\uff0d') {
            return '-';
        }
        throw new IllegalArgumentException("Char can't convert single-byte : " + c);
    }

    public static String toSingleByteString(String str) {
        if (str == null) {
            throw new NullPointerException("Argument is null.");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException("Argument is empty.");
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            c[i] = StringUtil.toSingleByteChar(c[i]);
        }
        return new String(c);
    }

    public static String toUnicodeHexMultiByte(String str) {
        return StringUtil.toUnicodeHex(str, 1);
    }

    public static String toUnicodeHex(String str) {
        return StringUtil.toUnicodeHex(str, 2);
    }

    public static String toUnicodeString(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if ('\\' == str.charAt(i)) {
                int i2 = i + 1;
                if ('u' == str.charAt(i2) || 'U' == str.charAt(i2)) {
                    try {
                        ++i2;
                        while ('u' == str.charAt(i2) || 'U' == str.charAt(i2)) {
                            ++i2;
                        }
                        sb.append((char)Integer.parseInt(str.substring(i2, i2 + 4), 16));
                        i = i2 + 3;
                    }
                    catch (Exception e) {
                        sb.append(str.charAt(i));
                    }
                    continue;
                }
                sb.append(str.charAt(i));
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String[] csvSplit(String line, String delim) {
        return StringUtil.csvSplit(line, delim, '\"');
    }

    public static String[] csvSplit(String line, String delim, char quot) {
        if (line == null) {
            return null;
        }
        if (delim == null || delim.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (line.indexOf(quot) == -1) {
            return line.split(delim);
        }
        int index = 0;
        int delimX = line.indexOf(delim);
        int quotX = line.indexOf(quot);
        int delimLength = delim.length();
        boolean quotLength = true;
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            if (delimX == -1) {
                list.add(StringUtil.csvConvert(line.substring(index), quot));
                break;
            }
            if (delimX < quotX || quotX == -1) {
                list.add(StringUtil.csvConvert(line.substring(index, delimX), quot));
                index = delimX + delimLength;
                delimX = line.indexOf(delim, index);
                quotX = line.indexOf(quot, index);
                continue;
            }
            if ((quotX = line.indexOf(quot, quotX + 1)) == -1) {
                list.add(StringUtil.csvConvert(line.substring(index), quot));
                break;
            }
            delimX = line.indexOf(delim, quotX + 1);
            quotX = line.indexOf(quot, quotX + 1);
        }
        return list.toArray(new String[0]);
    }

    public static String[] split(String str, String delim) {
        if (str == null || delim == null) {
            throw new NullPointerException("The values of argument are null.");
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    private static String toUnicodeHex(String str, int stat) {
        if (str == null) {
            return null;
        }
        if (str.length() < 1) {
            return "";
        }
        char[] c = str.toCharArray();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '\u007f') {
                if (stat == 2) {
                    ret.append("\\u");
                    ret.append(StringUtil.toHexFromBytes(c[i]));
                    continue;
                }
                if (stat != 1) continue;
                ret.append(c[i]);
                continue;
            }
            ret.append("\\u");
            ret.append(StringUtil.toHexFromBytes(c[i]));
        }
        return ret.toString();
    }

    private static StringBuffer toHexFromBytes(char c) {
        StringBuffer sb = new StringBuffer(Integer.toHexString(c));
        int i = 0;
        while (sb.length() < 4) {
            sb.insert(0, 0);
            ++i;
        }
        return sb;
    }

    private static String csvConvert(String str, char quot) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == quot) {
                if (i == str.length() - 1) continue;
                buf.append(str.charAt(++i));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toBinaryString(int number) {
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(number));
        for (int j = sb.length(); j < 32; ++j) {
            sb.insert(0, 0);
        }
        return sb.toString();
    }

    public static String completeZero(int number, int digit) {
        if (number < 0 || digit < 0) {
            throw new IllegalArgumentException("The argument can not specify a negative value.");
        }
        StringBuffer sb = new StringBuffer(Integer.toString(number));
        for (int j = sb.length(); j < digit; ++j) {
            sb.insert(0, 0);
        }
        return sb.toString();
    }
}

