/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

public class BooleanUtil {
    public static boolean toBoolean(String str, boolean defaultValue) {
        return BooleanUtil.toBool(str, new Boolean(defaultValue));
    }

    public static boolean toBooleanLowerCase(String str, boolean defaultValue) {
        return BooleanUtil.toBoolLowerCase(str, new Boolean(defaultValue));
    }

    public static boolean toBooleanUpperCase(String str, boolean defaultValue) {
        return BooleanUtil.toBoolUpperCase(str, new Boolean(defaultValue));
    }

    public static boolean toBoolean(String str) throws IllegalArgumentException {
        return BooleanUtil.toBool(str);
    }

    public static boolean toBooleanLowerCase(String str) throws IllegalArgumentException {
        return BooleanUtil.toBoolLowerCase(str);
    }

    public static boolean toBooleanUpperCase(String str) throws IllegalArgumentException {
        return BooleanUtil.toBoolUpperCase(str);
    }

    public static Boolean toBool(String str, Boolean defaultValue) throws IllegalArgumentException {
        if (!BooleanUtil.isBoolean(str)) {
            return defaultValue;
        }
        return new Boolean(str.toLowerCase());
    }

    public static Boolean toBoolLowerCase(String str, Boolean defaultValue) throws IllegalArgumentException {
        if (!BooleanUtil.isBooleanLowerCase(str)) {
            return defaultValue;
        }
        return new Boolean(str);
    }

    public static Boolean toBoolUpperCase(String str, Boolean defaultValue) throws IllegalArgumentException {
        if (!BooleanUtil.isBooleanUpperCase(str)) {
            return defaultValue;
        }
        return new Boolean(str.toLowerCase());
    }

    public static Boolean toBool(String str) throws IllegalArgumentException {
        if (!BooleanUtil.isBoolean(str)) {
            throw new IllegalArgumentException("Argument is not a boolean-type : " + str);
        }
        return new Boolean(str.toLowerCase());
    }

    public static Boolean toBoolLowerCase(String str) {
        if (!BooleanUtil.isBooleanLowerCase(str)) {
            throw new IllegalArgumentException("Argument(str) is not a boolean-type.");
        }
        return new Boolean(str);
    }

    public static Boolean toBoolUpperCase(String str) {
        if (!BooleanUtil.isBooleanUpperCase(str)) {
            throw new IllegalArgumentException("Argument(str) is not a boolean-type.");
        }
        return new Boolean(str.toLowerCase());
    }

    public static boolean isBoolean(String str) {
        if (str == null) {
            return false;
        }
        return (str = str.toLowerCase()).equals("true") || str.equals("false");
    }

    public static boolean isBooleanLowerCase(String str) {
        if (str == null) {
            return false;
        }
        return "true".equals(str) || "false".equals(str);
    }

    public static boolean isBooleanUpperCase(String str) {
        if (str == null) {
            return false;
        }
        return "TRUE".equals(str) || "FALSE".equals(str);
    }
}

