<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>


<xsl:template match="/nidx:index">
    <xsl:for-each select="/nidx:index/nidx:note">
        <xsl:sort select="./@timestamp" data-type="number" order="ascending"/>
        <xsl:if test="@year = $nidx:year and @month = $nidx:month and @day = $nidx:day and @hour = $nidx:hour and @minute = $nidx:minute and @second = $nidx:second">
        <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::document', string(./@internal_id))"/>
            <sdf:document xml:lang="ja">
                <sdf:meta>
                    <dc:title>
                        <xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
                        <xsl:text>::</xsl:text>
                        <xsl:value-of select="$nidx:year"/>
                        <xsl:text>-</xsl:text>
                        <xsl:value-of select="$nidx:month"/>
                        <xsl:text>-</xsl:text>
                        <xsl:value-of select="$nidx:day"/>
                        <xsl:text>::</xsl:text>
                        <xsl:copy-of select="./dc:title/node()"/>
                    </dc:title>
                    <xsl:copy-of select="$nidx:current_note/nt:note/*[not(local-name() = 'body' and namespace-uri() = 'http://www.arielworks.net/works/codeyard/himmel/xnm') and
                                                                      not(local-name() = 'title' and namespace-uri() = 'http://purl.org/dc/elements/1.1/')]"/>
                    <link rel="up" href="../{@day}" title="{$nts:settings/nts:value[@name = 'siteName']}::{@year}-{@month}-{@day}"/>
                    <xsl:if test="following-sibling::nidx:note">
                        <link rel="next" href="./{following-sibling::nidx:note[1]/@hour}{following-sibling::nidx:note[1]/@minute}{following-sibling::nidx:note[1]/@second}" title="{following-sibling::nidx:note[1]/dc:title}"/>
                    </xsl:if>
                    <xsl:if test="preceding-sibling::nidx:note">
                        <link rel="prev" href="./{preceding-sibling::nidx:note[1]/@hour}{preceding-sibling::nidx:note[1]/@minute}{preceding-sibling::nidx:note[1]/@second}" title="{following-sibling::nidx:note[1]/dc:title}"/>
                    </xsl:if>
                </sdf:meta>
                <sdf:body>
                    <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
                </sdf:body>
            </sdf:document>
        </xsl:if>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>