<?php
class Xnm_DataControllerFileSystem extends Xnm_DataController {
    protected $dataDirectory = "./Data";

    protected function getItratorToBuildIndex() {
        print_r( stat($this->dataDirectory));
        return new Xnm_ItratorToBuildIndexFileSystem($this->dataDirectory); 
    }

    public function loadData($internalId) {
        $targetDom = new DomDocument();
        $targetDom->load($internalId);
        return $targetDom;
    }
}

class Xnm_ItratorToBuildIndexFileSystem {
    private $fileList = array();
    private $pointer = 0;

    public function __construct($dataDirectory) {
        $this->fileList = $this->makeFileList($dataDirectory);
    }

    public function next() {
        $internalId = $this->fileList[$this->pointer];
        $dom = new DomDocument();
        $dom->load($internalId);
        $this->pointer++;
        $result = array(
            "internalId" => $internalId,
            "dom" => $dom
        );
        return $result;
    }

    public function hasNext() {
        if ($this->pointer < count($this->fileList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    private function makeFileList($targetDir) {
        $fileList = array();
        if ($dir = dir($targetDir)) {
            while (FALSE !== ($currentTgt = $dir->read())) {
                if ($currentTgt != "." && $currentTgt != "..") {
                    if (is_dir($targetDir . "/" . $currentTgt)) {
                        array_merge($fileList, $this->makeFileList($targetDir . "/" . $currentTgt));
                    } elseif (preg_match('/\.xml/', $currentTgt)) {
                        $filePath = realpath(dirname(__FILE__) . "/" . $targetDir . "/" . $currentTgt);
                        $fileList[] = $filePath;
                    }
                }
            }
            $dir->close();
        } else {
            throw new Exception("Directory open Error: " . $targetDir);
        }
        return $fileList;
    }
}
?>